// runtime can't be in strict mode because a global variable is assign and maybe created.
(self["webpackChunk_N_E"] = self["webpackChunk_N_E"] || []).push([[727],{

/***/ 488:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ nHandler)
});

// NAMESPACE OBJECT: ./src/middleware.ts
var middleware_namespaceObject = {};
__webpack_require__.r(middleware_namespaceObject);
__webpack_require__.d(middleware_namespaceObject, {
  config: () => (config),
  "default": () => (middlewareWrapperTemplate),
  middleware: () => (middleware)
});

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/globals.js
async function registerInstrumentation() {
    if ("_ENTRIES" in globalThis && _ENTRIES.middleware_instrumentation && _ENTRIES.middleware_instrumentation.register) {
        try {
            await _ENTRIES.middleware_instrumentation.register();
        } catch (err) {
            err.message = `An error occurred while loading instrumentation hook: ${err.message}`;
            throw err;
        }
    }
}
let registerInstrumentationPromise = null;
function ensureInstrumentationRegistered() {
    if (!registerInstrumentationPromise) {
        registerInstrumentationPromise = registerInstrumentation();
    }
    return registerInstrumentationPromise;
}
function getUnsupportedModuleErrorMessage(module) {
    // warning: if you change these messages, you must adjust how react-dev-overlay's middleware detects modules not found
    return `The edge runtime does not support Node.js '${module}' module.
Learn More: https://nextjs.org/docs/messages/node-module-in-edge-runtime`;
}
function __import_unsupported(moduleName) {
    const proxy = new Proxy(function() {}, {
        get (_obj, prop) {
            if (prop === "then") {
                return {};
            }
            throw new Error(getUnsupportedModuleErrorMessage(moduleName));
        },
        construct () {
            throw new Error(getUnsupportedModuleErrorMessage(moduleName));
        },
        apply (_target, _this, args) {
            if (typeof args[0] === "function") {
                return args[0](proxy);
            }
            throw new Error(getUnsupportedModuleErrorMessage(moduleName));
        }
    });
    return new Proxy({}, {
        get: ()=>proxy
    });
}
function enhanceGlobals() {
    // The condition is true when the "process" module is provided
    if (process !== __webpack_require__.g.process) {
        // prefer local process but global.process has correct "env"
        process.env = __webpack_require__.g.process.env;
        __webpack_require__.g.process = process;
    }
    // to allow building code that import but does not use node.js modules,
    // webpack will expect this function to exist in global scope
    Object.defineProperty(globalThis, "__import_unsupported", {
        value: __import_unsupported,
        enumerable: false,
        configurable: false
    });
    // Eagerly fire instrumentation hook to make the startup faster.
    void ensureInstrumentationRegistered();
}
enhanceGlobals(); //# sourceMappingURL=globals.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/error.js
class PageSignatureError extends Error {
    constructor({ page }){
        super(`The middleware "${page}" accepts an async API directly with the form:
  
  export function middleware(request, event) {
    return NextResponse.redirect('/new-location')
  }
  
  Read more: https://nextjs.org/docs/messages/middleware-new-signature
  `);
    }
}
class RemovedPageError extends Error {
    constructor(){
        super(`The request.page has been deprecated in favour of \`URLPattern\`.
  Read more: https://nextjs.org/docs/messages/middleware-request-page
  `);
    }
}
class RemovedUAError extends Error {
    constructor(){
        super(`The request.ua has been removed in favour of \`userAgent\` function.
  Read more: https://nextjs.org/docs/messages/middleware-parse-user-agent
  `);
    }
} //# sourceMappingURL=error.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/utils.js
/**
 * Converts a Node.js IncomingHttpHeaders object to a Headers object. Any
 * headers with multiple values will be joined with a comma and space. Any
 * headers that have an undefined value will be ignored and others will be
 * coerced to strings.
 *
 * @param nodeHeaders the headers object to convert
 * @returns the converted headers object
 */ function fromNodeOutgoingHttpHeaders(nodeHeaders) {
    const headers = new Headers();
    for (let [key, value] of Object.entries(nodeHeaders)){
        const values = Array.isArray(value) ? value : [
            value
        ];
        for (let v of values){
            if (typeof v === "undefined") continue;
            if (typeof v === "number") {
                v = v.toString();
            }
            headers.append(key, v);
        }
    }
    return headers;
}
/*
  Set-Cookie header field-values are sometimes comma joined in one string. This splits them without choking on commas
  that are within a single set-cookie field-value, such as in the Expires portion.
  This is uncommon, but explicitly allowed - see https://tools.ietf.org/html/rfc2616#section-4.2
  Node.js does this for every header *except* set-cookie - see https://github.com/nodejs/node/blob/d5e363b77ebaf1caf67cd7528224b651c86815c1/lib/_http_incoming.js#L128
  React Native's fetch does this for *every* header, including set-cookie.
  
  Based on: https://github.com/google/j2objc/commit/16820fdbc8f76ca0c33472810ce0cb03d20efe25
  Credits to: https://github.com/tomball for original and https://github.com/chrusart for JavaScript implementation
*/ function splitCookiesString(cookiesString) {
    var cookiesStrings = [];
    var pos = 0;
    var start;
    var ch;
    var lastComma;
    var nextStart;
    var cookiesSeparatorFound;
    function skipWhitespace() {
        while(pos < cookiesString.length && /\s/.test(cookiesString.charAt(pos))){
            pos += 1;
        }
        return pos < cookiesString.length;
    }
    function notSpecialChar() {
        ch = cookiesString.charAt(pos);
        return ch !== "=" && ch !== ";" && ch !== ",";
    }
    while(pos < cookiesString.length){
        start = pos;
        cookiesSeparatorFound = false;
        while(skipWhitespace()){
            ch = cookiesString.charAt(pos);
            if (ch === ",") {
                // ',' is a cookie separator if we have later first '=', not ';' or ','
                lastComma = pos;
                pos += 1;
                skipWhitespace();
                nextStart = pos;
                while(pos < cookiesString.length && notSpecialChar()){
                    pos += 1;
                }
                // currently special character
                if (pos < cookiesString.length && cookiesString.charAt(pos) === "=") {
                    // we found cookies separator
                    cookiesSeparatorFound = true;
                    // pos is inside the next cookie, so back up and return it.
                    pos = nextStart;
                    cookiesStrings.push(cookiesString.substring(start, lastComma));
                    start = pos;
                } else {
                    // in param ',' or param separator ';',
                    // we continue from that comma
                    pos = lastComma + 1;
                }
            } else {
                pos += 1;
            }
        }
        if (!cookiesSeparatorFound || pos >= cookiesString.length) {
            cookiesStrings.push(cookiesString.substring(start, cookiesString.length));
        }
    }
    return cookiesStrings;
}
/**
 * Converts a Headers object to a Node.js OutgoingHttpHeaders object. This is
 * required to support the set-cookie header, which may have multiple values.
 *
 * @param headers the headers object to convert
 * @returns the converted headers object
 */ function toNodeOutgoingHttpHeaders(headers) {
    const nodeHeaders = {};
    const cookies = [];
    if (headers) {
        for (const [key, value] of headers.entries()){
            if (key.toLowerCase() === "set-cookie") {
                // We may have gotten a comma joined string of cookies, or multiple
                // set-cookie headers. We need to merge them into one header array
                // to represent all the cookies.
                cookies.push(...splitCookiesString(value));
                nodeHeaders[key] = cookies.length === 1 ? cookies[0] : cookies;
            } else {
                nodeHeaders[key] = value;
            }
        }
    }
    return nodeHeaders;
}
/**
 * Validate the correctness of a user-provided URL.
 */ function validateURL(url) {
    try {
        return String(new URL(String(url)));
    } catch (error) {
        throw new Error(`URL is malformed "${String(url)}". Please use only absolute URLs - https://nextjs.org/docs/messages/middleware-relative-urls`, {
            cause: error
        });
    }
} //# sourceMappingURL=utils.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/fetch-event.js

const responseSymbol = Symbol("response");
const passThroughSymbol = Symbol("passThrough");
const waitUntilSymbol = Symbol("waitUntil");
class FetchEvent {
    // eslint-disable-next-line @typescript-eslint/no-useless-constructor
    constructor(_request){
        this[waitUntilSymbol] = [];
        this[passThroughSymbol] = false;
    }
    respondWith(response) {
        if (!this[responseSymbol]) {
            this[responseSymbol] = Promise.resolve(response);
        }
    }
    passThroughOnException() {
        this[passThroughSymbol] = true;
    }
    waitUntil(promise) {
        this[waitUntilSymbol].push(promise);
    }
}
class NextFetchEvent extends FetchEvent {
    constructor(params){
        super(params.request);
        this.sourcePage = params.page;
    }
    /**
   * @deprecated The `request` is now the first parameter and the API is now async.
   *
   * Read more: https://nextjs.org/docs/messages/middleware-new-signature
   */ get request() {
        throw new PageSignatureError({
            page: this.sourcePage
        });
    }
    /**
   * @deprecated Using `respondWith` is no longer needed.
   *
   * Read more: https://nextjs.org/docs/messages/middleware-new-signature
   */ respondWith() {
        throw new PageSignatureError({
            page: this.sourcePage
        });
    }
} //# sourceMappingURL=fetch-event.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/i18n/detect-domain-locale.js
function detectDomainLocale(domainItems, hostname, detectedLocale) {
    if (!domainItems) return;
    if (detectedLocale) {
        detectedLocale = detectedLocale.toLowerCase();
    }
    for (const item of domainItems){
        var _item_domain, _item_locales;
        // remove port if present
        const domainHostname = (_item_domain = item.domain) == null ? void 0 : _item_domain.split(":")[0].toLowerCase();
        if (hostname === domainHostname || detectedLocale === item.defaultLocale.toLowerCase() || ((_item_locales = item.locales) == null ? void 0 : _item_locales.some((locale)=>locale.toLowerCase() === detectedLocale))) {
            return item;
        }
    }
} //# sourceMappingURL=detect-domain-locale.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/remove-trailing-slash.js
/**
 * Removes the trailing slash for a given route or page path. Preserves the
 * root page. Examples:
 *   - `/foo/bar/` -> `/foo/bar`
 *   - `/foo/bar` -> `/foo/bar`
 *   - `/` -> `/`
 */ function removeTrailingSlash(route) {
    return route.replace(/\/$/, "") || "/";
} //# sourceMappingURL=remove-trailing-slash.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/parse-path.js
/**
 * Given a path this function will find the pathname, query and hash and return
 * them. This is useful to parse full paths on the client side.
 * @param path A path to parse e.g. /foo/bar?id=1#hash
 */ function parsePath(path) {
    const hashIndex = path.indexOf("#");
    const queryIndex = path.indexOf("?");
    const hasQuery = queryIndex > -1 && (hashIndex < 0 || queryIndex < hashIndex);
    if (hasQuery || hashIndex > -1) {
        return {
            pathname: path.substring(0, hasQuery ? queryIndex : hashIndex),
            query: hasQuery ? path.substring(queryIndex, hashIndex > -1 ? hashIndex : undefined) : "",
            hash: hashIndex > -1 ? path.slice(hashIndex) : ""
        };
    }
    return {
        pathname: path,
        query: "",
        hash: ""
    };
} //# sourceMappingURL=parse-path.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/add-path-prefix.js

/**
 * Adds the provided prefix to the given path. It first ensures that the path
 * is indeed starting with a slash.
 */ function addPathPrefix(path, prefix) {
    if (!path.startsWith("/") || !prefix) {
        return path;
    }
    const { pathname, query, hash } = parsePath(path);
    return "" + prefix + pathname + query + hash;
} //# sourceMappingURL=add-path-prefix.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/add-path-suffix.js

/**
 * Similarly to `addPathPrefix`, this function adds a suffix at the end on the
 * provided path. It also works only for paths ensuring the argument starts
 * with a slash.
 */ function addPathSuffix(path, suffix) {
    if (!path.startsWith("/") || !suffix) {
        return path;
    }
    const { pathname, query, hash } = parsePath(path);
    return "" + pathname + suffix + query + hash;
} //# sourceMappingURL=add-path-suffix.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/path-has-prefix.js

/**
 * Checks if a given path starts with a given prefix. It ensures it matches
 * exactly without containing extra chars. e.g. prefix /docs should replace
 * for /docs, /docs/, /docs/a but not /docsss
 * @param path The path to check.
 * @param prefix The prefix to check against.
 */ function pathHasPrefix(path, prefix) {
    if (typeof path !== "string") {
        return false;
    }
    const { pathname } = parsePath(path);
    return pathname === prefix || pathname.startsWith(prefix + "/");
} //# sourceMappingURL=path-has-prefix.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/add-locale.js


/**
 * For a given path and a locale, if the locale is given, it will prefix the
 * locale. The path shouldn't be an API path. If a default locale is given the
 * prefix will be omitted if the locale is already the default locale.
 */ function addLocale(path, locale, defaultLocale, ignorePrefix) {
    // If no locale was given or the locale is the default locale, we don't need
    // to prefix the path.
    if (!locale || locale === defaultLocale) return path;
    const lower = path.toLowerCase();
    // If the path is an API path or the path already has the locale prefix, we
    // don't need to prefix the path.
    if (!ignorePrefix) {
        if (pathHasPrefix(lower, "/api")) return path;
        if (pathHasPrefix(lower, "/" + locale.toLowerCase())) return path;
    }
    // Add the locale prefix to the path.
    return addPathPrefix(path, "/" + locale);
} //# sourceMappingURL=add-locale.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/format-next-pathname-info.js




function formatNextPathnameInfo(info) {
    let pathname = addLocale(info.pathname, info.locale, info.buildId ? undefined : info.defaultLocale, info.ignorePrefix);
    if (info.buildId || !info.trailingSlash) {
        pathname = removeTrailingSlash(pathname);
    }
    if (info.buildId) {
        pathname = addPathSuffix(addPathPrefix(pathname, "/_next/data/" + info.buildId), info.pathname === "/" ? "index.json" : ".json");
    }
    pathname = addPathPrefix(pathname, info.basePath);
    return !info.buildId && info.trailingSlash ? !pathname.endsWith("/") ? addPathSuffix(pathname, "/") : pathname : removeTrailingSlash(pathname);
} //# sourceMappingURL=format-next-pathname-info.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/get-hostname.js
/**
 * Takes an object with a hostname property (like a parsed URL) and some
 * headers that may contain Host and returns the preferred hostname.
 * @param parsed An object containing a hostname property.
 * @param headers A dictionary with headers containing a `host`.
 */ function getHostname(parsed, headers) {
    // Get the hostname from the headers if it exists, otherwise use the parsed
    // hostname.
    let hostname;
    if ((headers == null ? void 0 : headers.host) && !Array.isArray(headers.host)) {
        hostname = headers.host.toString().split(":")[0];
    } else if (parsed.hostname) {
        hostname = parsed.hostname;
    } else return;
    return hostname.toLowerCase();
} //# sourceMappingURL=get-hostname.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/i18n/normalize-locale-path.js
/**
 * For a pathname that may include a locale from a list of locales, it
 * removes the locale from the pathname returning it alongside with the
 * detected locale.
 *
 * @param pathname A pathname that may include a locale.
 * @param locales A list of locales.
 * @returns The detected locale and pathname without locale
 */ function normalizeLocalePath(pathname, locales) {
    let detectedLocale;
    // first item will be empty string from splitting at first char
    const pathnameParts = pathname.split("/");
    (locales || []).some((locale)=>{
        if (pathnameParts[1] && pathnameParts[1].toLowerCase() === locale.toLowerCase()) {
            detectedLocale = locale;
            pathnameParts.splice(1, 1);
            pathname = pathnameParts.join("/") || "/";
            return true;
        }
        return false;
    });
    return {
        pathname,
        detectedLocale
    };
} //# sourceMappingURL=normalize-locale-path.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/remove-path-prefix.js

/**
 * Given a path and a prefix it will remove the prefix when it exists in the
 * given path. It ensures it matches exactly without containing extra chars
 * and if the prefix is not there it will be noop.
 *
 * @param path The path to remove the prefix from.
 * @param prefix The prefix to be removed.
 */ function removePathPrefix(path, prefix) {
    // If the path doesn't start with the prefix we can return it as is. This
    // protects us from situations where the prefix is a substring of the path
    // prefix such as:
    //
    // For prefix: /blog
    //
    //   /blog -> true
    //   /blog/ -> true
    //   /blog/1 -> true
    //   /blogging -> false
    //   /blogging/ -> false
    //   /blogging/1 -> false
    if (!pathHasPrefix(path, prefix)) {
        return path;
    }
    // Remove the prefix from the path via slicing.
    const withoutPrefix = path.slice(prefix.length);
    // If the path without the prefix starts with a `/` we can return it as is.
    if (withoutPrefix.startsWith("/")) {
        return withoutPrefix;
    }
    // If the path without the prefix doesn't start with a `/` we need to add it
    // back to the path to make sure it's a valid path.
    return "/" + withoutPrefix;
} //# sourceMappingURL=remove-path-prefix.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/get-next-pathname-info.js



function getNextPathnameInfo(pathname, options) {
    var _options_nextConfig;
    const { basePath, i18n, trailingSlash } = (_options_nextConfig = options.nextConfig) != null ? _options_nextConfig : {};
    const info = {
        pathname,
        trailingSlash: pathname !== "/" ? pathname.endsWith("/") : trailingSlash
    };
    if (basePath && pathHasPrefix(info.pathname, basePath)) {
        info.pathname = removePathPrefix(info.pathname, basePath);
        info.basePath = basePath;
    }
    let pathnameNoDataPrefix = info.pathname;
    if (info.pathname.startsWith("/_next/data/") && info.pathname.endsWith(".json")) {
        const paths = info.pathname.replace(/^\/_next\/data\//, "").replace(/\.json$/, "").split("/");
        const buildId = paths[0];
        info.buildId = buildId;
        pathnameNoDataPrefix = paths[1] !== "index" ? "/" + paths.slice(1).join("/") : "/";
        // update pathname with normalized if enabled although
        // we use normalized to populate locale info still
        if (options.parseData === true) {
            info.pathname = pathnameNoDataPrefix;
        }
    }
    // If provided, use the locale route normalizer to detect the locale instead
    // of the function below.
    if (i18n) {
        let result = options.i18nProvider ? options.i18nProvider.analyze(info.pathname) : normalizeLocalePath(info.pathname, i18n.locales);
        info.locale = result.detectedLocale;
        var _result_pathname;
        info.pathname = (_result_pathname = result.pathname) != null ? _result_pathname : info.pathname;
        if (!result.detectedLocale && info.buildId) {
            result = options.i18nProvider ? options.i18nProvider.analyze(pathnameNoDataPrefix) : normalizeLocalePath(pathnameNoDataPrefix, i18n.locales);
            if (result.detectedLocale) {
                info.locale = result.detectedLocale;
            }
        }
    }
    return info;
} //# sourceMappingURL=get-next-pathname-info.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/next-url.js




const REGEX_LOCALHOST_HOSTNAME = /(?!^https?:\/\/)(127(?:\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}|\[::1\]|localhost)/;
function parseURL(url, base) {
    return new URL(String(url).replace(REGEX_LOCALHOST_HOSTNAME, "localhost"), base && String(base).replace(REGEX_LOCALHOST_HOSTNAME, "localhost"));
}
const Internal = Symbol("NextURLInternal");
class NextURL {
    constructor(input, baseOrOpts, opts){
        let base;
        let options;
        if (typeof baseOrOpts === "object" && "pathname" in baseOrOpts || typeof baseOrOpts === "string") {
            base = baseOrOpts;
            options = opts || {};
        } else {
            options = opts || baseOrOpts || {};
        }
        this[Internal] = {
            url: parseURL(input, base ?? options.base),
            options: options,
            basePath: ""
        };
        this.analyze();
    }
    analyze() {
        var _this_Internal_options_nextConfig_i18n, _this_Internal_options_nextConfig, _this_Internal_domainLocale, _this_Internal_options_nextConfig_i18n1, _this_Internal_options_nextConfig1;
        const info = getNextPathnameInfo(this[Internal].url.pathname, {
            nextConfig: this[Internal].options.nextConfig,
            parseData: !undefined,
            i18nProvider: this[Internal].options.i18nProvider
        });
        const hostname = getHostname(this[Internal].url, this[Internal].options.headers);
        this[Internal].domainLocale = this[Internal].options.i18nProvider ? this[Internal].options.i18nProvider.detectDomainLocale(hostname) : detectDomainLocale((_this_Internal_options_nextConfig = this[Internal].options.nextConfig) == null ? void 0 : (_this_Internal_options_nextConfig_i18n = _this_Internal_options_nextConfig.i18n) == null ? void 0 : _this_Internal_options_nextConfig_i18n.domains, hostname);
        const defaultLocale = ((_this_Internal_domainLocale = this[Internal].domainLocale) == null ? void 0 : _this_Internal_domainLocale.defaultLocale) || ((_this_Internal_options_nextConfig1 = this[Internal].options.nextConfig) == null ? void 0 : (_this_Internal_options_nextConfig_i18n1 = _this_Internal_options_nextConfig1.i18n) == null ? void 0 : _this_Internal_options_nextConfig_i18n1.defaultLocale);
        this[Internal].url.pathname = info.pathname;
        this[Internal].defaultLocale = defaultLocale;
        this[Internal].basePath = info.basePath ?? "";
        this[Internal].buildId = info.buildId;
        this[Internal].locale = info.locale ?? defaultLocale;
        this[Internal].trailingSlash = info.trailingSlash;
    }
    formatPathname() {
        return formatNextPathnameInfo({
            basePath: this[Internal].basePath,
            buildId: this[Internal].buildId,
            defaultLocale: !this[Internal].options.forceLocale ? this[Internal].defaultLocale : undefined,
            locale: this[Internal].locale,
            pathname: this[Internal].url.pathname,
            trailingSlash: this[Internal].trailingSlash
        });
    }
    formatSearch() {
        return this[Internal].url.search;
    }
    get buildId() {
        return this[Internal].buildId;
    }
    set buildId(buildId) {
        this[Internal].buildId = buildId;
    }
    get locale() {
        return this[Internal].locale ?? "";
    }
    set locale(locale) {
        var _this_Internal_options_nextConfig_i18n, _this_Internal_options_nextConfig;
        if (!this[Internal].locale || !((_this_Internal_options_nextConfig = this[Internal].options.nextConfig) == null ? void 0 : (_this_Internal_options_nextConfig_i18n = _this_Internal_options_nextConfig.i18n) == null ? void 0 : _this_Internal_options_nextConfig_i18n.locales.includes(locale))) {
            throw new TypeError(`The NextURL configuration includes no locale "${locale}"`);
        }
        this[Internal].locale = locale;
    }
    get defaultLocale() {
        return this[Internal].defaultLocale;
    }
    get domainLocale() {
        return this[Internal].domainLocale;
    }
    get searchParams() {
        return this[Internal].url.searchParams;
    }
    get host() {
        return this[Internal].url.host;
    }
    set host(value) {
        this[Internal].url.host = value;
    }
    get hostname() {
        return this[Internal].url.hostname;
    }
    set hostname(value) {
        this[Internal].url.hostname = value;
    }
    get port() {
        return this[Internal].url.port;
    }
    set port(value) {
        this[Internal].url.port = value;
    }
    get protocol() {
        return this[Internal].url.protocol;
    }
    set protocol(value) {
        this[Internal].url.protocol = value;
    }
    get href() {
        const pathname = this.formatPathname();
        const search = this.formatSearch();
        return `${this.protocol}//${this.host}${pathname}${search}${this.hash}`;
    }
    set href(url) {
        this[Internal].url = parseURL(url);
        this.analyze();
    }
    get origin() {
        return this[Internal].url.origin;
    }
    get pathname() {
        return this[Internal].url.pathname;
    }
    set pathname(value) {
        this[Internal].url.pathname = value;
    }
    get hash() {
        return this[Internal].url.hash;
    }
    set hash(value) {
        this[Internal].url.hash = value;
    }
    get search() {
        return this[Internal].url.search;
    }
    set search(value) {
        this[Internal].url.search = value;
    }
    get password() {
        return this[Internal].url.password;
    }
    set password(value) {
        this[Internal].url.password = value;
    }
    get username() {
        return this[Internal].url.username;
    }
    set username(value) {
        this[Internal].url.username = value;
    }
    get basePath() {
        return this[Internal].basePath;
    }
    set basePath(value) {
        this[Internal].basePath = value.startsWith("/") ? value : `/${value}`;
    }
    toString() {
        return this.href;
    }
    toJSON() {
        return this.href;
    }
    [Symbol.for("edge-runtime.inspect.custom")]() {
        return {
            href: this.href,
            origin: this.origin,
            protocol: this.protocol,
            username: this.username,
            password: this.password,
            host: this.host,
            hostname: this.hostname,
            port: this.port,
            pathname: this.pathname,
            search: this.search,
            searchParams: this.searchParams,
            hash: this.hash
        };
    }
    clone() {
        return new NextURL(String(this), this[Internal].options);
    }
} //# sourceMappingURL=next-url.js.map

// EXTERNAL MODULE: ./node_modules/next/dist/compiled/@edge-runtime/cookies/index.js
var _edge_runtime_cookies = __webpack_require__(7);
;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/cookies.js
 //# sourceMappingURL=cookies.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/request.js




const INTERNALS = Symbol("internal request");
class NextRequest extends Request {
    constructor(input, init = {}){
        const url = typeof input !== "string" && "url" in input ? input.url : String(input);
        validateURL(url);
        if (input instanceof Request) super(input, init);
        else super(url, init);
        const nextUrl = new NextURL(url, {
            headers: toNodeOutgoingHttpHeaders(this.headers),
            nextConfig: init.nextConfig
        });
        this[INTERNALS] = {
            cookies: new _edge_runtime_cookies.RequestCookies(this.headers),
            geo: init.geo || {},
            ip: init.ip,
            nextUrl,
            url:  false ? 0 : nextUrl.toString()
        };
    }
    [Symbol.for("edge-runtime.inspect.custom")]() {
        return {
            cookies: this.cookies,
            geo: this.geo,
            ip: this.ip,
            nextUrl: this.nextUrl,
            url: this.url,
            // rest of props come from Request
            bodyUsed: this.bodyUsed,
            cache: this.cache,
            credentials: this.credentials,
            destination: this.destination,
            headers: Object.fromEntries(this.headers),
            integrity: this.integrity,
            keepalive: this.keepalive,
            method: this.method,
            mode: this.mode,
            redirect: this.redirect,
            referrer: this.referrer,
            referrerPolicy: this.referrerPolicy,
            signal: this.signal
        };
    }
    get cookies() {
        return this[INTERNALS].cookies;
    }
    get geo() {
        return this[INTERNALS].geo;
    }
    get ip() {
        return this[INTERNALS].ip;
    }
    get nextUrl() {
        return this[INTERNALS].nextUrl;
    }
    /**
   * @deprecated
   * `page` has been deprecated in favour of `URLPattern`.
   * Read more: https://nextjs.org/docs/messages/middleware-request-page
   */ get page() {
        throw new RemovedPageError();
    }
    /**
   * @deprecated
   * `ua` has been removed in favour of \`userAgent\` function.
   * Read more: https://nextjs.org/docs/messages/middleware-parse-user-agent
   */ get ua() {
        throw new RemovedUAError();
    }
    get url() {
        return this[INTERNALS].url;
    }
} //# sourceMappingURL=request.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/response.js



const response_INTERNALS = Symbol("internal response");
const REDIRECTS = new Set([
    301,
    302,
    303,
    307,
    308
]);
function handleMiddlewareField(init, headers) {
    var _init_request;
    if (init == null ? void 0 : (_init_request = init.request) == null ? void 0 : _init_request.headers) {
        if (!(init.request.headers instanceof Headers)) {
            throw new Error("request.headers must be an instance of Headers");
        }
        const keys = [];
        for (const [key, value] of init.request.headers){
            headers.set("x-middleware-request-" + key, value);
            keys.push(key);
        }
        headers.set("x-middleware-override-headers", keys.join(","));
    }
}
class NextResponse extends Response {
    constructor(body, init = {}){
        super(body, init);
        this[response_INTERNALS] = {
            cookies: new _edge_runtime_cookies.ResponseCookies(this.headers),
            url: init.url ? new NextURL(init.url, {
                headers: toNodeOutgoingHttpHeaders(this.headers),
                nextConfig: init.nextConfig
            }) : undefined
        };
    }
    [Symbol.for("edge-runtime.inspect.custom")]() {
        return {
            cookies: this.cookies,
            url: this.url,
            // rest of props come from Response
            body: this.body,
            bodyUsed: this.bodyUsed,
            headers: Object.fromEntries(this.headers),
            ok: this.ok,
            redirected: this.redirected,
            status: this.status,
            statusText: this.statusText,
            type: this.type
        };
    }
    get cookies() {
        return this[response_INTERNALS].cookies;
    }
    static json(body, init) {
        const response = Response.json(body, init);
        return new NextResponse(response.body, response);
    }
    static redirect(url, init) {
        const status = typeof init === "number" ? init : (init == null ? void 0 : init.status) ?? 307;
        if (!REDIRECTS.has(status)) {
            throw new RangeError('Failed to execute "redirect" on "response": Invalid status code');
        }
        const initObj = typeof init === "object" ? init : {};
        const headers = new Headers(initObj == null ? void 0 : initObj.headers);
        headers.set("Location", validateURL(url));
        return new NextResponse(null, {
            ...initObj,
            headers,
            status
        });
    }
    static rewrite(destination, init) {
        const headers = new Headers(init == null ? void 0 : init.headers);
        headers.set("x-middleware-rewrite", validateURL(destination));
        handleMiddlewareField(init, headers);
        return new NextResponse(null, {
            ...init,
            headers
        });
    }
    static next(init) {
        const headers = new Headers(init == null ? void 0 : init.headers);
        headers.set("x-middleware-next", "1");
        handleMiddlewareField(init, headers);
        return new NextResponse(null, {
            ...init,
            headers
        });
    }
} //# sourceMappingURL=response.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/relativize-url.js
/**
 * Given a URL as a string and a base URL it will make the URL relative
 * if the parsed protocol and host is the same as the one in the base
 * URL. Otherwise it returns the same URL string.
 */ function relativizeURL(url, base) {
    const baseURL = typeof base === "string" ? new URL(base) : base;
    const relative = new URL(url, base);
    const origin = baseURL.protocol + "//" + baseURL.host;
    return relative.protocol + "//" + relative.host === origin ? relative.toString().replace(origin, "") : relative.toString();
} //# sourceMappingURL=relativize-url.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/client/components/app-router-headers.js
const RSC = "RSC";
const ACTION = "Next-Action";
const NEXT_ROUTER_STATE_TREE = "Next-Router-State-Tree";
const NEXT_ROUTER_PREFETCH = "Next-Router-Prefetch";
const NEXT_URL = "Next-Url";
const RSC_CONTENT_TYPE_HEADER = "text/x-component";
const RSC_VARY_HEADER = RSC + ", " + NEXT_ROUTER_STATE_TREE + ", " + NEXT_ROUTER_PREFETCH + ", " + NEXT_URL;
const FLIGHT_PARAMETERS = [
    [
        RSC
    ],
    [
        NEXT_ROUTER_STATE_TREE
    ],
    [
        NEXT_ROUTER_PREFETCH
    ]
];
const NEXT_RSC_UNION_QUERY = "_rsc"; //# sourceMappingURL=app-router-headers.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/internal-utils.js

const INTERNAL_QUERY_NAMES = [
    "__nextFallback",
    "__nextLocale",
    "__nextInferredLocaleFromDefault",
    "__nextDefaultLocale",
    "__nextIsNotFound",
    NEXT_RSC_UNION_QUERY
];
const EDGE_EXTENDED_INTERNAL_QUERY_NAMES = [
    "__nextDataReq"
];
function stripInternalQueries(query) {
    for (const name of INTERNAL_QUERY_NAMES){
        delete query[name];
    }
}
function stripInternalSearchParams(url, isEdge) {
    const isStringUrl = typeof url === "string";
    const instance = isStringUrl ? new URL(url) : url;
    for (const name of INTERNAL_QUERY_NAMES){
        instance.searchParams.delete(name);
    }
    if (isEdge) {
        for (const name of EDGE_EXTENDED_INTERNAL_QUERY_NAMES){
            instance.searchParams.delete(name);
        }
    }
    return isStringUrl ? instance.toString() : instance;
}
/**
 * Headers that are set by the Next.js server and should be stripped from the
 * request headers going to the user's application.
 */ const INTERNAL_HEADERS = (/* unused pure expression or super */ null && ([
    "x-invoke-path",
    "x-invoke-status",
    "x-invoke-error",
    "x-invoke-query",
    "x-invoke-output",
    "x-middleware-invoke"
]));
/**
 * Strip internal headers from the request headers.
 *
 * @param headers the headers to strip of internal headers
 */ function stripInternalHeaders(headers) {
    for (const key of INTERNAL_HEADERS){
        delete headers[key];
    }
} //# sourceMappingURL=internal-utils.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/shared/lib/router/utils/app-paths.js


/**
 * Normalizes an app route so it represents the actual request path. Essentially
 * performing the following transformations:
 *
 * - `/(dashboard)/user/[id]/page` to `/user/[id]`
 * - `/(dashboard)/account/page` to `/account`
 * - `/user/[id]/page` to `/user/[id]`
 * - `/account/page` to `/account`
 * - `/page` to `/`
 * - `/(dashboard)/user/[id]/route` to `/user/[id]`
 * - `/(dashboard)/account/route` to `/account`
 * - `/user/[id]/route` to `/user/[id]`
 * - `/account/route` to `/account`
 * - `/route` to `/`
 * - `/` to `/`
 *
 * @param route the app route to normalize
 * @returns the normalized pathname
 */ function normalizeAppPath(route) {
    return ensureLeadingSlash(route.split("/").reduce((pathname, segment, index, segments)=>{
        // Empty segments are ignored.
        if (!segment) {
            return pathname;
        }
        // Groups are ignored.
        if (isGroupSegment(segment)) {
            return pathname;
        }
        // Parallel segments are ignored.
        if (segment[0] === "@") {
            return pathname;
        }
        // The last segment (if it's a leaf) should be ignored.
        if ((segment === "page" || segment === "route") && index === segments.length - 1) {
            return pathname;
        }
        return pathname + "/" + segment;
    }, ""));
}
/**
 * Strips the `.rsc` extension if it's in the pathname.
 * Since this function is used on full urls it checks `?` for searchParams handling.
 */ function normalizeRscPath(pathname, enabled) {
    return enabled ? pathname.replace(/\.rsc($|\?)/, "$1") : pathname;
} //# sourceMappingURL=app-paths.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/lib/constants.js
const NEXT_QUERY_PARAM_PREFIX = "nxtP";
const PRERENDER_REVALIDATE_HEADER = "x-prerender-revalidate";
const PRERENDER_REVALIDATE_ONLY_GENERATED_HEADER = "x-prerender-revalidate-if-generated";
const NEXT_CACHE_TAGS_HEADER = "x-next-cache-tags";
const NEXT_CACHE_SOFT_TAGS_HEADER = "x-next-cache-soft-tags";
const NEXT_CACHE_REVALIDATED_TAGS_HEADER = "x-next-revalidated-tags";
const NEXT_CACHE_REVALIDATE_TAG_TOKEN_HEADER = "x-next-revalidate-tag-token";
const NEXT_CACHE_TAG_MAX_LENGTH = 256;
const NEXT_CACHE_SOFT_TAG_MAX_LENGTH = 1024;
const NEXT_CACHE_IMPLICIT_TAG_ID = "_N_T_";
// in seconds
const CACHE_ONE_YEAR = 31536000;
// Patterns to detect middleware files
const MIDDLEWARE_FILENAME = "middleware";
const MIDDLEWARE_LOCATION_REGEXP = (/* unused pure expression or super */ null && (`(?:src/)?${MIDDLEWARE_FILENAME}`));
// Pattern to detect instrumentation hooks file
const INSTRUMENTATION_HOOK_FILENAME = "instrumentation";
// Because on Windows absolute paths in the generated code can break because of numbers, eg 1 in the path,
// we have to use a private alias
const PAGES_DIR_ALIAS = "private-next-pages";
const DOT_NEXT_ALIAS = "private-dot-next";
const ROOT_DIR_ALIAS = "private-next-root-dir";
const APP_DIR_ALIAS = "private-next-app-dir";
const RSC_MOD_REF_PROXY_ALIAS = "private-next-rsc-mod-ref-proxy";
const RSC_ACTION_VALIDATE_ALIAS = "private-next-rsc-action-validate";
const RSC_ACTION_PROXY_ALIAS = "private-next-rsc-action-proxy";
const RSC_ACTION_CLIENT_WRAPPER_ALIAS = "private-next-rsc-action-client-wrapper";
const PUBLIC_DIR_MIDDLEWARE_CONFLICT = (/* unused pure expression or super */ null && (`You can not have a '_next' folder inside of your public folder. This conflicts with the internal '/_next' route. https://nextjs.org/docs/messages/public-next-folder-conflict`));
const SSG_GET_INITIAL_PROPS_CONFLICT = (/* unused pure expression or super */ null && (`You can not use getInitialProps with getStaticProps. To use SSG, please remove your getInitialProps`));
const SERVER_PROPS_GET_INIT_PROPS_CONFLICT = (/* unused pure expression or super */ null && (`You can not use getInitialProps with getServerSideProps. Please remove getInitialProps.`));
const SERVER_PROPS_SSG_CONFLICT = (/* unused pure expression or super */ null && (`You can not use getStaticProps or getStaticPaths with getServerSideProps. To use SSG, please remove getServerSideProps`));
const STATIC_STATUS_PAGE_GET_INITIAL_PROPS_ERROR = (/* unused pure expression or super */ null && (`can not have getInitialProps/getServerSideProps, https://nextjs.org/docs/messages/404-get-initial-props`));
const SERVER_PROPS_EXPORT_ERROR = (/* unused pure expression or super */ null && (`pages with \`getServerSideProps\` can not be exported. See more info here: https://nextjs.org/docs/messages/gssp-export`));
const GSP_NO_RETURNED_VALUE = "Your `getStaticProps` function did not return an object. Did you forget to add a `return`?";
const GSSP_NO_RETURNED_VALUE = "Your `getServerSideProps` function did not return an object. Did you forget to add a `return`?";
const UNSTABLE_REVALIDATE_RENAME_ERROR = (/* unused pure expression or super */ null && ("The `unstable_revalidate` property is available for general use.\n" + "Please use `revalidate` instead."));
const GSSP_COMPONENT_MEMBER_ERROR = (/* unused pure expression or super */ null && (`can not be attached to a page's component and must be exported from the page. See more info here: https://nextjs.org/docs/messages/gssp-component-member`));
const NON_STANDARD_NODE_ENV = (/* unused pure expression or super */ null && (`You are using a non-standard "NODE_ENV" value in your environment. This creates inconsistencies in the project and is strongly advised against. Read more: https://nextjs.org/docs/messages/non-standard-node-env`));
const SSG_FALLBACK_EXPORT_ERROR = (/* unused pure expression or super */ null && (`Pages with \`fallback\` enabled in \`getStaticPaths\` can not be exported. See more info here: https://nextjs.org/docs/messages/ssg-fallback-true-export`));
const ESLINT_DEFAULT_DIRS = (/* unused pure expression or super */ null && ([
    "app",
    "pages",
    "components",
    "lib",
    "src"
]));
const ESLINT_PROMPT_VALUES = [
    {
        title: "Strict",
        recommended: true,
        config: {
            extends: "next/core-web-vitals"
        }
    },
    {
        title: "Base",
        config: {
            extends: "next"
        }
    },
    {
        title: "Cancel",
        config: null
    }
];
const SERVER_RUNTIME = {
    edge: "edge",
    experimentalEdge: "experimental-edge",
    nodejs: "nodejs"
};
/**
 * The names of the webpack layers. These layers are the primitives for the
 * webpack chunks.
 */ const WEBPACK_LAYERS_NAMES = {
    /**
   * The layer for the shared code between the client and server bundles.
   */ shared: "shared",
    /**
   * React Server Components layer (rsc).
   */ reactServerComponents: "rsc",
    /**
   * Server Side Rendering layer for app (ssr).
   */ serverSideRendering: "ssr",
    /**
   * The browser client bundle layer for actions.
   */ actionBrowser: "action-browser",
    /**
   * The layer for the API routes.
   */ api: "api",
    /**
   * The layer for the middleware code.
   */ middleware: "middleware",
    /**
   * The layer for assets on the edge.
   */ edgeAsset: "edge-asset",
    /**
   * The browser client bundle layer for App directory.
   */ appPagesBrowser: "app-pages-browser",
    /**
   * The server bundle layer for metadata routes.
   */ appMetadataRoute: "app-metadata-route",
    /**
   * The layer for the server bundle for App Route handlers.
   */ appRouteHandler: "app-route-handler"
};
const WEBPACK_LAYERS = {
    ...WEBPACK_LAYERS_NAMES,
    GROUP: {
        server: [
            WEBPACK_LAYERS_NAMES.reactServerComponents,
            WEBPACK_LAYERS_NAMES.actionBrowser,
            WEBPACK_LAYERS_NAMES.appMetadataRoute,
            WEBPACK_LAYERS_NAMES.appRouteHandler
        ],
        nonClientServerTarget: [
            // plus middleware and pages api
            WEBPACK_LAYERS_NAMES.middleware,
            WEBPACK_LAYERS_NAMES.api
        ],
        app: [
            WEBPACK_LAYERS_NAMES.reactServerComponents,
            WEBPACK_LAYERS_NAMES.actionBrowser,
            WEBPACK_LAYERS_NAMES.appMetadataRoute,
            WEBPACK_LAYERS_NAMES.appRouteHandler,
            WEBPACK_LAYERS_NAMES.serverSideRendering,
            WEBPACK_LAYERS_NAMES.appPagesBrowser
        ]
    }
};
const WEBPACK_RESOURCE_QUERIES = {
    edgeSSREntry: "__next_edge_ssr_entry__",
    metadata: "__next_metadata__",
    metadataRoute: "__next_metadata_route__",
    metadataImageMeta: "__next_metadata_image_meta__"
};
 //# sourceMappingURL=constants.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/adapters/reflect.js
class ReflectAdapter {
    static get(target, prop, receiver) {
        const value = Reflect.get(target, prop, receiver);
        if (typeof value === "function") {
            return value.bind(target);
        }
        return value;
    }
    static set(target, prop, value, receiver) {
        return Reflect.set(target, prop, value, receiver);
    }
    static has(target, prop) {
        return Reflect.has(target, prop);
    }
    static deleteProperty(target, prop) {
        return Reflect.deleteProperty(target, prop);
    }
} //# sourceMappingURL=reflect.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/adapters/headers.js

/**
 * @internal
 */ class ReadonlyHeadersError extends Error {
    constructor(){
        super("Headers cannot be modified. Read more: https://nextjs.org/docs/app/api-reference/functions/headers");
    }
    static callable() {
        throw new ReadonlyHeadersError();
    }
}
class HeadersAdapter extends Headers {
    constructor(headers){
        // We've already overridden the methods that would be called, so we're just
        // calling the super constructor to ensure that the instanceof check works.
        super();
        this.headers = new Proxy(headers, {
            get (target, prop, receiver) {
                // Because this is just an object, we expect that all "get" operations
                // are for properties. If it's a "get" for a symbol, we'll just return
                // the symbol.
                if (typeof prop === "symbol") {
                    return ReflectAdapter.get(target, prop, receiver);
                }
                const lowercased = prop.toLowerCase();
                // Let's find the original casing of the key. This assumes that there is
                // no mixed case keys (e.g. "Content-Type" and "content-type") in the
                // headers object.
                const original = Object.keys(headers).find((o)=>o.toLowerCase() === lowercased);
                // If the original casing doesn't exist, return undefined.
                if (typeof original === "undefined") return;
                // If the original casing exists, return the value.
                return ReflectAdapter.get(target, original, receiver);
            },
            set (target, prop, value, receiver) {
                if (typeof prop === "symbol") {
                    return ReflectAdapter.set(target, prop, value, receiver);
                }
                const lowercased = prop.toLowerCase();
                // Let's find the original casing of the key. This assumes that there is
                // no mixed case keys (e.g. "Content-Type" and "content-type") in the
                // headers object.
                const original = Object.keys(headers).find((o)=>o.toLowerCase() === lowercased);
                // If the original casing doesn't exist, use the prop as the key.
                return ReflectAdapter.set(target, original ?? prop, value, receiver);
            },
            has (target, prop) {
                if (typeof prop === "symbol") return ReflectAdapter.has(target, prop);
                const lowercased = prop.toLowerCase();
                // Let's find the original casing of the key. This assumes that there is
                // no mixed case keys (e.g. "Content-Type" and "content-type") in the
                // headers object.
                const original = Object.keys(headers).find((o)=>o.toLowerCase() === lowercased);
                // If the original casing doesn't exist, return false.
                if (typeof original === "undefined") return false;
                // If the original casing exists, return true.
                return ReflectAdapter.has(target, original);
            },
            deleteProperty (target, prop) {
                if (typeof prop === "symbol") return ReflectAdapter.deleteProperty(target, prop);
                const lowercased = prop.toLowerCase();
                // Let's find the original casing of the key. This assumes that there is
                // no mixed case keys (e.g. "Content-Type" and "content-type") in the
                // headers object.
                const original = Object.keys(headers).find((o)=>o.toLowerCase() === lowercased);
                // If the original casing doesn't exist, return true.
                if (typeof original === "undefined") return true;
                // If the original casing exists, delete the property.
                return ReflectAdapter.deleteProperty(target, original);
            }
        });
    }
    /**
   * Seals a Headers instance to prevent modification by throwing an error when
   * any mutating method is called.
   */ static seal(headers) {
        return new Proxy(headers, {
            get (target, prop, receiver) {
                switch(prop){
                    case "append":
                    case "delete":
                    case "set":
                        return ReadonlyHeadersError.callable;
                    default:
                        return ReflectAdapter.get(target, prop, receiver);
                }
            }
        });
    }
    /**
   * Merges a header value into a string. This stores multiple values as an
   * array, so we need to merge them into a string.
   *
   * @param value a header value
   * @returns a merged header value (a string)
   */ merge(value) {
        if (Array.isArray(value)) return value.join(", ");
        return value;
    }
    /**
   * Creates a Headers instance from a plain object or a Headers instance.
   *
   * @param headers a plain object or a Headers instance
   * @returns a headers instance
   */ static from(headers) {
        if (headers instanceof Headers) return headers;
        return new HeadersAdapter(headers);
    }
    append(name, value) {
        const existing = this.headers[name];
        if (typeof existing === "string") {
            this.headers[name] = [
                existing,
                value
            ];
        } else if (Array.isArray(existing)) {
            existing.push(value);
        } else {
            this.headers[name] = value;
        }
    }
    delete(name) {
        delete this.headers[name];
    }
    get(name) {
        const value = this.headers[name];
        if (typeof value !== "undefined") return this.merge(value);
        return null;
    }
    has(name) {
        return typeof this.headers[name] !== "undefined";
    }
    set(name, value) {
        this.headers[name] = value;
    }
    forEach(callbackfn, thisArg) {
        for (const [name, value] of this.entries()){
            callbackfn.call(thisArg, value, name, this);
        }
    }
    *entries() {
        for (const key of Object.keys(this.headers)){
            const name = key.toLowerCase();
            // We assert here that this is a string because we got it from the
            // Object.keys() call above.
            const value = this.get(name);
            yield [
                name,
                value
            ];
        }
    }
    *keys() {
        for (const key of Object.keys(this.headers)){
            const name = key.toLowerCase();
            yield name;
        }
    }
    *values() {
        for (const key of Object.keys(this.headers)){
            // We assert here that this is a string because we got it from the
            // Object.keys() call above.
            const value = this.get(key);
            yield value;
        }
    }
    [Symbol.iterator]() {
        return this.entries();
    }
} //# sourceMappingURL=headers.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/spec-extension/adapters/request-cookies.js


/**
 * @internal
 */ class ReadonlyRequestCookiesError extends Error {
    constructor(){
        super("Cookies can only be modified in a Server Action or Route Handler. Read more: https://nextjs.org/docs/app/api-reference/functions/cookies#cookiessetname-value-options");
    }
    static callable() {
        throw new ReadonlyRequestCookiesError();
    }
}
class RequestCookiesAdapter {
    static seal(cookies) {
        return new Proxy(cookies, {
            get (target, prop, receiver) {
                switch(prop){
                    case "clear":
                    case "delete":
                    case "set":
                        return ReadonlyRequestCookiesError.callable;
                    default:
                        return ReflectAdapter.get(target, prop, receiver);
                }
            }
        });
    }
}
const SYMBOL_MODIFY_COOKIE_VALUES = Symbol.for("next.mutated.cookies");
function getModifiedCookieValues(cookies) {
    const modified = cookies[SYMBOL_MODIFY_COOKIE_VALUES];
    if (!modified || !Array.isArray(modified) || modified.length === 0) {
        return [];
    }
    return modified;
}
function appendMutableCookies(headers, mutableCookies) {
    const modifiedCookieValues = getModifiedCookieValues(mutableCookies);
    if (modifiedCookieValues.length === 0) {
        return false;
    }
    // Return a new response that extends the response with
    // the modified cookies as fallbacks. `res` cookies
    // will still take precedence.
    const resCookies = new ResponseCookies(headers);
    const returnedCookies = resCookies.getAll();
    // Set the modified cookies as fallbacks.
    for (const cookie of modifiedCookieValues){
        resCookies.set(cookie);
    }
    // Set the original cookies as the final values.
    for (const cookie of returnedCookies){
        resCookies.set(cookie);
    }
    return true;
}
class MutableRequestCookiesAdapter {
    static wrap(cookies, onUpdateCookies) {
        const responseCookes = new _edge_runtime_cookies.ResponseCookies(new Headers());
        for (const cookie of cookies.getAll()){
            responseCookes.set(cookie);
        }
        let modifiedValues = [];
        const modifiedCookies = new Set();
        const updateResponseCookies = ()=>{
            var _fetch___nextGetStaticStore;
            // TODO-APP: change method of getting staticGenerationAsyncStore
            const staticGenerationAsyncStore = fetch.__nextGetStaticStore == null ? void 0 : (_fetch___nextGetStaticStore = fetch.__nextGetStaticStore.call(fetch)) == null ? void 0 : _fetch___nextGetStaticStore.getStore();
            if (staticGenerationAsyncStore) {
                staticGenerationAsyncStore.pathWasRevalidated = true;
            }
            const allCookies = responseCookes.getAll();
            modifiedValues = allCookies.filter((c)=>modifiedCookies.has(c.name));
            if (onUpdateCookies) {
                const serializedCookies = [];
                for (const cookie of modifiedValues){
                    const tempCookies = new _edge_runtime_cookies.ResponseCookies(new Headers());
                    tempCookies.set(cookie);
                    serializedCookies.push(tempCookies.toString());
                }
                onUpdateCookies(serializedCookies);
            }
        };
        return new Proxy(responseCookes, {
            get (target, prop, receiver) {
                switch(prop){
                    // A special symbol to get the modified cookie values
                    case SYMBOL_MODIFY_COOKIE_VALUES:
                        return modifiedValues;
                    // TODO: Throw error if trying to set a cookie after the response
                    // headers have been set.
                    case "delete":
                        return function(...args) {
                            modifiedCookies.add(typeof args[0] === "string" ? args[0] : args[0].name);
                            try {
                                target.delete(...args);
                            } finally{
                                updateResponseCookies();
                            }
                        };
                    case "set":
                        return function(...args) {
                            modifiedCookies.add(typeof args[0] === "string" ? args[0] : args[0].name);
                            try {
                                return target.set(...args);
                            } finally{
                                updateResponseCookies();
                            }
                        };
                    default:
                        return ReflectAdapter.get(target, prop, receiver);
                }
            }
        });
    }
} //# sourceMappingURL=request-cookies.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/api-utils/index.js


/**
 *
 * @param res response object
 * @param statusCode `HTTP` status code of response
 */ function sendStatusCode(res, statusCode) {
    res.statusCode = statusCode;
    return res;
}
/**
 *
 * @param res response object
 * @param [statusOrUrl] `HTTP` status code of redirect
 * @param url URL of redirect
 */ function redirect(res, statusOrUrl, url) {
    if (typeof statusOrUrl === "string") {
        url = statusOrUrl;
        statusOrUrl = 307;
    }
    if (typeof statusOrUrl !== "number" || typeof url !== "string") {
        throw new Error(`Invalid redirect arguments. Please use a single argument URL, e.g. res.redirect('/destination') or use a status code and URL, e.g. res.redirect(307, '/destination').`);
    }
    res.writeHead(statusOrUrl, {
        Location: url
    });
    res.write(url);
    res.end();
    return res;
}
function checkIsOnDemandRevalidate(req, previewProps) {
    const headers = HeadersAdapter.from(req.headers);
    const previewModeId = headers.get(PRERENDER_REVALIDATE_HEADER);
    const isOnDemandRevalidate = previewModeId === previewProps.previewModeId;
    const revalidateOnlyGenerated = headers.has(PRERENDER_REVALIDATE_ONLY_GENERATED_HEADER);
    return {
        isOnDemandRevalidate,
        revalidateOnlyGenerated
    };
}
const COOKIE_NAME_PRERENDER_BYPASS = `__prerender_bypass`;
const COOKIE_NAME_PRERENDER_DATA = `__next_preview_data`;
const RESPONSE_LIMIT_DEFAULT = (/* unused pure expression or super */ null && (4 * 1024 * 1024));
const SYMBOL_PREVIEW_DATA = Symbol(COOKIE_NAME_PRERENDER_DATA);
const SYMBOL_CLEARED_COOKIES = Symbol(COOKIE_NAME_PRERENDER_BYPASS);
function clearPreviewData(res, options = {}) {
    if (SYMBOL_CLEARED_COOKIES in res) {
        return res;
    }
    const { serialize } = __webpack_require__(666);
    const previous = res.getHeader("Set-Cookie");
    res.setHeader(`Set-Cookie`, [
        ...typeof previous === "string" ? [
            previous
        ] : Array.isArray(previous) ? previous : [],
        serialize(COOKIE_NAME_PRERENDER_BYPASS, "", {
            // To delete a cookie, set `expires` to a date in the past:
            // https://tools.ietf.org/html/rfc6265#section-4.1.1
            // `Max-Age: 0` is not valid, thus ignored, and the cookie is persisted.
            expires: new Date(0),
            httpOnly: true,
            sameSite:  true ? "none" : 0,
            secure: "production" !== "development",
            path: "/",
            ...options.path !== undefined ? {
                path: options.path
            } : undefined
        }),
        serialize(COOKIE_NAME_PRERENDER_DATA, "", {
            // To delete a cookie, set `expires` to a date in the past:
            // https://tools.ietf.org/html/rfc6265#section-4.1.1
            // `Max-Age: 0` is not valid, thus ignored, and the cookie is persisted.
            expires: new Date(0),
            httpOnly: true,
            sameSite:  true ? "none" : 0,
            secure: "production" !== "development",
            path: "/",
            ...options.path !== undefined ? {
                path: options.path
            } : undefined
        })
    ]);
    Object.defineProperty(res, SYMBOL_CLEARED_COOKIES, {
        value: true,
        enumerable: false
    });
    return res;
}
/**
 * Custom error class
 */ class ApiError extends (/* unused pure expression or super */ null && (Error)) {
    constructor(statusCode, message){
        super(message);
        this.statusCode = statusCode;
    }
}
/**
 * Sends error in `response`
 * @param res response object
 * @param statusCode of response
 * @param message of response
 */ function sendError(res, statusCode, message) {
    res.statusCode = statusCode;
    res.statusMessage = message;
    res.end(message);
}
/**
 * Execute getter function only if its needed
 * @param LazyProps `req` and `params` for lazyProp
 * @param prop name of property
 * @param getter function to get data
 */ function setLazyProp({ req }, prop, getter) {
    const opts = {
        configurable: true,
        enumerable: true
    };
    const optsReset = {
        ...opts,
        writable: true
    };
    Object.defineProperty(req, prop, {
        ...opts,
        get: ()=>{
            const value = getter();
            // we set the property on the object to avoid recalculating it
            Object.defineProperty(req, prop, {
                ...optsReset,
                value
            });
            return value;
        },
        set: (value)=>{
            Object.defineProperty(req, prop, {
                ...optsReset,
                value
            });
        }
    });
} //# sourceMappingURL=index.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/async-storage/draft-mode-provider.js

class DraftModeProvider {
    constructor(previewProps, req, cookies, mutableCookies){
        var _cookies_get;
        // The logic for draftMode() is very similar to tryGetPreviewData()
        // but Draft Mode does not have any data associated with it.
        const isOnDemandRevalidate = previewProps && checkIsOnDemandRevalidate(req, previewProps).isOnDemandRevalidate;
        const cookieValue = (_cookies_get = cookies.get(COOKIE_NAME_PRERENDER_BYPASS)) == null ? void 0 : _cookies_get.value;
        this.isEnabled = Boolean(!isOnDemandRevalidate && cookieValue && previewProps && cookieValue === previewProps.previewModeId);
        this._previewModeId = previewProps == null ? void 0 : previewProps.previewModeId;
        this._mutableCookies = mutableCookies;
    }
    enable() {
        if (!this._previewModeId) {
            throw new Error("Invariant: previewProps missing previewModeId this should never happen");
        }
        this._mutableCookies.set({
            name: COOKIE_NAME_PRERENDER_BYPASS,
            value: this._previewModeId,
            httpOnly: true,
            sameSite:  true ? "none" : 0,
            secure: "production" !== "development",
            path: "/"
        });
    }
    disable() {
        // To delete a cookie, set `expires` to a date in the past:
        // https://tools.ietf.org/html/rfc6265#section-4.1.1
        // `Max-Age: 0` is not valid, thus ignored, and the cookie is persisted.
        this._mutableCookies.set({
            name: COOKIE_NAME_PRERENDER_BYPASS,
            value: "",
            httpOnly: true,
            sameSite:  true ? "none" : 0,
            secure: "production" !== "development",
            path: "/",
            expires: new Date(0)
        });
    }
} //# sourceMappingURL=draft-mode-provider.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/async-storage/request-async-storage-wrapper.js





function getHeaders(headers) {
    const cleaned = HeadersAdapter.from(headers);
    for (const param of FLIGHT_PARAMETERS){
        cleaned.delete(param.toString().toLowerCase());
    }
    return HeadersAdapter.seal(cleaned);
}
function getCookies(headers) {
    const cookies = new _edge_runtime_cookies.RequestCookies(HeadersAdapter.from(headers));
    return RequestCookiesAdapter.seal(cookies);
}
function getMutableCookies(headers, onUpdateCookies) {
    const cookies = new _edge_runtime_cookies.RequestCookies(HeadersAdapter.from(headers));
    return MutableRequestCookiesAdapter.wrap(cookies, onUpdateCookies);
}
const RequestAsyncStorageWrapper = {
    /**
   * Wrap the callback with the given store so it can access the underlying
   * store using hooks.
   *
   * @param storage underlying storage object returned by the module
   * @param context context to seed the store
   * @param callback function to call within the scope of the context
   * @returns the result returned by the callback
   */ wrap (storage, { req, res, renderOpts }, callback) {
        let previewProps = undefined;
        if (renderOpts && "previewProps" in renderOpts) {
            // TODO: investigate why previewProps isn't on RenderOpts
            previewProps = renderOpts.previewProps;
        }
        function defaultOnUpdateCookies(cookies) {
            if (res) {
                res.setHeader("Set-Cookie", cookies);
            }
        }
        const cache = {};
        const store = {
            get headers () {
                if (!cache.headers) {
                    // Seal the headers object that'll freeze out any methods that could
                    // mutate the underlying data.
                    cache.headers = getHeaders(req.headers);
                }
                return cache.headers;
            },
            get cookies () {
                if (!cache.cookies) {
                    // Seal the cookies object that'll freeze out any methods that could
                    // mutate the underlying data.
                    cache.cookies = getCookies(req.headers);
                }
                return cache.cookies;
            },
            get mutableCookies () {
                if (!cache.mutableCookies) {
                    cache.mutableCookies = getMutableCookies(req.headers, (renderOpts == null ? void 0 : renderOpts.onUpdateCookies) || (res ? defaultOnUpdateCookies : undefined));
                }
                return cache.mutableCookies;
            },
            get draftMode () {
                if (!cache.draftMode) {
                    cache.draftMode = new DraftModeProvider(previewProps, req, this.cookies, this.mutableCookies);
                }
                return cache.draftMode;
            }
        };
        return storage.run(store, callback, store);
    }
}; //# sourceMappingURL=request-async-storage-wrapper.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/client/components/async-local-storage.js
const sharedAsyncLocalStorageNotAvailableError = new Error("Invariant: AsyncLocalStorage accessed in runtime where it is not available");
class FakeAsyncLocalStorage {
    disable() {
        throw sharedAsyncLocalStorageNotAvailableError;
    }
    getStore() {
        // This fake implementation of AsyncLocalStorage always returns `undefined`.
        return undefined;
    }
    run() {
        throw sharedAsyncLocalStorageNotAvailableError;
    }
    exit() {
        throw sharedAsyncLocalStorageNotAvailableError;
    }
    enterWith() {
        throw sharedAsyncLocalStorageNotAvailableError;
    }
}
const maybeGlobalAsyncLocalStorage = globalThis.AsyncLocalStorage;
function createAsyncLocalStorage() {
    if (maybeGlobalAsyncLocalStorage) {
        return new maybeGlobalAsyncLocalStorage();
    }
    return new FakeAsyncLocalStorage();
} //# sourceMappingURL=async-local-storage.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/client/components/request-async-storage.external.js

const requestAsyncStorage = createAsyncLocalStorage(); //# sourceMappingURL=request-async-storage.external.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/adapter.js















class NextRequestHint extends NextRequest {
    constructor(params){
        super(params.input, params.init);
        this.sourcePage = params.page;
    }
    get request() {
        throw new PageSignatureError({
            page: this.sourcePage
        });
    }
    respondWith() {
        throw new PageSignatureError({
            page: this.sourcePage
        });
    }
    waitUntil() {
        throw new PageSignatureError({
            page: this.sourcePage
        });
    }
}
const adapter_FLIGHT_PARAMETERS = [
    [
        RSC
    ],
    [
        NEXT_ROUTER_STATE_TREE
    ],
    [
        NEXT_ROUTER_PREFETCH
    ]
];
async function adapter(params) {
    await ensureInstrumentationRegistered();
    // TODO-APP: use explicit marker for this
    const isEdgeRendering = typeof self.__BUILD_MANIFEST !== "undefined";
    const prerenderManifest = typeof self.__PRERENDER_MANIFEST === "string" ? JSON.parse(self.__PRERENDER_MANIFEST) : undefined;
    params.request.url = normalizeRscPath(params.request.url, true);
    const requestUrl = new NextURL(params.request.url, {
        headers: params.request.headers,
        nextConfig: params.request.nextConfig
    });
    // Iterator uses an index to keep track of the current iteration. Because of deleting and appending below we can't just use the iterator.
    // Instead we use the keys before iteration.
    const keys = [
        ...requestUrl.searchParams.keys()
    ];
    for (const key of keys){
        const value = requestUrl.searchParams.getAll(key);
        if (key !== NEXT_QUERY_PARAM_PREFIX && key.startsWith(NEXT_QUERY_PARAM_PREFIX)) {
            const normalizedKey = key.substring(NEXT_QUERY_PARAM_PREFIX.length);
            requestUrl.searchParams.delete(normalizedKey);
            for (const val of value){
                requestUrl.searchParams.append(normalizedKey, val);
            }
            requestUrl.searchParams.delete(key);
        }
    }
    // Ensure users only see page requests, never data requests.
    const buildId = requestUrl.buildId;
    requestUrl.buildId = "";
    const isDataReq = params.request.headers["x-nextjs-data"];
    if (isDataReq && requestUrl.pathname === "/index") {
        requestUrl.pathname = "/";
    }
    const requestHeaders = fromNodeOutgoingHttpHeaders(params.request.headers);
    const flightHeaders = new Map();
    // Parameters should only be stripped for middleware
    if (!isEdgeRendering) {
        for (const param of adapter_FLIGHT_PARAMETERS){
            const key = param.toString().toLowerCase();
            const value = requestHeaders.get(key);
            if (value) {
                flightHeaders.set(key, requestHeaders.get(key));
                requestHeaders.delete(key);
            }
        }
    }
    const normalizeUrl =  false ? 0 : requestUrl;
    const request = new NextRequestHint({
        page: params.page,
        // Strip internal query parameters off the request.
        input: stripInternalSearchParams(normalizeUrl, true).toString(),
        init: {
            body: params.request.body,
            geo: params.request.geo,
            headers: requestHeaders,
            ip: params.request.ip,
            method: params.request.method,
            nextConfig: params.request.nextConfig,
            signal: params.request.signal
        }
    });
    /**
   * This allows to identify the request as a data request. The user doesn't
   * need to know about this property neither use it. We add it for testing
   * purposes.
   */ if (isDataReq) {
        Object.defineProperty(request, "__isData", {
            enumerable: false,
            value: true
        });
    }
    if (!globalThis.__incrementalCache && params.IncrementalCache) {
        globalThis.__incrementalCache = new params.IncrementalCache({
            appDir: true,
            fetchCache: true,
            minimalMode: "production" !== "development",
            fetchCacheKeyPrefix: undefined,
            dev: "production" === "development",
            requestHeaders: params.request.headers,
            requestProtocol: "https",
            getPrerenderManifest: ()=>{
                return {
                    version: -1,
                    routes: {},
                    dynamicRoutes: {},
                    notFoundRoutes: [],
                    preview: {
                        previewModeId: "development-id"
                    }
                };
            }
        });
    }
    const event = new NextFetchEvent({
        request,
        page: params.page
    });
    let response;
    let cookiesFromResponse;
    // we only care to make async storage available for middleware
    const isMiddleware = params.page === "/middleware" || params.page === "/src/middleware";
    if (isMiddleware) {
        response = await RequestAsyncStorageWrapper.wrap(requestAsyncStorage, {
            req: request,
            renderOpts: {
                onUpdateCookies: (cookies)=>{
                    cookiesFromResponse = cookies;
                },
                // @ts-expect-error: TODO: investigate why previewProps isn't on RenderOpts
                previewProps: (prerenderManifest == null ? void 0 : prerenderManifest.preview) || {
                    previewModeId: "development-id",
                    previewModeEncryptionKey: "",
                    previewModeSigningKey: ""
                }
            }
        }, ()=>params.handler(request, event));
    } else {
        response = await params.handler(request, event);
    }
    // check if response is a Response object
    if (response && !(response instanceof Response)) {
        throw new TypeError("Expected an instance of Response to be returned");
    }
    if (response && cookiesFromResponse) {
        response.headers.set("set-cookie", cookiesFromResponse);
    }
    /**
   * For rewrites we must always include the locale in the final pathname
   * so we re-create the NextURL forcing it to include it when the it is
   * an internal rewrite. Also we make sure the outgoing rewrite URL is
   * a data URL if the request was a data request.
   */ const rewrite = response == null ? void 0 : response.headers.get("x-middleware-rewrite");
    if (response && rewrite) {
        const rewriteUrl = new NextURL(rewrite, {
            forceLocale: true,
            headers: params.request.headers,
            nextConfig: params.request.nextConfig
        });
        if (true) {
            if (rewriteUrl.host === request.nextUrl.host) {
                rewriteUrl.buildId = buildId || rewriteUrl.buildId;
                response.headers.set("x-middleware-rewrite", String(rewriteUrl));
            }
        }
        /**
     * When the request is a data request we must show if there was a rewrite
     * with an internal header so the client knows which component to load
     * from the data request.
     */ const relativizedRewrite = relativizeURL(String(rewriteUrl), String(requestUrl));
        if (isDataReq && // if the rewrite is external and external rewrite
        // resolving config is enabled don't add this header
        // so the upstream app can set it instead
        !(undefined && 0)) {
            response.headers.set("x-nextjs-rewrite", relativizedRewrite);
        }
    }
    /**
   * For redirects we will not include the locale in case when it is the
   * default and we must also make sure the outgoing URL is a data one if
   * the incoming request was a data request.
   */ const redirect = response == null ? void 0 : response.headers.get("Location");
    if (response && redirect && !isEdgeRendering) {
        const redirectURL = new NextURL(redirect, {
            forceLocale: false,
            headers: params.request.headers,
            nextConfig: params.request.nextConfig
        });
        /**
     * Responses created from redirects have immutable headers so we have
     * to clone the response to be able to modify it.
     */ response = new Response(response.body, response);
        if (true) {
            if (redirectURL.host === request.nextUrl.host) {
                redirectURL.buildId = buildId || redirectURL.buildId;
                response.headers.set("Location", String(redirectURL));
            }
        }
        /**
     * When the request is a data request we can't use the location header as
     * it may end up with CORS error. Instead we map to an internal header so
     * the client knows the destination.
     */ if (isDataReq) {
            response.headers.delete("Location");
            response.headers.set("x-nextjs-redirect", relativizeURL(String(redirectURL), String(requestUrl)));
        }
    }
    const finalResponse = response ? response : NextResponse.next();
    // Flight headers are not overridable / removable so they are applied at the end.
    const middlewareOverrideHeaders = finalResponse.headers.get("x-middleware-override-headers");
    const overwrittenHeaders = [];
    if (middlewareOverrideHeaders) {
        for (const [key, value] of flightHeaders){
            finalResponse.headers.set(`x-middleware-request-${key}`, value);
            overwrittenHeaders.push(key);
        }
        if (overwrittenHeaders.length > 0) {
            finalResponse.headers.set("x-middleware-override-headers", middlewareOverrideHeaders + "," + overwrittenHeaders.join(","));
        }
    }
    return {
        response: finalResponse,
        waitUntil: Promise.all(event[waitUntilSymbol]),
        fetchMetrics: request.fetchMetrics
    };
} //# sourceMappingURL=adapter.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/debug-build.js
/**
 * This serves as a build time flag that will be true by default, but false in non-debug builds or if users replace `__SENTRY_DEBUG__` in their generated code.
 *
 * ATTENTION: This constant must never cross package boundaries (i.e. be exported) to guarantee that it can be used for tree shaking.
 */ const debug_build_DEBUG_BUILD = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
 //# sourceMappingURL=debug-build.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/worldwide.js
/** Internal global with common properties and Sentry extensions  */ // The code below for 'isGlobalObj' and 'GLOBAL_OBJ' was copied from core-js before modification
// https://github.com/zloirock/core-js/blob/1b944df55282cdc99c90db5f49eb0b6eda2cc0a3/packages/core-js/internals/global.js
// core-js has the following licence:
//
// Copyright (c) 2014-2022 Denis Pushkarev
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
/** Returns 'obj' if it's the global object, otherwise returns undefined */ function isGlobalObj(obj) {
    return obj && obj.Math == Math ? obj : undefined;
}
/** Get's the global object for the current JavaScript runtime */ const worldwide_GLOBAL_OBJ = typeof globalThis == "object" && isGlobalObj(globalThis) || // eslint-disable-next-line no-restricted-globals
 false && 0 || typeof self == "object" && isGlobalObj(self) || typeof __webpack_require__.g == "object" && isGlobalObj(__webpack_require__.g) || function() {
    return this;
}() || {};
/**
 * @deprecated Use GLOBAL_OBJ instead or WINDOW from @sentry/browser. This will be removed in v8
 */ function getGlobalObject() {
    return worldwide_GLOBAL_OBJ;
}
/**
 * Returns a global singleton contained in the global `__SENTRY__` object.
 *
 * If the singleton doesn't already exist in `__SENTRY__`, it will be created using the given factory
 * function and added to the `__SENTRY__` object.
 *
 * @param name name of the global singleton on __SENTRY__
 * @param creator creator Factory function to create the singleton if it doesn't already exist on `__SENTRY__`
 * @param obj (Optional) The global object on which to look for `__SENTRY__`, if not `GLOBAL_OBJ`'s return value
 * @returns the singleton
 */ function getGlobalSingleton(name, creator, obj) {
    const gbl = obj || worldwide_GLOBAL_OBJ;
    const __SENTRY__ = gbl.__SENTRY__ = gbl.__SENTRY__ || {};
    const singleton = __SENTRY__[name] || (__SENTRY__[name] = creator());
    return singleton;
}
 //# sourceMappingURL=worldwide.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/logger.js


/** Prefix for logging strings */ const PREFIX = "Sentry Logger ";
const CONSOLE_LEVELS = [
    "debug",
    "info",
    "warn",
    "error",
    "log",
    "assert",
    "trace"
];
/** This may be mutated by the console instrumentation. */ const originalConsoleMethods = {};
/** JSDoc */ /**
 * Temporarily disable sentry console instrumentations.
 *
 * @param callback The function to run against the original `console` messages
 * @returns The results of the callback
 */ function consoleSandbox(callback) {
    if (!("console" in worldwide_GLOBAL_OBJ)) {
        return callback();
    }
    const console = worldwide_GLOBAL_OBJ.console;
    const wrappedFuncs = {};
    const wrappedLevels = Object.keys(originalConsoleMethods);
    // Restore all wrapped console methods
    wrappedLevels.forEach((level)=>{
        const originalConsoleMethod = originalConsoleMethods[level];
        wrappedFuncs[level] = console[level];
        console[level] = originalConsoleMethod;
    });
    try {
        return callback();
    } finally{
        // Revert restoration to wrapped state
        wrappedLevels.forEach((level)=>{
            console[level] = wrappedFuncs[level];
        });
    }
}
function makeLogger() {
    let enabled = false;
    const logger = {
        enable: ()=>{
            enabled = true;
        },
        disable: ()=>{
            enabled = false;
        },
        isEnabled: ()=>enabled
    };
    if (debug_build_DEBUG_BUILD) {
        CONSOLE_LEVELS.forEach((name)=>{
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            logger[name] = (...args)=>{
                if (enabled) {
                    consoleSandbox(()=>{
                        worldwide_GLOBAL_OBJ.console[name](`${PREFIX}[${name}]:`, ...args);
                    });
                }
            };
        });
    } else {
        CONSOLE_LEVELS.forEach((name)=>{
            logger[name] = ()=>undefined;
        });
    }
    return logger;
}
const logger_logger = makeLogger();
 //# sourceMappingURL=logger.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/debug-build.js
/**
 * This serves as a build time flag that will be true by default, but false in non-debug builds or if users replace `__SENTRY_DEBUG__` in their generated code.
 *
 * ATTENTION: This constant must never cross package boundaries (i.e. be exported) to guarantee that it can be used for tree shaking.
 */ const esm_debug_build_DEBUG_BUILD = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
 //# sourceMappingURL=debug-build.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/is.js
// eslint-disable-next-line @typescript-eslint/unbound-method
const objectToString = Object.prototype.toString;
/**
 * Checks whether given value's type is one of a few Error or Error-like
 * {@link isError}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isError(wat) {
    switch(objectToString.call(wat)){
        case "[object Error]":
        case "[object Exception]":
        case "[object DOMException]":
            return true;
        default:
            return is_isInstanceOf(wat, Error);
    }
}
/**
 * Checks whether given value is an instance of the given built-in class.
 *
 * @param wat The value to be checked
 * @param className
 * @returns A boolean representing the result.
 */ function isBuiltin(wat, className) {
    return objectToString.call(wat) === `[object ${className}]`;
}
/**
 * Checks whether given value's type is ErrorEvent
 * {@link isErrorEvent}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isErrorEvent(wat) {
    return isBuiltin(wat, "ErrorEvent");
}
/**
 * Checks whether given value's type is DOMError
 * {@link isDOMError}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isDOMError(wat) {
    return isBuiltin(wat, "DOMError");
}
/**
 * Checks whether given value's type is DOMException
 * {@link isDOMException}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isDOMException(wat) {
    return isBuiltin(wat, "DOMException");
}
/**
 * Checks whether given value's type is a string
 * {@link isString}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isString(wat) {
    return isBuiltin(wat, "String");
}
/**
 * Checks whether given string is parameterized
 * {@link isParameterizedString}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isParameterizedString(wat) {
    return typeof wat === "object" && wat !== null && "__sentry_template_string__" in wat && "__sentry_template_values__" in wat;
}
/**
 * Checks whether given value is a primitive (undefined, null, number, boolean, string, bigint, symbol)
 * {@link isPrimitive}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isPrimitive(wat) {
    return wat === null || isParameterizedString(wat) || typeof wat !== "object" && typeof wat !== "function";
}
/**
 * Checks whether given value's type is an object literal, or a class instance.
 * {@link isPlainObject}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isPlainObject(wat) {
    return isBuiltin(wat, "Object");
}
/**
 * Checks whether given value's type is an Event instance
 * {@link isEvent}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isEvent(wat) {
    return typeof Event !== "undefined" && is_isInstanceOf(wat, Event);
}
/**
 * Checks whether given value's type is an Element instance
 * {@link isElement}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isElement(wat) {
    return typeof Element !== "undefined" && is_isInstanceOf(wat, Element);
}
/**
 * Checks whether given value's type is an regexp
 * {@link isRegExp}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isRegExp(wat) {
    return isBuiltin(wat, "RegExp");
}
/**
 * Checks whether given value has a then function.
 * @param wat A value to be checked.
 */ function is_isThenable(wat) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
    return Boolean(wat && wat.then && typeof wat.then === "function");
}
/**
 * Checks whether given value's type is a SyntheticEvent
 * {@link isSyntheticEvent}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isSyntheticEvent(wat) {
    return is_isPlainObject(wat) && "nativeEvent" in wat && "preventDefault" in wat && "stopPropagation" in wat;
}
/**
 * Checks whether given value is NaN
 * {@link isNaN}.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function is_isNaN(wat) {
    return typeof wat === "number" && wat !== wat;
}
/**
 * Checks whether given value's type is an instance of provided constructor.
 * {@link isInstanceOf}.
 *
 * @param wat A value to be checked.
 * @param base A constructor to be used in a check.
 * @returns A boolean representing the result.
 */ function is_isInstanceOf(wat, base) {
    try {
        return wat instanceof base;
    } catch (_e) {
        return false;
    }
}
/**
 * Checks whether given value's type is a Vue ViewModel.
 *
 * @param wat A value to be checked.
 * @returns A boolean representing the result.
 */ function isVueViewModel(wat) {
    // Not using Object.prototype.toString because in Vue 3 it would read the instance's Symbol(Symbol.toStringTag) property.
    return !!(typeof wat === "object" && wat !== null && (wat.__isVue || wat._isVue));
}
 //# sourceMappingURL=is.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/misc.js



/**
 * UUID4 generator
 *
 * @returns string Generated UUID4.
 */ function misc_uuid4() {
    const gbl = worldwide_GLOBAL_OBJ;
    const crypto = gbl.crypto || gbl.msCrypto;
    let getRandomByte = ()=>Math.random() * 16;
    try {
        if (crypto && crypto.randomUUID) {
            return crypto.randomUUID().replace(/-/g, "");
        }
        if (crypto && crypto.getRandomValues) {
            getRandomByte = ()=>{
                // crypto.getRandomValues might return undefined instead of the typed array
                // in old Chromium versions (e.g. 23.0.1235.0 (151422))
                // However, `typedArray` is still filled in-place.
                // @see https://developer.mozilla.org/en-US/docs/Web/API/Crypto/getRandomValues#typedarray
                const typedArray = new Uint8Array(1);
                crypto.getRandomValues(typedArray);
                return typedArray[0];
            };
        }
    } catch (_) {
    // some runtimes can crash invoking crypto
    // https://github.com/getsentry/sentry-javascript/issues/8935
    }
    // http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/2117523#2117523
    // Concatenating the following numbers as strings results in '10000000100040008000100000000000'
    return ([
        1e7
    ] + 1e3 + 4e3 + 8e3 + 1e11).replace(/[018]/g, (c)=>// eslint-disable-next-line no-bitwise
        (c ^ (getRandomByte() & 15) >> c / 4).toString(16));
}
function getFirstException(event) {
    return event.exception && event.exception.values ? event.exception.values[0] : undefined;
}
/**
 * Extracts either message or type+value from an event that can be used for user-facing logs
 * @returns event's description
 */ function getEventDescription(event) {
    const { message, event_id: eventId } = event;
    if (message) {
        return message;
    }
    const firstException = getFirstException(event);
    if (firstException) {
        if (firstException.type && firstException.value) {
            return `${firstException.type}: ${firstException.value}`;
        }
        return firstException.type || firstException.value || eventId || "<unknown>";
    }
    return eventId || "<unknown>";
}
/**
 * Adds exception values, type and value to an synthetic Exception.
 * @param event The event to modify.
 * @param value Value of the exception.
 * @param type Type of the exception.
 * @hidden
 */ function addExceptionTypeValue(event, value, type) {
    const exception = event.exception = event.exception || {};
    const values = exception.values = exception.values || [];
    const firstException = values[0] = values[0] || {};
    if (!firstException.value) {
        firstException.value = value || "";
    }
    if (!firstException.type) {
        firstException.type = type || "Error";
    }
}
/**
 * Adds exception mechanism data to a given event. Uses defaults if the second parameter is not passed.
 *
 * @param event The event to modify.
 * @param newMechanism Mechanism data to add to the event.
 * @hidden
 */ function misc_addExceptionMechanism(event, newMechanism) {
    const firstException = getFirstException(event);
    if (!firstException) {
        return;
    }
    const defaultMechanism = {
        type: "generic",
        handled: true
    };
    const currentMechanism = firstException.mechanism;
    firstException.mechanism = {
        ...defaultMechanism,
        ...currentMechanism,
        ...newMechanism
    };
    if (newMechanism && "data" in newMechanism) {
        const mergedData = {
            ...currentMechanism && currentMechanism.data,
            ...newMechanism.data
        };
        firstException.mechanism.data = mergedData;
    }
}
// https://semver.org/#is-there-a-suggested-regular-expression-regex-to-check-a-semver-string
const SEMVER_REGEXP = /^(0|[1-9]\d*)\.(0|[1-9]\d*)\.(0|[1-9]\d*)(?:-((?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\.(?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\+([0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)*))?$/;
/**
 * Represents Semantic Versioning object
 */ /**
 * Parses input into a SemVer interface
 * @param input string representation of a semver version
 */ function parseSemver(input) {
    const match = input.match(SEMVER_REGEXP) || [];
    const major = parseInt(match[1], 10);
    const minor = parseInt(match[2], 10);
    const patch = parseInt(match[3], 10);
    return {
        buildmetadata: match[5],
        major: isNaN(major) ? undefined : major,
        minor: isNaN(minor) ? undefined : minor,
        patch: isNaN(patch) ? undefined : patch,
        prerelease: match[4]
    };
}
/**
 * This function adds context (pre/post/line) lines to the provided frame
 *
 * @param lines string[] containing all lines
 * @param frame StackFrame that will be mutated
 * @param linesOfContext number of context lines we want to add pre/post
 */ function addContextToFrame(lines, frame, linesOfContext = 5) {
    // When there is no line number in the frame, attaching context is nonsensical and will even break grouping
    if (frame.lineno === undefined) {
        return;
    }
    const maxLines = lines.length;
    const sourceLine = Math.max(Math.min(maxLines - 1, frame.lineno - 1), 0);
    frame.pre_context = lines.slice(Math.max(0, sourceLine - linesOfContext), sourceLine).map((line)=>snipLine(line, 0));
    frame.context_line = snipLine(lines[Math.min(maxLines - 1, sourceLine)], frame.colno || 0);
    frame.post_context = lines.slice(Math.min(sourceLine + 1, maxLines), sourceLine + 1 + linesOfContext).map((line)=>snipLine(line, 0));
}
/**
 * Checks whether or not we've already captured the given exception (note: not an identical exception - the very object
 * in question), and marks it captured if not.
 *
 * This is useful because it's possible for an error to get captured by more than one mechanism. After we intercept and
 * record an error, we rethrow it (assuming we've intercepted it before it's reached the top-level global handlers), so
 * that we don't interfere with whatever effects the error might have had were the SDK not there. At that point, because
 * the error has been rethrown, it's possible for it to bubble up to some other code we've instrumented. If it's not
 * caught after that, it will bubble all the way up to the global handlers (which of course we also instrument). This
 * function helps us ensure that even if we encounter the same error more than once, we only record it the first time we
 * see it.
 *
 * Note: It will ignore primitives (always return `false` and not mark them as seen), as properties can't be set on
 * them. {@link: Object.objectify} can be used on exceptions to convert any that are primitives into their equivalent
 * object wrapper forms so that this check will always work. However, because we need to flag the exact object which
 * will get rethrown, and because that rethrowing happens outside of the event processing pipeline, the objectification
 * must be done before the exception captured.
 *
 * @param A thrown exception to check or flag as having been seen
 * @returns `true` if the exception has already been captured, `false` if not (with the side effect of marking it seen)
 */ function checkOrSetAlreadyCaught(exception) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
    if (exception && exception.__sentry_captured__) {
        return true;
    }
    try {
        // set it this way rather than by assignment so that it's not ennumerable and therefore isn't recorded by the
        // `ExtraErrorData` integration
        addNonEnumerableProperty(exception, "__sentry_captured__", true);
    } catch (err) {
    // `exception` is a primitive, so we can't mark it seen
    }
    return false;
}
/**
 * Checks whether the given input is already an array, and if it isn't, wraps it in one.
 *
 * @param maybeArray Input to turn into an array, if necessary
 * @returns The input, if already an array, or an array with the input as the only element, if not
 */ function arrayify(maybeArray) {
    return Array.isArray(maybeArray) ? maybeArray : [
        maybeArray
    ];
}
 //# sourceMappingURL=misc.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/time.js

const ONE_SECOND_IN_MS = 1000;
/**
 * A partial definition of the [Performance Web API]{@link https://developer.mozilla.org/en-US/docs/Web/API/Performance}
 * for accessing a high-resolution monotonic clock.
 */ /**
 * Returns a timestamp in seconds since the UNIX epoch using the Date API.
 *
 * TODO(v8): Return type should be rounded.
 */ function time_dateTimestampInSeconds() {
    return Date.now() / ONE_SECOND_IN_MS;
}
/**
 * Returns a wrapper around the native Performance API browser implementation, or undefined for browsers that do not
 * support the API.
 *
 * Wrapping the native API works around differences in behavior from different browsers.
 */ function createUnixTimestampInSecondsFunc() {
    const { performance } = worldwide_GLOBAL_OBJ;
    if (!performance || !performance.now) {
        return time_dateTimestampInSeconds;
    }
    // Some browser and environments don't have a timeOrigin, so we fallback to
    // using Date.now() to compute the starting time.
    const approxStartingTimeOrigin = Date.now() - performance.now();
    const timeOrigin = performance.timeOrigin == undefined ? approxStartingTimeOrigin : performance.timeOrigin;
    // performance.now() is a monotonic clock, which means it starts at 0 when the process begins. To get the current
    // wall clock time (actual UNIX timestamp), we need to add the starting time origin and the current time elapsed.
    //
    // TODO: This does not account for the case where the monotonic clock that powers performance.now() drifts from the
    // wall clock time, which causes the returned timestamp to be inaccurate. We should investigate how to detect and
    // correct for this.
    // See: https://github.com/getsentry/sentry-javascript/issues/2590
    // See: https://github.com/mdn/content/issues/4713
    // See: https://dev.to/noamr/when-a-millisecond-is-not-a-millisecond-3h6
    return ()=>{
        return (timeOrigin + performance.now()) / ONE_SECOND_IN_MS;
    };
}
/**
 * Returns a timestamp in seconds since the UNIX epoch using either the Performance or Date APIs, depending on the
 * availability of the Performance API.
 *
 * BUG: Note that because of how browsers implement the Performance API, the clock might stop when the computer is
 * asleep. This creates a skew between `dateTimestampInSeconds` and `timestampInSeconds`. The
 * skew can grow to arbitrary amounts like days, weeks or months.
 * See https://github.com/getsentry/sentry-javascript/issues/2590.
 */ const time_timestampInSeconds = createUnixTimestampInSecondsFunc();
/**
 * Re-exported with an old name for backwards-compatibility.
 * TODO (v8): Remove this
 *
 * @deprecated Use `timestampInSeconds` instead.
 */ const timestampWithMs = (/* unused pure expression or super */ null && (time_timestampInSeconds));
/**
 * Internal helper to store what is the source of browserPerformanceTimeOrigin below. For debugging only.
 */ let _browserPerformanceTimeOriginMode;
/**
 * The number of milliseconds since the UNIX epoch. This value is only usable in a browser, and only when the
 * performance API is available.
 */ const browserPerformanceTimeOrigin = (()=>{
    // Unfortunately browsers may report an inaccurate time origin data, through either performance.timeOrigin or
    // performance.timing.navigationStart, which results in poor results in performance data. We only treat time origin
    // data as reliable if they are within a reasonable threshold of the current time.
    const { performance } = worldwide_GLOBAL_OBJ;
    if (!performance || !performance.now) {
        _browserPerformanceTimeOriginMode = "none";
        return undefined;
    }
    const threshold = 3600 * 1000;
    const performanceNow = performance.now();
    const dateNow = Date.now();
    // if timeOrigin isn't available set delta to threshold so it isn't used
    const timeOriginDelta = performance.timeOrigin ? Math.abs(performance.timeOrigin + performanceNow - dateNow) : threshold;
    const timeOriginIsReliable = timeOriginDelta < threshold;
    // While performance.timing.navigationStart is deprecated in favor of performance.timeOrigin, performance.timeOrigin
    // is not as widely supported. Namely, performance.timeOrigin is undefined in Safari as of writing.
    // Also as of writing, performance.timing is not available in Web Workers in mainstream browsers, so it is not always
    // a valid fallback. In the absence of an initial time provided by the browser, fallback to the current time from the
    // Date API.
    // eslint-disable-next-line deprecation/deprecation
    const navigationStart = performance.timing && performance.timing.navigationStart;
    const hasNavigationStart = typeof navigationStart === "number";
    // if navigationStart isn't available set delta to threshold so it isn't used
    const navigationStartDelta = hasNavigationStart ? Math.abs(navigationStart + performanceNow - dateNow) : threshold;
    const navigationStartIsReliable = navigationStartDelta < threshold;
    if (timeOriginIsReliable || navigationStartIsReliable) {
        // Use the more reliable time origin
        if (timeOriginDelta <= navigationStartDelta) {
            _browserPerformanceTimeOriginMode = "timeOrigin";
            return performance.timeOrigin;
        } else {
            _browserPerformanceTimeOriginMode = "navigationStart";
            return navigationStart;
        }
    }
    // Either both timeOrigin and navigationStart are skewed or neither is available, fallback to Date.
    _browserPerformanceTimeOriginMode = "dateNow";
    return dateNow;
})();
 //# sourceMappingURL=time.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/constants.js
const constants_DEFAULT_ENVIRONMENT = "production";
 //# sourceMappingURL=constants.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/syncpromise.js

/* eslint-disable @typescript-eslint/explicit-function-return-type */ /** SyncPromise internal states */ var States;
(function(States) {
    /** Pending */ const PENDING = 0;
    States[States["PENDING"] = PENDING] = "PENDING";
    /** Resolved / OK */ const RESOLVED = 1;
    States[States["RESOLVED"] = RESOLVED] = "RESOLVED";
    /** Rejected / Error */ const REJECTED = 2;
    States[States["REJECTED"] = REJECTED] = "REJECTED";
})(States || (States = {}));
// Overloads so we can call resolvedSyncPromise without arguments and generic argument
/**
 * Creates a resolved sync promise.
 *
 * @param value the value to resolve the promise with
 * @returns the resolved sync promise
 */ function resolvedSyncPromise(value) {
    return new SyncPromise((resolve)=>{
        resolve(value);
    });
}
/**
 * Creates a rejected sync promise.
 *
 * @param value the value to reject the promise with
 * @returns the rejected sync promise
 */ function rejectedSyncPromise(reason) {
    return new SyncPromise((_, reject)=>{
        reject(reason);
    });
}
/**
 * Thenable class that behaves like a Promise and follows it's interface
 * but is not async internally
 */ class SyncPromise {
    constructor(executor){
        SyncPromise.prototype.__init.call(this);
        SyncPromise.prototype.__init2.call(this);
        SyncPromise.prototype.__init3.call(this);
        SyncPromise.prototype.__init4.call(this);
        this._state = States.PENDING;
        this._handlers = [];
        try {
            executor(this._resolve, this._reject);
        } catch (e) {
            this._reject(e);
        }
    }
    /** JSDoc */ then(onfulfilled, onrejected) {
        return new SyncPromise((resolve, reject)=>{
            this._handlers.push([
                false,
                (result)=>{
                    if (!onfulfilled) {
                        // TODO: ¯\_(ツ)_/¯
                        // TODO: FIXME
                        resolve(result);
                    } else {
                        try {
                            resolve(onfulfilled(result));
                        } catch (e) {
                            reject(e);
                        }
                    }
                },
                (reason)=>{
                    if (!onrejected) {
                        reject(reason);
                    } else {
                        try {
                            resolve(onrejected(reason));
                        } catch (e) {
                            reject(e);
                        }
                    }
                }
            ]);
            this._executeHandlers();
        });
    }
    /** JSDoc */ catch(onrejected) {
        return this.then((val)=>val, onrejected);
    }
    /** JSDoc */ finally(onfinally) {
        return new SyncPromise((resolve, reject)=>{
            let val;
            let isRejected;
            return this.then((value)=>{
                isRejected = false;
                val = value;
                if (onfinally) {
                    onfinally();
                }
            }, (reason)=>{
                isRejected = true;
                val = reason;
                if (onfinally) {
                    onfinally();
                }
            }).then(()=>{
                if (isRejected) {
                    reject(val);
                    return;
                }
                resolve(val);
            });
        });
    }
    /** JSDoc */ __init() {
        this._resolve = (value)=>{
            this._setResult(States.RESOLVED, value);
        };
    }
    /** JSDoc */ __init2() {
        this._reject = (reason)=>{
            this._setResult(States.REJECTED, reason);
        };
    }
    /** JSDoc */ __init3() {
        this._setResult = (state, value)=>{
            if (this._state !== States.PENDING) {
                return;
            }
            if (is_isThenable(value)) {
                void value.then(this._resolve, this._reject);
                return;
            }
            this._state = state;
            this._value = value;
            this._executeHandlers();
        };
    }
    /** JSDoc */ __init4() {
        this._executeHandlers = ()=>{
            if (this._state === States.PENDING) {
                return;
            }
            const cachedHandlers = this._handlers.slice();
            this._handlers = [];
            cachedHandlers.forEach((handler)=>{
                if (handler[0]) {
                    return;
                }
                if (this._state === States.RESOLVED) {
                    // eslint-disable-next-line @typescript-eslint/no-floating-promises
                    handler[1](this._value);
                }
                if (this._state === States.REJECTED) {
                    handler[2](this._value);
                }
                handler[0] = true;
            });
        };
    }
}
 //# sourceMappingURL=syncpromise.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/eventProcessors.js


/**
 * Returns the global event processors.
 * @deprecated Global event processors will be removed in v8.
 */ function eventProcessors_getGlobalEventProcessors() {
    return getGlobalSingleton("globalEventProcessors", ()=>[]);
}
/**
 * Add a EventProcessor to be kept globally.
 * @deprecated Use `addEventProcessor` instead. Global event processors will be removed in v8.
 */ function addGlobalEventProcessor(callback) {
    // eslint-disable-next-line deprecation/deprecation
    eventProcessors_getGlobalEventProcessors().push(callback);
}
/**
 * Process an array of event processors, returning the processed event (or `null` if the event was dropped).
 */ function eventProcessors_notifyEventProcessors(processors, event, hint, index = 0) {
    return new SyncPromise((resolve, reject)=>{
        const processor = processors[index];
        if (event === null || typeof processor !== "function") {
            resolve(event);
        } else {
            const result = processor({
                ...event
            }, hint);
            esm_debug_build_DEBUG_BUILD && processor.id && result === null && logger_logger.log(`Event processor "${processor.id}" dropped event`);
            if (is_isThenable(result)) {
                void result.then((final)=>eventProcessors_notifyEventProcessors(processors, final, hint, index + 1).then(resolve)).then(null, reject);
            } else {
                void eventProcessors_notifyEventProcessors(processors, result, hint, index + 1).then(resolve).then(null, reject);
            }
        }
    });
}
 //# sourceMappingURL=eventProcessors.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/object.js





/**
 * Replace a method in an object with a wrapped version of itself.
 *
 * @param source An object that contains a method to be wrapped.
 * @param name The name of the method to be wrapped.
 * @param replacementFactory A higher-order function that takes the original version of the given method and returns a
 * wrapped version. Note: The function returned by `replacementFactory` needs to be a non-arrow function, in order to
 * preserve the correct value of `this`, and the original method must be called using `origMethod.call(this, <other
 * args>)` or `origMethod.apply(this, [<other args>])` (rather than being called directly), again to preserve `this`.
 * @returns void
 */ function object_fill(source, name, replacementFactory) {
    if (!(name in source)) {
        return;
    }
    const original = source[name];
    const wrapped = replacementFactory(original);
    // Make sure it's a function first, as we need to attach an empty prototype for `defineProperties` to work
    // otherwise it'll throw "TypeError: Object.defineProperties called on non-object"
    if (typeof wrapped === "function") {
        markFunctionWrapped(wrapped, original);
    }
    source[name] = wrapped;
}
/**
 * Defines a non-enumerable property on the given object.
 *
 * @param obj The object on which to set the property
 * @param name The name of the property to be set
 * @param value The value to which to set the property
 */ function object_addNonEnumerableProperty(obj, name, value) {
    try {
        Object.defineProperty(obj, name, {
            // enumerable: false, // the default, so we can save on bundle size by not explicitly setting it
            value: value,
            writable: true,
            configurable: true
        });
    } catch (o_O) {
        debug_build_DEBUG_BUILD && logger_logger.log(`Failed to add non-enumerable property "${name}" to object`, obj);
    }
}
/**
 * Remembers the original function on the wrapped function and
 * patches up the prototype.
 *
 * @param wrapped the wrapper function
 * @param original the original function that gets wrapped
 */ function markFunctionWrapped(wrapped, original) {
    try {
        const proto = original.prototype || {};
        wrapped.prototype = original.prototype = proto;
        object_addNonEnumerableProperty(wrapped, "__sentry_original__", original);
    } catch (o_O) {} // eslint-disable-line no-empty
}
/**
 * This extracts the original function if available.  See
 * `markFunctionWrapped` for more information.
 *
 * @param func the function to unwrap
 * @returns the unwrapped version of the function if available.
 */ function getOriginalFunction(func) {
    return func.__sentry_original__;
}
/**
 * Encodes given object into url-friendly format
 *
 * @param object An object that contains serializable values
 * @returns string Encoded
 */ function urlEncode(object) {
    return Object.keys(object).map((key)=>`${encodeURIComponent(key)}=${encodeURIComponent(object[key])}`).join("&");
}
/**
 * Transforms any `Error` or `Event` into a plain object with all of their enumerable properties, and some of their
 * non-enumerable properties attached.
 *
 * @param value Initial source that we have to transform in order for it to be usable by the serializer
 * @returns An Event or Error turned into an object - or the value argurment itself, when value is neither an Event nor
 *  an Error.
 */ function convertToPlainObject(value) {
    if (isError(value)) {
        return {
            message: value.message,
            name: value.name,
            stack: value.stack,
            ...getOwnProperties(value)
        };
    } else if (isEvent(value)) {
        const newObj = {
            type: value.type,
            target: serializeEventTarget(value.target),
            currentTarget: serializeEventTarget(value.currentTarget),
            ...getOwnProperties(value)
        };
        if (typeof CustomEvent !== "undefined" && isInstanceOf(value, CustomEvent)) {
            newObj.detail = value.detail;
        }
        return newObj;
    } else {
        return value;
    }
}
/** Creates a string representation of the target of an `Event` object */ function serializeEventTarget(target) {
    try {
        return isElement(target) ? htmlTreeAsString(target) : Object.prototype.toString.call(target);
    } catch (_oO) {
        return "<unknown>";
    }
}
/** Filters out all but an object's own properties */ function getOwnProperties(obj) {
    if (typeof obj === "object" && obj !== null) {
        const extractedProps = {};
        for(const property in obj){
            if (Object.prototype.hasOwnProperty.call(obj, property)) {
                extractedProps[property] = obj[property];
            }
        }
        return extractedProps;
    } else {
        return {};
    }
}
/**
 * Given any captured exception, extract its keys and create a sorted
 * and truncated list that will be used inside the event message.
 * eg. `Non-error exception captured with keys: foo, bar, baz`
 */ function extractExceptionKeysForMessage(exception, maxLength = 40) {
    const keys = Object.keys(convertToPlainObject(exception));
    keys.sort();
    if (!keys.length) {
        return "[object has no keys]";
    }
    if (keys[0].length >= maxLength) {
        return truncate(keys[0], maxLength);
    }
    for(let includedKeys = keys.length; includedKeys > 0; includedKeys--){
        const serialized = keys.slice(0, includedKeys).join(", ");
        if (serialized.length > maxLength) {
            continue;
        }
        if (includedKeys === keys.length) {
            return serialized;
        }
        return truncate(serialized, maxLength);
    }
    return "";
}
/**
 * Given any object, return a new object having removed all fields whose value was `undefined`.
 * Works recursively on objects and arrays.
 *
 * Attention: This function keeps circular references in the returned object.
 */ function dropUndefinedKeys(inputValue) {
    // This map keeps track of what already visited nodes map to.
    // Our Set - based memoBuilder doesn't work here because we want to the output object to have the same circular
    // references as the input object.
    const memoizationMap = new Map();
    // This function just proxies `_dropUndefinedKeys` to keep the `memoBuilder` out of this function's API
    return _dropUndefinedKeys(inputValue, memoizationMap);
}
function _dropUndefinedKeys(inputValue, memoizationMap) {
    if (isPojo(inputValue)) {
        // If this node has already been visited due to a circular reference, return the object it was mapped to in the new object
        const memoVal = memoizationMap.get(inputValue);
        if (memoVal !== undefined) {
            return memoVal;
        }
        const returnValue = {};
        // Store the mapping of this value in case we visit it again, in case of circular data
        memoizationMap.set(inputValue, returnValue);
        for (const key of Object.keys(inputValue)){
            if (typeof inputValue[key] !== "undefined") {
                returnValue[key] = _dropUndefinedKeys(inputValue[key], memoizationMap);
            }
        }
        return returnValue;
    }
    if (Array.isArray(inputValue)) {
        // If this node has already been visited due to a circular reference, return the array it was mapped to in the new object
        const memoVal = memoizationMap.get(inputValue);
        if (memoVal !== undefined) {
            return memoVal;
        }
        const returnValue = [];
        // Store the mapping of this value in case we visit it again, in case of circular data
        memoizationMap.set(inputValue, returnValue);
        inputValue.forEach((item)=>{
            returnValue.push(_dropUndefinedKeys(item, memoizationMap));
        });
        return returnValue;
    }
    return inputValue;
}
function isPojo(input) {
    if (!is_isPlainObject(input)) {
        return false;
    }
    try {
        const name = Object.getPrototypeOf(input).constructor.name;
        return !name || name === "Object";
    } catch (e) {
        return true;
    }
}
/**
 * Ensure that something is an object.
 *
 * Turns `undefined` and `null` into `String`s and all other primitives into instances of their respective wrapper
 * classes (String, Boolean, Number, etc.). Acts as the identity function on non-primitives.
 *
 * @param wat The subject of the objectification
 * @returns A version of `wat` which can safely be used with `Object` class methods
 */ function objectify(wat) {
    let objectified;
    switch(true){
        case wat === undefined || wat === null:
            objectified = new String(wat);
            break;
        // Though symbols and bigints do have wrapper classes (`Symbol` and `BigInt`, respectively), for whatever reason
        // those classes don't have constructors which can be used with the `new` keyword. We therefore need to cast each as
        // an object in order to wrap it.
        case typeof wat === "symbol" || typeof wat === "bigint":
            objectified = Object(wat);
            break;
        // this will catch the remaining primitives: `String`, `Number`, and `Boolean`
        case isPrimitive(wat):
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
            objectified = new wat.constructor(wat);
            break;
        // by process of elimination, at this point we know that `wat` must already be an object
        default:
            objectified = wat;
            break;
    }
    return objectified;
}
 //# sourceMappingURL=object.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/session.js

/**
 * Creates a new `Session` object by setting certain default parameters. If optional @param context
 * is passed, the passed properties are applied to the session object.
 *
 * @param context (optional) additional properties to be applied to the returned session object
 *
 * @returns a new `Session` object
 */ function session_makeSession(context) {
    // Both timestamp and started are in seconds since the UNIX epoch.
    const startingTime = time_timestampInSeconds();
    const session = {
        sid: misc_uuid4(),
        init: true,
        timestamp: startingTime,
        started: startingTime,
        duration: 0,
        status: "ok",
        errors: 0,
        ignoreDuration: false,
        toJSON: ()=>sessionToJSON(session)
    };
    if (context) {
        session_updateSession(session, context);
    }
    return session;
}
/**
 * Updates a session object with the properties passed in the context.
 *
 * Note that this function mutates the passed object and returns void.
 * (Had to do this instead of returning a new and updated session because closing and sending a session
 * makes an update to the session after it was passed to the sending logic.
 * @see BaseClient.captureSession )
 *
 * @param session the `Session` to update
 * @param context the `SessionContext` holding the properties that should be updated in @param session
 */ // eslint-disable-next-line complexity
function session_updateSession(session, context = {}) {
    if (context.user) {
        if (!session.ipAddress && context.user.ip_address) {
            session.ipAddress = context.user.ip_address;
        }
        if (!session.did && !context.did) {
            session.did = context.user.id || context.user.email || context.user.username;
        }
    }
    session.timestamp = context.timestamp || time_timestampInSeconds();
    if (context.abnormal_mechanism) {
        session.abnormal_mechanism = context.abnormal_mechanism;
    }
    if (context.ignoreDuration) {
        session.ignoreDuration = context.ignoreDuration;
    }
    if (context.sid) {
        // Good enough uuid validation. — Kamil
        session.sid = context.sid.length === 32 ? context.sid : misc_uuid4();
    }
    if (context.init !== undefined) {
        session.init = context.init;
    }
    if (!session.did && context.did) {
        session.did = `${context.did}`;
    }
    if (typeof context.started === "number") {
        session.started = context.started;
    }
    if (session.ignoreDuration) {
        session.duration = undefined;
    } else if (typeof context.duration === "number") {
        session.duration = context.duration;
    } else {
        const duration = session.timestamp - session.started;
        session.duration = duration >= 0 ? duration : 0;
    }
    if (context.release) {
        session.release = context.release;
    }
    if (context.environment) {
        session.environment = context.environment;
    }
    if (!session.ipAddress && context.ipAddress) {
        session.ipAddress = context.ipAddress;
    }
    if (!session.userAgent && context.userAgent) {
        session.userAgent = context.userAgent;
    }
    if (typeof context.errors === "number") {
        session.errors = context.errors;
    }
    if (context.status) {
        session.status = context.status;
    }
}
/**
 * Closes a session by setting its status and updating the session object with it.
 * Internally calls `updateSession` to update the passed session object.
 *
 * Note that this function mutates the passed session (@see updateSession for explanation).
 *
 * @param session the `Session` object to be closed
 * @param status the `SessionStatus` with which the session was closed. If you don't pass a status,
 *               this function will keep the previously set status, unless it was `'ok'` in which case
 *               it is changed to `'exited'`.
 */ function session_closeSession(session, status) {
    let context = {};
    if (status) {
        context = {
            status
        };
    } else if (session.status === "ok") {
        context = {
            status: "exited"
        };
    }
    session_updateSession(session, context);
}
/**
 * Serializes a passed session object to a JSON object with a slightly different structure.
 * This is necessary because the Sentry backend requires a slightly different schema of a session
 * than the one the JS SDKs use internally.
 *
 * @param session the session to be converted
 *
 * @returns a JSON object of the passed session
 */ function sessionToJSON(session) {
    return dropUndefinedKeys({
        sid: `${session.sid}`,
        init: session.init,
        // Make sure that sec is converted to ms for date constructor
        started: new Date(session.started * 1000).toISOString(),
        timestamp: new Date(session.timestamp * 1000).toISOString(),
        status: session.status,
        errors: session.errors,
        did: typeof session.did === "number" || typeof session.did === "string" ? `${session.did}` : undefined,
        duration: session.duration,
        abnormal_mechanism: session.abnormal_mechanism,
        attrs: {
            release: session.release,
            environment: session.environment,
            ip_address: session.ipAddress,
            user_agent: session.userAgent
        }
    });
}
 //# sourceMappingURL=session.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/utils/prepareEvent.js






/**
 * This type makes sure that we get either a CaptureContext, OR an EventHint.
 * It does not allow mixing them, which could lead to unexpected outcomes, e.g. this is disallowed:
 * { user: { id: '123' }, mechanism: { handled: false } }
 */ /**
 * Adds common information to events.
 *
 * The information includes release and environment from `options`,
 * breadcrumbs and context (extra, tags and user) from the scope.
 *
 * Information that is already present in the event is never overwritten. For
 * nested objects, such as the context, keys are merged.
 *
 * Note: This also triggers callbacks for `addGlobalEventProcessor`, but not `beforeSend`.
 *
 * @param event The original event.
 * @param hint May contain additional information about the original exception.
 * @param scope A scope containing event metadata.
 * @returns A new event with more information.
 * @hidden
 */ function prepareEvent(options, event, hint, scope, client, isolationScope) {
    const { normalizeDepth = 3, normalizeMaxBreadth = 1000 } = options;
    const prepared = {
        ...event,
        event_id: event.event_id || hint.event_id || uuid4(),
        timestamp: event.timestamp || dateTimestampInSeconds()
    };
    const integrations = hint.integrations || options.integrations.map((i)=>i.name);
    applyClientOptions(prepared, options);
    applyIntegrationsMetadata(prepared, integrations);
    // Only put debug IDs onto frames for error events.
    if (event.type === undefined) {
        applyDebugIds(prepared, options.stackParser);
    }
    // If we have scope given to us, use it as the base for further modifications.
    // This allows us to prevent unnecessary copying of data if `captureContext` is not provided.
    const finalScope = getFinalScope(scope, hint.captureContext);
    if (hint.mechanism) {
        addExceptionMechanism(prepared, hint.mechanism);
    }
    const clientEventProcessors = client && client.getEventProcessors ? client.getEventProcessors() : [];
    // This should be the last thing called, since we want that
    // {@link Hub.addEventProcessor} gets the finished prepared event.
    // Merge scope data together
    const data = getGlobalScope().getScopeData();
    if (isolationScope) {
        const isolationData = isolationScope.getScopeData();
        mergeScopeData(data, isolationData);
    }
    if (finalScope) {
        const finalScopeData = finalScope.getScopeData();
        mergeScopeData(data, finalScopeData);
    }
    const attachments = [
        ...hint.attachments || [],
        ...data.attachments
    ];
    if (attachments.length) {
        hint.attachments = attachments;
    }
    applyScopeDataToEvent(prepared, data);
    // TODO (v8): Update this order to be: Global > Client > Scope
    const eventProcessors = [
        ...clientEventProcessors,
        // eslint-disable-next-line deprecation/deprecation
        ...getGlobalEventProcessors(),
        // Run scope event processors _after_ all other processors
        ...data.eventProcessors
    ];
    const result = notifyEventProcessors(eventProcessors, prepared, hint);
    return result.then((evt)=>{
        if (evt) {
            // We apply the debug_meta field only after all event processors have ran, so that if any event processors modified
            // file names (e.g.the RewriteFrames integration) the filename -> debug ID relationship isn't destroyed.
            // This should not cause any PII issues, since we're only moving data that is already on the event and not adding
            // any new data
            applyDebugMeta(evt);
        }
        if (typeof normalizeDepth === "number" && normalizeDepth > 0) {
            return normalizeEvent(evt, normalizeDepth, normalizeMaxBreadth);
        }
        return evt;
    });
}
/**
 *  Enhances event using the client configuration.
 *  It takes care of all "static" values like environment, release and `dist`,
 *  as well as truncating overly long values.
 * @param event event instance to be enhanced
 */ function applyClientOptions(event, options) {
    const { environment, release, dist, maxValueLength = 250 } = options;
    if (!("environment" in event)) {
        event.environment = "environment" in options ? environment : DEFAULT_ENVIRONMENT;
    }
    if (event.release === undefined && release !== undefined) {
        event.release = release;
    }
    if (event.dist === undefined && dist !== undefined) {
        event.dist = dist;
    }
    if (event.message) {
        event.message = truncate(event.message, maxValueLength);
    }
    const exception = event.exception && event.exception.values && event.exception.values[0];
    if (exception && exception.value) {
        exception.value = truncate(exception.value, maxValueLength);
    }
    const request = event.request;
    if (request && request.url) {
        request.url = truncate(request.url, maxValueLength);
    }
}
const debugIdStackParserCache = new WeakMap();
/**
 * Puts debug IDs into the stack frames of an error event.
 */ function applyDebugIds(event, stackParser) {
    const debugIdMap = GLOBAL_OBJ._sentryDebugIds;
    if (!debugIdMap) {
        return;
    }
    let debugIdStackFramesCache;
    const cachedDebugIdStackFrameCache = debugIdStackParserCache.get(stackParser);
    if (cachedDebugIdStackFrameCache) {
        debugIdStackFramesCache = cachedDebugIdStackFrameCache;
    } else {
        debugIdStackFramesCache = new Map();
        debugIdStackParserCache.set(stackParser, debugIdStackFramesCache);
    }
    // Build a map of filename -> debug_id
    const filenameDebugIdMap = Object.keys(debugIdMap).reduce((acc, debugIdStackTrace)=>{
        let parsedStack;
        const cachedParsedStack = debugIdStackFramesCache.get(debugIdStackTrace);
        if (cachedParsedStack) {
            parsedStack = cachedParsedStack;
        } else {
            parsedStack = stackParser(debugIdStackTrace);
            debugIdStackFramesCache.set(debugIdStackTrace, parsedStack);
        }
        for(let i = parsedStack.length - 1; i >= 0; i--){
            const stackFrame = parsedStack[i];
            if (stackFrame.filename) {
                acc[stackFrame.filename] = debugIdMap[debugIdStackTrace];
                break;
            }
        }
        return acc;
    }, {});
    try {
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        event.exception.values.forEach((exception)=>{
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            exception.stacktrace.frames.forEach((frame)=>{
                if (frame.filename) {
                    frame.debug_id = filenameDebugIdMap[frame.filename];
                }
            });
        });
    } catch (e) {
    // To save bundle size we're just try catching here instead of checking for the existence of all the different objects.
    }
}
/**
 * Moves debug IDs from the stack frames of an error event into the debug_meta field.
 */ function applyDebugMeta(event) {
    // Extract debug IDs and filenames from the stack frames on the event.
    const filenameDebugIdMap = {};
    try {
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        event.exception.values.forEach((exception)=>{
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            exception.stacktrace.frames.forEach((frame)=>{
                if (frame.debug_id) {
                    if (frame.abs_path) {
                        filenameDebugIdMap[frame.abs_path] = frame.debug_id;
                    } else if (frame.filename) {
                        filenameDebugIdMap[frame.filename] = frame.debug_id;
                    }
                    delete frame.debug_id;
                }
            });
        });
    } catch (e) {
    // To save bundle size we're just try catching here instead of checking for the existence of all the different objects.
    }
    if (Object.keys(filenameDebugIdMap).length === 0) {
        return;
    }
    // Fill debug_meta information
    event.debug_meta = event.debug_meta || {};
    event.debug_meta.images = event.debug_meta.images || [];
    const images = event.debug_meta.images;
    Object.keys(filenameDebugIdMap).forEach((filename)=>{
        images.push({
            type: "sourcemap",
            code_file: filename,
            debug_id: filenameDebugIdMap[filename]
        });
    });
}
/**
 * This function adds all used integrations to the SDK info in the event.
 * @param event The event that will be filled with all integrations.
 */ function applyIntegrationsMetadata(event, integrationNames) {
    if (integrationNames.length > 0) {
        event.sdk = event.sdk || {};
        event.sdk.integrations = [
            ...event.sdk.integrations || [],
            ...integrationNames
        ];
    }
}
/**
 * Applies `normalize` function on necessary `Event` attributes to make them safe for serialization.
 * Normalized keys:
 * - `breadcrumbs.data`
 * - `user`
 * - `contexts`
 * - `extra`
 * @param event Event
 * @returns Normalized event
 */ function normalizeEvent(event, depth, maxBreadth) {
    if (!event) {
        return null;
    }
    const normalized = {
        ...event,
        ...event.breadcrumbs && {
            breadcrumbs: event.breadcrumbs.map((b)=>({
                    ...b,
                    ...b.data && {
                        data: normalize(b.data, depth, maxBreadth)
                    }
                }))
        },
        ...event.user && {
            user: normalize(event.user, depth, maxBreadth)
        },
        ...event.contexts && {
            contexts: normalize(event.contexts, depth, maxBreadth)
        },
        ...event.extra && {
            extra: normalize(event.extra, depth, maxBreadth)
        }
    };
    // event.contexts.trace stores information about a Transaction. Similarly,
    // event.spans[] stores information about child Spans. Given that a
    // Transaction is conceptually a Span, normalization should apply to both
    // Transactions and Spans consistently.
    // For now the decision is to skip normalization of Transactions and Spans,
    // so this block overwrites the normalized event to add back the original
    // Transaction information prior to normalization.
    if (event.contexts && event.contexts.trace && normalized.contexts) {
        normalized.contexts.trace = event.contexts.trace;
        // event.contexts.trace.data may contain circular/dangerous data so we need to normalize it
        if (event.contexts.trace.data) {
            normalized.contexts.trace.data = normalize(event.contexts.trace.data, depth, maxBreadth);
        }
    }
    // event.spans[].data may contain circular/dangerous data so we need to normalize it
    if (event.spans) {
        normalized.spans = event.spans.map((span)=>{
            const data = spanToJSON(span).data;
            if (data) {
                // This is a bit weird, as we generally have `Span` instances here, but to be safe we do not assume so
                // eslint-disable-next-line deprecation/deprecation
                span.data = normalize(data, depth, maxBreadth);
            }
            return span;
        });
    }
    return normalized;
}
function getFinalScope(scope, captureContext) {
    if (!captureContext) {
        return scope;
    }
    const finalScope = scope ? scope.clone() : new Scope();
    finalScope.update(captureContext);
    return finalScope;
}
/**
 * Parse either an `EventHint` directly, or convert a `CaptureContext` to an `EventHint`.
 * This is used to allow to update method signatures that used to accept a `CaptureContext` but should now accept an `EventHint`.
 */ function parseEventHintOrCaptureContext(hint) {
    if (!hint) {
        return undefined;
    }
    // If you pass a Scope or `() => Scope` as CaptureContext, we just return this as captureContext
    if (hintIsScopeOrFunction(hint)) {
        return {
            captureContext: hint
        };
    }
    if (hintIsScopeContext(hint)) {
        return {
            captureContext: hint
        };
    }
    return hint;
}
function hintIsScopeOrFunction(hint) {
    return hint instanceof scope_Scope || typeof hint === "function";
}
const captureContextKeys = [
    "user",
    "level",
    "extra",
    "contexts",
    "tags",
    "fingerprint",
    "requestSession",
    "propagationContext"
];
function hintIsScopeContext(hint) {
    return Object.keys(hint).some((key)=>captureContextKeys.includes(key));
}
 //# sourceMappingURL=prepareEvent.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/exports.js






/**
 * Captures an exception event and sends it to Sentry.
 *
 * @param exception The exception to capture.
 * @param hint Optional additional data to attach to the Sentry event.
 * @returns the id of the captured Sentry event.
 */ function captureException(// eslint-disable-next-line @typescript-eslint/no-explicit-any
exception, hint) {
    // eslint-disable-next-line deprecation/deprecation
    return hub_getCurrentHub().captureException(exception, parseEventHintOrCaptureContext(hint));
}
/**
 * Captures a message event and sends it to Sentry.
 *
 * @param exception The exception to capture.
 * @param captureContext Define the level of the message or pass in additional data to attach to the message.
 * @returns the id of the captured message.
 */ function captureMessage(message, // eslint-disable-next-line deprecation/deprecation
captureContext) {
    // This is necessary to provide explicit scopes upgrade, without changing the original
    // arity of the `captureMessage(message, level)` method.
    const level = typeof captureContext === "string" ? captureContext : undefined;
    const context = typeof captureContext !== "string" ? {
        captureContext
    } : undefined;
    // eslint-disable-next-line deprecation/deprecation
    return getCurrentHub().captureMessage(message, level, context);
}
/**
 * Captures a manually created event and sends it to Sentry.
 *
 * @param exception The event to send to Sentry.
 * @param hint Optional additional data to attach to the Sentry event.
 * @returns the id of the captured event.
 */ function captureEvent(event, hint) {
    // eslint-disable-next-line deprecation/deprecation
    return getCurrentHub().captureEvent(event, hint);
}
/**
 * Callback to set context information onto the scope.
 * @param callback Callback function that receives Scope.
 *
 * @deprecated Use getCurrentScope() directly.
 */ // eslint-disable-next-line deprecation/deprecation
function configureScope(callback) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().configureScope(callback);
}
/**
 * Records a new breadcrumb which will be attached to future events.
 *
 * Breadcrumbs will be added to subsequent events to provide more context on
 * user's actions prior to an error or crash.
 *
 * @param breadcrumb The breadcrumb to record.
 */ // eslint-disable-next-line deprecation/deprecation
function addBreadcrumb(breadcrumb, hint) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().addBreadcrumb(breadcrumb, hint);
}
/**
 * Sets context data with the given name.
 * @param name of the context
 * @param context Any kind of data. This data will be normalized.
 */ // eslint-disable-next-line @typescript-eslint/no-explicit-any, deprecation/deprecation
function setContext(name, context) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().setContext(name, context);
}
/**
 * Set an object that will be merged sent as extra data with the event.
 * @param extras Extras object to merge into current context.
 */ // eslint-disable-next-line deprecation/deprecation
function setExtras(extras) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().setExtras(extras);
}
/**
 * Set key:value that will be sent as extra data with the event.
 * @param key String of extra
 * @param extra Any kind of data. This data will be normalized.
 */ // eslint-disable-next-line deprecation/deprecation
function setExtra(key, extra) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().setExtra(key, extra);
}
/**
 * Set an object that will be merged sent as tags data with the event.
 * @param tags Tags context object to merge into current context.
 */ // eslint-disable-next-line deprecation/deprecation
function setTags(tags) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().setTags(tags);
}
/**
 * Set key:value that will be sent as tags data with the event.
 *
 * Can also be used to unset a tag, by passing `undefined`.
 *
 * @param key String key of tag
 * @param value Value of tag
 */ // eslint-disable-next-line deprecation/deprecation
function setTag(key, value) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().setTag(key, value);
}
/**
 * Updates user context information for future events.
 *
 * @param user User context object to be set in the current context. Pass `null` to unset the user.
 */ // eslint-disable-next-line deprecation/deprecation
function setUser(user) {
    // eslint-disable-next-line deprecation/deprecation
    getCurrentHub().setUser(user);
}
/**
 * Creates a new scope with and executes the given operation within.
 * The scope is automatically removed once the operation
 * finishes or throws.
 *
 * This is essentially a convenience function for:
 *
 *     pushScope();
 *     callback();
 *     popScope();
 */ /**
 * Either creates a new active scope, or sets the given scope as active scope in the given callback.
 */ function exports_withScope(...rest) {
    // eslint-disable-next-line deprecation/deprecation
    const hub = hub_getCurrentHub();
    // If a scope is defined, we want to make this the active scope instead of the default one
    if (rest.length === 2) {
        const [scope, callback] = rest;
        if (!scope) {
            // eslint-disable-next-line deprecation/deprecation
            return hub.withScope(callback);
        }
        // eslint-disable-next-line deprecation/deprecation
        return hub.withScope(()=>{
            // eslint-disable-next-line deprecation/deprecation
            hub.getStackTop().scope = scope;
            return callback(scope);
        });
    }
    // eslint-disable-next-line deprecation/deprecation
    return hub.withScope(rest[0]);
}
/**
 * Attempts to fork the current isolation scope and the current scope based on the current async context strategy. If no
 * async context strategy is set, the isolation scope and the current scope will not be forked (this is currently the
 * case, for example, in the browser).
 *
 * Usage of this function in environments without async context strategy is discouraged and may lead to unexpected behaviour.
 *
 * This function is intended for Sentry SDK and SDK integration development. It is not recommended to be used in "normal"
 * applications directly because it comes with pitfalls. Use at your own risk!
 *
 * @param callback The callback in which the passed isolation scope is active. (Note: In environments without async
 * context strategy, the currently active isolation scope may change within execution of the callback.)
 * @returns The same value that `callback` returns.
 */ function withIsolationScope(callback) {
    return runWithAsyncContext(()=>{
        return callback(getIsolationScope());
    });
}
/**
 * Forks the current scope and sets the provided span as active span in the context of the provided callback.
 *
 * @param span Spans started in the context of the provided callback will be children of this span.
 * @param callback Execution context in which the provided span will be active. Is passed the newly forked scope.
 * @returns the value returned from the provided callback function.
 */ function withActiveSpan(span, callback) {
    return exports_withScope((scope)=>{
        // eslint-disable-next-line deprecation/deprecation
        scope.setSpan(span);
        return callback(scope);
    });
}
/**
 * Starts a new `Transaction` and returns it. This is the entry point to manual tracing instrumentation.
 *
 * A tree structure can be built by adding child spans to the transaction, and child spans to other spans. To start a
 * new child span within the transaction or any span, call the respective `.startChild()` method.
 *
 * Every child span must be finished before the transaction is finished, otherwise the unfinished spans are discarded.
 *
 * The transaction must be finished with a call to its `.end()` method, at which point the transaction with all its
 * finished child spans will be sent to Sentry.
 *
 * NOTE: This function should only be used for *manual* instrumentation. Auto-instrumentation should call
 * `startTransaction` directly on the hub.
 *
 * @param context Properties of the new `Transaction`.
 * @param customSamplingContext Information given to the transaction sampling function (along with context-dependent
 * default values). See {@link Options.tracesSampler}.
 *
 * @returns The transaction which was just started
 *
 * @deprecated Use `startSpan()`, `startSpanManual()` or `startInactiveSpan()` instead.
 */ function startTransaction(context, customSamplingContext) {
    // eslint-disable-next-line deprecation/deprecation
    return getCurrentHub().startTransaction({
        ...context
    }, customSamplingContext);
}
/**
 * Create a cron monitor check in and send it to Sentry.
 *
 * @param checkIn An object that describes a check in.
 * @param upsertMonitorConfig An optional object that describes a monitor config. Use this if you want
 * to create a monitor automatically when sending a check in.
 */ function captureCheckIn(checkIn, upsertMonitorConfig) {
    const scope = exports_getCurrentScope();
    const client = getClient();
    if (!client) {
        DEBUG_BUILD && logger.warn("Cannot capture check-in. No client defined.");
    } else if (!client.captureCheckIn) {
        DEBUG_BUILD && logger.warn("Cannot capture check-in. Client does not support sending check-ins.");
    } else {
        return client.captureCheckIn(checkIn, upsertMonitorConfig, scope);
    }
    return uuid4();
}
/**
 * Wraps a callback with a cron monitor check in. The check in will be sent to Sentry when the callback finishes.
 *
 * @param monitorSlug The distinct slug of the monitor.
 * @param upsertMonitorConfig An optional object that describes a monitor config. Use this if you want
 * to create a monitor automatically when sending a check in.
 */ function withMonitor(monitorSlug, callback, upsertMonitorConfig) {
    const checkInId = captureCheckIn({
        monitorSlug,
        status: "in_progress"
    }, upsertMonitorConfig);
    const now = timestampInSeconds();
    function finishCheckIn(status) {
        captureCheckIn({
            monitorSlug,
            status,
            checkInId,
            duration: timestampInSeconds() - now
        });
    }
    let maybePromiseResult;
    try {
        maybePromiseResult = callback();
    } catch (e) {
        finishCheckIn("error");
        throw e;
    }
    if (isThenable(maybePromiseResult)) {
        Promise.resolve(maybePromiseResult).then(()=>{
            finishCheckIn("ok");
        }, ()=>{
            finishCheckIn("error");
        });
    } else {
        finishCheckIn("ok");
    }
    return maybePromiseResult;
}
/**
 * Call `flush()` on the current client, if there is one. See {@link Client.flush}.
 *
 * @param timeout Maximum time in ms the client should wait to flush its event queue. Omitting this parameter will cause
 * the client to wait until all events are sent before resolving the promise.
 * @returns A promise which resolves to `true` if the queue successfully drains before the timeout, or `false` if it
 * doesn't (or if there's no client defined).
 */ async function flush(timeout) {
    const client = getClient();
    if (client) {
        return client.flush(timeout);
    }
    esm_debug_build_DEBUG_BUILD && logger_logger.warn("Cannot flush events. No client defined.");
    return Promise.resolve(false);
}
/**
 * Call `close()` on the current client, if there is one. See {@link Client.close}.
 *
 * @param timeout Maximum time in ms the client should wait to flush its event queue before shutting down. Omitting this
 * parameter will cause the client to wait until all events are sent before disabling itself.
 * @returns A promise which resolves to `true` if the queue successfully drains before the timeout, or `false` if it
 * doesn't (or if there's no client defined).
 */ async function exports_close(timeout) {
    const client = getClient();
    if (client) {
        return client.close(timeout);
    }
    DEBUG_BUILD && logger.warn("Cannot flush events and disable SDK. No client defined.");
    return Promise.resolve(false);
}
/**
 * This is the getter for lastEventId.
 *
 * @returns The last event id of a captured event.
 */ function lastEventId() {
    // eslint-disable-next-line deprecation/deprecation
    return getCurrentHub().lastEventId();
}
/**
 * Get the currently active client.
 */ function getClient() {
    // eslint-disable-next-line deprecation/deprecation
    return hub_getCurrentHub().getClient();
}
/**
 * Returns true if Sentry has been properly initialized.
 */ function isInitialized() {
    return !!getClient();
}
/**
 * Get the currently active scope.
 */ function exports_getCurrentScope() {
    // eslint-disable-next-line deprecation/deprecation
    return hub_getCurrentHub().getScope();
}
/**
 * Start a session on the current isolation scope.
 *
 * @param context (optional) additional properties to be applied to the returned session object
 *
 * @returns the new active session
 */ function startSession(context) {
    const client = getClient();
    const isolationScope = getIsolationScope();
    const currentScope = exports_getCurrentScope();
    const { release, environment = DEFAULT_ENVIRONMENT } = client && client.getOptions() || {};
    // Will fetch userAgent if called from browser sdk
    const { userAgent } = GLOBAL_OBJ.navigator || {};
    const session = makeSession({
        release,
        environment,
        user: currentScope.getUser() || isolationScope.getUser(),
        ...userAgent && {
            userAgent
        },
        ...context
    });
    // End existing session if there's one
    const currentSession = isolationScope.getSession();
    if (currentSession && currentSession.status === "ok") {
        updateSession(currentSession, {
            status: "exited"
        });
    }
    endSession();
    // Afterwards we set the new session on the scope
    isolationScope.setSession(session);
    // TODO (v8): Remove this and only use the isolation scope(?).
    // For v7 though, we can't "soft-break" people using getCurrentHub().getScope().setSession()
    currentScope.setSession(session);
    return session;
}
/**
 * End the session on the current isolation scope.
 */ function endSession() {
    const isolationScope = getIsolationScope();
    const currentScope = exports_getCurrentScope();
    const session = currentScope.getSession() || isolationScope.getSession();
    if (session) {
        closeSession(session);
    }
    _sendSessionUpdate();
    // the session is over; take it off of the scope
    isolationScope.setSession();
    // TODO (v8): Remove this and only use the isolation scope(?).
    // For v7 though, we can't "soft-break" people using getCurrentHub().getScope().setSession()
    currentScope.setSession();
}
/**
 * Sends the current Session on the scope
 */ function _sendSessionUpdate() {
    const isolationScope = getIsolationScope();
    const currentScope = exports_getCurrentScope();
    const client = getClient();
    // TODO (v8): Remove currentScope and only use the isolation scope(?).
    // For v7 though, we can't "soft-break" people using getCurrentHub().getScope().setSession()
    const session = currentScope.getSession() || isolationScope.getSession();
    if (session && client && client.captureSession) {
        client.captureSession(session);
    }
}
/**
 * Sends the current session on the scope to Sentry
 *
 * @param end If set the session will be marked as exited and removed from the scope.
 *            Defaults to `false`.
 */ function captureSession(end = false) {
    // both send the update and pull the session from the scope
    if (end) {
        endSession();
        return;
    }
    // only send the update
    _sendSessionUpdate();
}
 //# sourceMappingURL=exports.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/utils/getRootSpan.js
/**
 * Returns the root span of a given span.
 *
 * As long as we use `Transaction`s internally, the returned root span
 * will be a `Transaction` but be aware that this might change in the future.
 *
 * If the given span has no root span or transaction, `undefined` is returned.
 */ function getRootSpan(span) {
    // TODO (v8): Remove this check and just return span
    // eslint-disable-next-line deprecation/deprecation
    return span.transaction;
}
 //# sourceMappingURL=getRootSpan.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/baggage.js



const BAGGAGE_HEADER_NAME = "baggage";
const SENTRY_BAGGAGE_KEY_PREFIX = "sentry-";
const SENTRY_BAGGAGE_KEY_PREFIX_REGEX = /^sentry-/;
/**
 * Max length of a serialized baggage string
 *
 * https://www.w3.org/TR/baggage/#limits
 */ const MAX_BAGGAGE_STRING_LENGTH = 8192;
/**
 * Takes a baggage header and turns it into Dynamic Sampling Context, by extracting all the "sentry-" prefixed values
 * from it.
 *
 * @param baggageHeader A very bread definition of a baggage header as it might appear in various frameworks.
 * @returns The Dynamic Sampling Context that was found on `baggageHeader`, if there was any, `undefined` otherwise.
 */ function baggage_baggageHeaderToDynamicSamplingContext(// Very liberal definition of what any incoming header might look like
baggageHeader) {
    if (!is_isString(baggageHeader) && !Array.isArray(baggageHeader)) {
        return undefined;
    }
    // Intermediary object to store baggage key value pairs of incoming baggage headers on.
    // It is later used to read Sentry-DSC-values from.
    let baggageObject = {};
    if (Array.isArray(baggageHeader)) {
        // Combine all baggage headers into one object containing the baggage values so we can later read the Sentry-DSC-values from it
        baggageObject = baggageHeader.reduce((acc, curr)=>{
            const currBaggageObject = baggageHeaderToObject(curr);
            for (const key of Object.keys(currBaggageObject)){
                acc[key] = currBaggageObject[key];
            }
            return acc;
        }, {});
    } else {
        // Return undefined if baggage header is an empty string (technically an empty baggage header is not spec conform but
        // this is how we choose to handle it)
        if (!baggageHeader) {
            return undefined;
        }
        baggageObject = baggageHeaderToObject(baggageHeader);
    }
    // Read all "sentry-" prefixed values out of the baggage object and put it onto a dynamic sampling context object.
    const dynamicSamplingContext = Object.entries(baggageObject).reduce((acc, [key, value])=>{
        if (key.match(SENTRY_BAGGAGE_KEY_PREFIX_REGEX)) {
            const nonPrefixedKey = key.slice(SENTRY_BAGGAGE_KEY_PREFIX.length);
            acc[nonPrefixedKey] = value;
        }
        return acc;
    }, {});
    // Only return a dynamic sampling context object if there are keys in it.
    // A keyless object means there were no sentry values on the header, which means that there is no DSC.
    if (Object.keys(dynamicSamplingContext).length > 0) {
        return dynamicSamplingContext;
    } else {
        return undefined;
    }
}
/**
 * Turns a Dynamic Sampling Object into a baggage header by prefixing all the keys on the object with "sentry-".
 *
 * @param dynamicSamplingContext The Dynamic Sampling Context to turn into a header. For convenience and compatibility
 * with the `getDynamicSamplingContext` method on the Transaction class ,this argument can also be `undefined`. If it is
 * `undefined` the function will return `undefined`.
 * @returns a baggage header, created from `dynamicSamplingContext`, or `undefined` either if `dynamicSamplingContext`
 * was `undefined`, or if `dynamicSamplingContext` didn't contain any values.
 */ function dynamicSamplingContextToSentryBaggageHeader(// this also takes undefined for convenience and bundle size in other places
dynamicSamplingContext) {
    if (!dynamicSamplingContext) {
        return undefined;
    }
    // Prefix all DSC keys with "sentry-" and put them into a new object
    const sentryPrefixedDSC = Object.entries(dynamicSamplingContext).reduce((acc, [dscKey, dscValue])=>{
        if (dscValue) {
            acc[`${SENTRY_BAGGAGE_KEY_PREFIX}${dscKey}`] = dscValue;
        }
        return acc;
    }, {});
    return objectToBaggageHeader(sentryPrefixedDSC);
}
/**
 * Will parse a baggage header, which is a simple key-value map, into a flat object.
 *
 * @param baggageHeader The baggage header to parse.
 * @returns a flat object containing all the key-value pairs from `baggageHeader`.
 */ function baggageHeaderToObject(baggageHeader) {
    return baggageHeader.split(",").map((baggageEntry)=>baggageEntry.split("=").map((keyOrValue)=>decodeURIComponent(keyOrValue.trim()))).reduce((acc, [key, value])=>{
        acc[key] = value;
        return acc;
    }, {});
}
/**
 * Turns a flat object (key-value pairs) into a baggage header, which is also just key-value pairs.
 *
 * @param object The object to turn into a baggage header.
 * @returns a baggage header string, or `undefined` if the object didn't have any values, since an empty baggage header
 * is not spec compliant.
 */ function objectToBaggageHeader(object) {
    if (Object.keys(object).length === 0) {
        // An empty baggage header is not spec compliant: We return undefined.
        return undefined;
    }
    return Object.entries(object).reduce((baggageHeader, [objectKey, objectValue], currentIndex)=>{
        const baggageEntry = `${encodeURIComponent(objectKey)}=${encodeURIComponent(objectValue)}`;
        const newBaggageHeader = currentIndex === 0 ? baggageEntry : `${baggageHeader},${baggageEntry}`;
        if (newBaggageHeader.length > MAX_BAGGAGE_STRING_LENGTH) {
            DEBUG_BUILD && logger.warn(`Not adding key: ${objectKey} with val: ${objectValue} to baggage header due to exceeding baggage size limits.`);
            return baggageHeader;
        } else {
            return newBaggageHeader;
        }
    }, "");
}
 //# sourceMappingURL=baggage.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/tracing.js


// eslint-disable-next-line @sentry-internal/sdk/no-regexp-constructor -- RegExp is used for readability here
const TRACEPARENT_REGEXP = new RegExp("^[ \\t]*" + // whitespace
"([0-9a-f]{32})?" + // trace_id
"-?([0-9a-f]{16})?" + // span_id
"-?([01])?" + // sampled
"[ \\t]*$");
/**
 * Extract transaction context data from a `sentry-trace` header.
 *
 * @param traceparent Traceparent string
 *
 * @returns Object containing data from the header, or undefined if traceparent string is malformed
 */ function extractTraceparentData(traceparent) {
    if (!traceparent) {
        return undefined;
    }
    const matches = traceparent.match(TRACEPARENT_REGEXP);
    if (!matches) {
        return undefined;
    }
    let parentSampled;
    if (matches[3] === "1") {
        parentSampled = true;
    } else if (matches[3] === "0") {
        parentSampled = false;
    }
    return {
        traceId: matches[1],
        parentSampled,
        parentSpanId: matches[2]
    };
}
/**
 * Create tracing context from incoming headers.
 *
 * @deprecated Use `propagationContextFromHeaders` instead.
 */ // TODO(v8): Remove this function
function tracingContextFromHeaders(sentryTrace, baggage) {
    const traceparentData = extractTraceparentData(sentryTrace);
    const dynamicSamplingContext = baggage_baggageHeaderToDynamicSamplingContext(baggage);
    const { traceId, parentSpanId, parentSampled } = traceparentData || {};
    if (!traceparentData) {
        return {
            traceparentData,
            dynamicSamplingContext: undefined,
            propagationContext: {
                traceId: traceId || misc_uuid4(),
                spanId: misc_uuid4().substring(16)
            }
        };
    } else {
        return {
            traceparentData,
            dynamicSamplingContext: dynamicSamplingContext || {},
            propagationContext: {
                traceId: traceId || misc_uuid4(),
                parentSpanId: parentSpanId || misc_uuid4().substring(16),
                spanId: misc_uuid4().substring(16),
                sampled: parentSampled,
                dsc: dynamicSamplingContext || {}
            }
        };
    }
}
/**
 * Create a propagation context from incoming headers.
 */ function propagationContextFromHeaders(sentryTrace, baggage) {
    const traceparentData = extractTraceparentData(sentryTrace);
    const dynamicSamplingContext = baggageHeaderToDynamicSamplingContext(baggage);
    const { traceId, parentSpanId, parentSampled } = traceparentData || {};
    if (!traceparentData) {
        return {
            traceId: traceId || uuid4(),
            spanId: uuid4().substring(16)
        };
    } else {
        return {
            traceId: traceId || uuid4(),
            parentSpanId: parentSpanId || uuid4().substring(16),
            spanId: uuid4().substring(16),
            sampled: parentSampled,
            dsc: dynamicSamplingContext || {}
        };
    }
}
/**
 * Create sentry-trace header from span context values.
 */ function generateSentryTraceHeader(traceId = misc_uuid4(), spanId = misc_uuid4().substring(16), sampled) {
    let sampledString = "";
    if (sampled !== undefined) {
        sampledString = sampled ? "-1" : "-0";
    }
    return `${traceId}-${spanId}${sampledString}`;
}
 //# sourceMappingURL=tracing.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/utils/spanUtils.js

// These are aligned with OpenTelemetry trace flags
const TRACE_FLAG_NONE = 0x0;
const TRACE_FLAG_SAMPLED = 0x1;
/**
 * Convert a span to a trace context, which can be sent as the `trace` context in an event.
 */ function spanToTraceContext(span) {
    const { spanId: span_id, traceId: trace_id } = span.spanContext();
    const { data, op, parent_span_id, status, tags, origin } = spanUtils_spanToJSON(span);
    return dropUndefinedKeys({
        data,
        op,
        parent_span_id,
        span_id,
        status,
        tags,
        trace_id,
        origin
    });
}
/**
 * Convert a Span to a Sentry trace header.
 */ function spanToTraceHeader(span) {
    const { traceId, spanId } = span.spanContext();
    const sampled = spanIsSampled(span);
    return generateSentryTraceHeader(traceId, spanId, sampled);
}
/**
 * Convert a span time input intp a timestamp in seconds.
 */ function spanTimeInputToSeconds(input) {
    if (typeof input === "number") {
        return ensureTimestampInSeconds(input);
    }
    if (Array.isArray(input)) {
        // See {@link HrTime} for the array-based time format
        return input[0] + input[1] / 1e9;
    }
    if (input instanceof Date) {
        return ensureTimestampInSeconds(input.getTime());
    }
    return time_timestampInSeconds();
}
/**
 * Converts a timestamp to second, if it was in milliseconds, or keeps it as second.
 */ function ensureTimestampInSeconds(timestamp) {
    const isMs = timestamp > 9999999999;
    return isMs ? timestamp / 1000 : timestamp;
}
/**
 * Convert a span to a JSON representation.
 * Note that all fields returned here are optional and need to be guarded against.
 *
 * Note: Because of this, we currently have a circular type dependency (which we opted out of in package.json).
 * This is not avoidable as we need `spanToJSON` in `spanUtils.ts`, which in turn is needed by `span.ts` for backwards compatibility.
 * And `spanToJSON` needs the Span class from `span.ts` to check here.
 * TODO v8: When we remove the deprecated stuff from `span.ts`, we can remove the circular dependency again.
 */ function spanUtils_spanToJSON(span) {
    if (spanIsSpanClass(span)) {
        return span.getSpanJSON();
    }
    // Fallback: We also check for `.toJSON()` here...
    // eslint-disable-next-line deprecation/deprecation
    if (typeof span.toJSON === "function") {
        // eslint-disable-next-line deprecation/deprecation
        return span.toJSON();
    }
    return {};
}
/**
 * Sadly, due to circular dependency checks we cannot actually import the Span class here and check for instanceof.
 * :( So instead we approximate this by checking if it has the `getSpanJSON` method.
 */ function spanIsSpanClass(span) {
    return typeof span.getSpanJSON === "function";
}
/**
 * Returns true if a span is sampled.
 * In most cases, you should just use `span.isRecording()` instead.
 * However, this has a slightly different semantic, as it also returns false if the span is finished.
 * So in the case where this distinction is important, use this method.
 */ function spanIsSampled(span) {
    // We align our trace flags with the ones OpenTelemetry use
    // So we also check for sampled the same way they do.
    const { traceFlags } = span.spanContext();
    // eslint-disable-next-line no-bitwise
    return Boolean(traceFlags & TRACE_FLAG_SAMPLED);
}
 //# sourceMappingURL=spanUtils.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/dynamicSamplingContext.js





/**
 * Creates a dynamic sampling context from a client.
 *
 * Dispatches the `createDsc` lifecycle hook as a side effect.
 */ function getDynamicSamplingContextFromClient(trace_id, client, scope) {
    const options = client.getOptions();
    const { publicKey: public_key } = client.getDsn() || {};
    // TODO(v8): Remove segment from User
    // eslint-disable-next-line deprecation/deprecation
    const { segment: user_segment } = scope && scope.getUser() || {};
    const dsc = dropUndefinedKeys({
        environment: options.environment || constants_DEFAULT_ENVIRONMENT,
        release: options.release,
        user_segment,
        public_key,
        trace_id
    });
    client.emit && client.emit("createDsc", dsc);
    return dsc;
}
/**
 * A Span with a frozen dynamic sampling context.
 */ /**
 * Creates a dynamic sampling context from a span (and client and scope)
 *
 * @param span the span from which a few values like the root span name and sample rate are extracted.
 *
 * @returns a dynamic sampling context
 */ function getDynamicSamplingContextFromSpan(span) {
    const client = getClient();
    if (!client) {
        return {};
    }
    // passing emit=false here to only emit later once the DSC is actually populated
    const dsc = getDynamicSamplingContextFromClient(spanUtils_spanToJSON(span).trace_id || "", client, exports_getCurrentScope());
    // TODO (v8): Remove v7FrozenDsc as a Transaction will no longer have _frozenDynamicSamplingContext
    const txn = getRootSpan(span);
    if (!txn) {
        return dsc;
    }
    // TODO (v8): Remove v7FrozenDsc as a Transaction will no longer have _frozenDynamicSamplingContext
    // For now we need to avoid breaking users who directly created a txn with a DSC, where this field is still set.
    // @see Transaction class constructor
    const v7FrozenDsc = txn && txn._frozenDynamicSamplingContext;
    if (v7FrozenDsc) {
        return v7FrozenDsc;
    }
    // TODO (v8): Replace txn.metadata with txn.attributes[]
    // We can't do this yet because attributes aren't always set yet.
    // eslint-disable-next-line deprecation/deprecation
    const { sampleRate: maybeSampleRate, source } = txn.metadata;
    if (maybeSampleRate != null) {
        dsc.sample_rate = `${maybeSampleRate}`;
    }
    // We don't want to have a transaction name in the DSC if the source is "url" because URLs might contain PII
    const jsonSpan = spanUtils_spanToJSON(txn);
    // after JSON conversion, txn.name becomes jsonSpan.description
    if (source && source !== "url") {
        dsc.transaction = jsonSpan.description;
    }
    dsc.sampled = String(spanIsSampled(txn));
    client.emit && client.emit("createDsc", dsc);
    return dsc;
}
 //# sourceMappingURL=dynamicSamplingContext.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/utils/applyScopeDataToEvent.js




/**
 * Applies data from the scope to the event and runs all event processors on it.
 */ function applyScopeDataToEvent_applyScopeDataToEvent(event, data) {
    const { fingerprint, span, breadcrumbs, sdkProcessingMetadata } = data;
    // Apply general data
    applyDataToEvent(event, data);
    // We want to set the trace context for normal events only if there isn't already
    // a trace context on the event. There is a product feature in place where we link
    // errors with transaction and it relies on that.
    if (span) {
        applySpanToEvent(event, span);
    }
    applyFingerprintToEvent(event, fingerprint);
    applyBreadcrumbsToEvent(event, breadcrumbs);
    applySdkMetadataToEvent(event, sdkProcessingMetadata);
}
/** Merge data of two scopes together. */ function applyScopeDataToEvent_mergeScopeData(data, mergeData) {
    const { extra, tags, user, contexts, level, sdkProcessingMetadata, breadcrumbs, fingerprint, eventProcessors, attachments, propagationContext, // eslint-disable-next-line deprecation/deprecation
    transactionName, span } = mergeData;
    mergeAndOverwriteScopeData(data, "extra", extra);
    mergeAndOverwriteScopeData(data, "tags", tags);
    mergeAndOverwriteScopeData(data, "user", user);
    mergeAndOverwriteScopeData(data, "contexts", contexts);
    mergeAndOverwriteScopeData(data, "sdkProcessingMetadata", sdkProcessingMetadata);
    if (level) {
        data.level = level;
    }
    if (transactionName) {
        // eslint-disable-next-line deprecation/deprecation
        data.transactionName = transactionName;
    }
    if (span) {
        data.span = span;
    }
    if (breadcrumbs.length) {
        data.breadcrumbs = [
            ...data.breadcrumbs,
            ...breadcrumbs
        ];
    }
    if (fingerprint.length) {
        data.fingerprint = [
            ...data.fingerprint,
            ...fingerprint
        ];
    }
    if (eventProcessors.length) {
        data.eventProcessors = [
            ...data.eventProcessors,
            ...eventProcessors
        ];
    }
    if (attachments.length) {
        data.attachments = [
            ...data.attachments,
            ...attachments
        ];
    }
    data.propagationContext = {
        ...data.propagationContext,
        ...propagationContext
    };
}
/**
 * Merges certain scope data. Undefined values will overwrite any existing values.
 * Exported only for tests.
 */ function mergeAndOverwriteScopeData(data, prop, mergeVal) {
    if (mergeVal && Object.keys(mergeVal).length) {
        // Clone object
        data[prop] = {
            ...data[prop]
        };
        for(const key in mergeVal){
            if (Object.prototype.hasOwnProperty.call(mergeVal, key)) {
                data[prop][key] = mergeVal[key];
            }
        }
    }
}
function applyDataToEvent(event, data) {
    const { extra, tags, user, contexts, level, // eslint-disable-next-line deprecation/deprecation
    transactionName } = data;
    const cleanedExtra = dropUndefinedKeys(extra);
    if (cleanedExtra && Object.keys(cleanedExtra).length) {
        event.extra = {
            ...cleanedExtra,
            ...event.extra
        };
    }
    const cleanedTags = dropUndefinedKeys(tags);
    if (cleanedTags && Object.keys(cleanedTags).length) {
        event.tags = {
            ...cleanedTags,
            ...event.tags
        };
    }
    const cleanedUser = dropUndefinedKeys(user);
    if (cleanedUser && Object.keys(cleanedUser).length) {
        event.user = {
            ...cleanedUser,
            ...event.user
        };
    }
    const cleanedContexts = dropUndefinedKeys(contexts);
    if (cleanedContexts && Object.keys(cleanedContexts).length) {
        event.contexts = {
            ...cleanedContexts,
            ...event.contexts
        };
    }
    if (level) {
        event.level = level;
    }
    if (transactionName) {
        event.transaction = transactionName;
    }
}
function applyBreadcrumbsToEvent(event, breadcrumbs) {
    const mergedBreadcrumbs = [
        ...event.breadcrumbs || [],
        ...breadcrumbs
    ];
    event.breadcrumbs = mergedBreadcrumbs.length ? mergedBreadcrumbs : undefined;
}
function applySdkMetadataToEvent(event, sdkProcessingMetadata) {
    event.sdkProcessingMetadata = {
        ...event.sdkProcessingMetadata,
        ...sdkProcessingMetadata
    };
}
function applySpanToEvent(event, span) {
    event.contexts = {
        trace: spanToTraceContext(span),
        ...event.contexts
    };
    const rootSpan = getRootSpan(span);
    if (rootSpan) {
        event.sdkProcessingMetadata = {
            dynamicSamplingContext: getDynamicSamplingContextFromSpan(span),
            ...event.sdkProcessingMetadata
        };
        const transactionName = spanUtils_spanToJSON(rootSpan).description;
        if (transactionName) {
            event.tags = {
                transaction: transactionName,
                ...event.tags
            };
        }
    }
}
/**
 * Applies fingerprint from the scope to the event if there's one,
 * uses message if there's one instead or get rid of empty fingerprint
 */ function applyFingerprintToEvent(event, fingerprint) {
    // Make sure it's an array first and we actually have something in place
    event.fingerprint = event.fingerprint ? arrayify(event.fingerprint) : [];
    // If we have something on the scope, then merge it with event
    if (fingerprint) {
        event.fingerprint = event.fingerprint.concat(fingerprint);
    }
    // If we have no data at all, remove empty array default
    if (event.fingerprint && !event.fingerprint.length) {
        delete event.fingerprint;
    }
}
 //# sourceMappingURL=applyScopeDataToEvent.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/scope.js




/**
 * Default value for maximum number of breadcrumbs added to an event.
 */ const DEFAULT_MAX_BREADCRUMBS = 100;
/**
 * The global scope is kept in this module.
 * When accessing this via `getGlobalScope()` we'll make sure to set one if none is currently present.
 */ let globalScope;
/**
 * Holds additional event information. {@link Scope.applyToEvent} will be
 * called by the client before an event will be sent.
 */ class scope_Scope {
    /** Flag if notifying is happening. */ /** Callback for client to receive scope changes. */ /** Callback list that will be called after {@link applyToEvent}. */ /** Array of breadcrumbs. */ /** User */ /** Tags */ /** Extra */ /** Contexts */ /** Attachments */ /** Propagation Context for distributed tracing */ /**
   * A place to stash data which is needed at some point in the SDK's event processing pipeline but which shouldn't get
   * sent to Sentry
   */ /** Fingerprint */ /** Severity */ // eslint-disable-next-line deprecation/deprecation
    /**
   * Transaction Name
   */ /** Span */ /** Session */ /** Request Mode Session Status */ /** The client on this scope */ // NOTE: Any field which gets added here should get added not only to the constructor but also to the `clone` method.
    constructor(){
        this._notifyingListeners = false;
        this._scopeListeners = [];
        this._eventProcessors = [];
        this._breadcrumbs = [];
        this._attachments = [];
        this._user = {};
        this._tags = {};
        this._extra = {};
        this._contexts = {};
        this._sdkProcessingMetadata = {};
        this._propagationContext = generatePropagationContext();
    }
    /**
   * Inherit values from the parent scope.
   * @deprecated Use `scope.clone()` and `new Scope()` instead.
   */ static clone(scope) {
        return scope ? scope.clone() : new scope_Scope();
    }
    /**
   * Clone this scope instance.
   */ clone() {
        const newScope = new scope_Scope();
        newScope._breadcrumbs = [
            ...this._breadcrumbs
        ];
        newScope._tags = {
            ...this._tags
        };
        newScope._extra = {
            ...this._extra
        };
        newScope._contexts = {
            ...this._contexts
        };
        newScope._user = this._user;
        newScope._level = this._level;
        newScope._span = this._span;
        newScope._session = this._session;
        newScope._transactionName = this._transactionName;
        newScope._fingerprint = this._fingerprint;
        newScope._eventProcessors = [
            ...this._eventProcessors
        ];
        newScope._requestSession = this._requestSession;
        newScope._attachments = [
            ...this._attachments
        ];
        newScope._sdkProcessingMetadata = {
            ...this._sdkProcessingMetadata
        };
        newScope._propagationContext = {
            ...this._propagationContext
        };
        newScope._client = this._client;
        return newScope;
    }
    /** Update the client on the scope. */ setClient(client) {
        this._client = client;
    }
    /**
   * Get the client assigned to this scope.
   *
   * It is generally recommended to use the global function `Sentry.getClient()` instead, unless you know what you are doing.
   */ getClient() {
        return this._client;
    }
    /**
   * Add internal on change listener. Used for sub SDKs that need to store the scope.
   * @hidden
   */ addScopeListener(callback) {
        this._scopeListeners.push(callback);
    }
    /**
   * @inheritDoc
   */ addEventProcessor(callback) {
        this._eventProcessors.push(callback);
        return this;
    }
    /**
   * @inheritDoc
   */ setUser(user) {
        // If null is passed we want to unset everything, but still define keys,
        // so that later down in the pipeline any existing values are cleared.
        this._user = user || {
            email: undefined,
            id: undefined,
            ip_address: undefined,
            segment: undefined,
            username: undefined
        };
        if (this._session) {
            session_updateSession(this._session, {
                user
            });
        }
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ getUser() {
        return this._user;
    }
    /**
   * @inheritDoc
   */ getRequestSession() {
        return this._requestSession;
    }
    /**
   * @inheritDoc
   */ setRequestSession(requestSession) {
        this._requestSession = requestSession;
        return this;
    }
    /**
   * @inheritDoc
   */ setTags(tags) {
        this._tags = {
            ...this._tags,
            ...tags
        };
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ setTag(key, value) {
        this._tags = {
            ...this._tags,
            [key]: value
        };
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ setExtras(extras) {
        this._extra = {
            ...this._extra,
            ...extras
        };
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ setExtra(key, extra) {
        this._extra = {
            ...this._extra,
            [key]: extra
        };
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ setFingerprint(fingerprint) {
        this._fingerprint = fingerprint;
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ setLevel(// eslint-disable-next-line deprecation/deprecation
    level) {
        this._level = level;
        this._notifyScopeListeners();
        return this;
    }
    /**
   * Sets the transaction name on the scope for future events.
   */ setTransactionName(name) {
        this._transactionName = name;
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ setContext(key, context) {
        if (context === null) {
            // eslint-disable-next-line @typescript-eslint/no-dynamic-delete
            delete this._contexts[key];
        } else {
            this._contexts[key] = context;
        }
        this._notifyScopeListeners();
        return this;
    }
    /**
   * Sets the Span on the scope.
   * @param span Span
   * @deprecated Instead of setting a span on a scope, use `startSpan()`/`startSpanManual()` instead.
   */ setSpan(span) {
        this._span = span;
        this._notifyScopeListeners();
        return this;
    }
    /**
   * Returns the `Span` if there is one.
   * @deprecated Use `getActiveSpan()` instead.
   */ getSpan() {
        return this._span;
    }
    /**
   * Returns the `Transaction` attached to the scope (if there is one).
   * @deprecated You should not rely on the transaction, but just use `startSpan()` APIs instead.
   */ getTransaction() {
        // Often, this span (if it exists at all) will be a transaction, but it's not guaranteed to be. Regardless, it will
        // have a pointer to the currently-active transaction.
        const span = this._span;
        // Cannot replace with getRootSpan because getRootSpan returns a span, not a transaction
        // Also, this method will be removed anyway.
        // eslint-disable-next-line deprecation/deprecation
        return span && span.transaction;
    }
    /**
   * @inheritDoc
   */ setSession(session) {
        if (!session) {
            delete this._session;
        } else {
            this._session = session;
        }
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ getSession() {
        return this._session;
    }
    /**
   * @inheritDoc
   */ update(captureContext) {
        if (!captureContext) {
            return this;
        }
        const scopeToMerge = typeof captureContext === "function" ? captureContext(this) : captureContext;
        if (scopeToMerge instanceof scope_Scope) {
            const scopeData = scopeToMerge.getScopeData();
            this._tags = {
                ...this._tags,
                ...scopeData.tags
            };
            this._extra = {
                ...this._extra,
                ...scopeData.extra
            };
            this._contexts = {
                ...this._contexts,
                ...scopeData.contexts
            };
            if (scopeData.user && Object.keys(scopeData.user).length) {
                this._user = scopeData.user;
            }
            if (scopeData.level) {
                this._level = scopeData.level;
            }
            if (scopeData.fingerprint.length) {
                this._fingerprint = scopeData.fingerprint;
            }
            if (scopeToMerge.getRequestSession()) {
                this._requestSession = scopeToMerge.getRequestSession();
            }
            if (scopeData.propagationContext) {
                this._propagationContext = scopeData.propagationContext;
            }
        } else if (is_isPlainObject(scopeToMerge)) {
            const scopeContext = captureContext;
            this._tags = {
                ...this._tags,
                ...scopeContext.tags
            };
            this._extra = {
                ...this._extra,
                ...scopeContext.extra
            };
            this._contexts = {
                ...this._contexts,
                ...scopeContext.contexts
            };
            if (scopeContext.user) {
                this._user = scopeContext.user;
            }
            if (scopeContext.level) {
                this._level = scopeContext.level;
            }
            if (scopeContext.fingerprint) {
                this._fingerprint = scopeContext.fingerprint;
            }
            if (scopeContext.requestSession) {
                this._requestSession = scopeContext.requestSession;
            }
            if (scopeContext.propagationContext) {
                this._propagationContext = scopeContext.propagationContext;
            }
        }
        return this;
    }
    /**
   * @inheritDoc
   */ clear() {
        this._breadcrumbs = [];
        this._tags = {};
        this._extra = {};
        this._user = {};
        this._contexts = {};
        this._level = undefined;
        this._transactionName = undefined;
        this._fingerprint = undefined;
        this._requestSession = undefined;
        this._span = undefined;
        this._session = undefined;
        this._notifyScopeListeners();
        this._attachments = [];
        this._propagationContext = generatePropagationContext();
        return this;
    }
    /**
   * @inheritDoc
   */ addBreadcrumb(breadcrumb, maxBreadcrumbs) {
        const maxCrumbs = typeof maxBreadcrumbs === "number" ? maxBreadcrumbs : DEFAULT_MAX_BREADCRUMBS;
        // No data has been changed, so don't notify scope listeners
        if (maxCrumbs <= 0) {
            return this;
        }
        const mergedBreadcrumb = {
            timestamp: time_dateTimestampInSeconds(),
            ...breadcrumb
        };
        const breadcrumbs = this._breadcrumbs;
        breadcrumbs.push(mergedBreadcrumb);
        this._breadcrumbs = breadcrumbs.length > maxCrumbs ? breadcrumbs.slice(-maxCrumbs) : breadcrumbs;
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ getLastBreadcrumb() {
        return this._breadcrumbs[this._breadcrumbs.length - 1];
    }
    /**
   * @inheritDoc
   */ clearBreadcrumbs() {
        this._breadcrumbs = [];
        this._notifyScopeListeners();
        return this;
    }
    /**
   * @inheritDoc
   */ addAttachment(attachment) {
        this._attachments.push(attachment);
        return this;
    }
    /**
   * @inheritDoc
   * @deprecated Use `getScopeData()` instead.
   */ getAttachments() {
        const data = this.getScopeData();
        return data.attachments;
    }
    /**
   * @inheritDoc
   */ clearAttachments() {
        this._attachments = [];
        return this;
    }
    /** @inheritDoc */ getScopeData() {
        const { _breadcrumbs, _attachments, _contexts, _tags, _extra, _user, _level, _fingerprint, _eventProcessors, _propagationContext, _sdkProcessingMetadata, _transactionName, _span } = this;
        return {
            breadcrumbs: _breadcrumbs,
            attachments: _attachments,
            contexts: _contexts,
            tags: _tags,
            extra: _extra,
            user: _user,
            level: _level,
            fingerprint: _fingerprint || [],
            eventProcessors: _eventProcessors,
            propagationContext: _propagationContext,
            sdkProcessingMetadata: _sdkProcessingMetadata,
            transactionName: _transactionName,
            span: _span
        };
    }
    /**
   * Applies data from the scope to the event and runs all event processors on it.
   *
   * @param event Event
   * @param hint Object containing additional information about the original exception, for use by the event processors.
   * @hidden
   * @deprecated Use `applyScopeDataToEvent()` directly
   */ applyToEvent(event, hint = {}, additionalEventProcessors = []) {
        applyScopeDataToEvent_applyScopeDataToEvent(event, this.getScopeData());
        // TODO (v8): Update this order to be: Global > Client > Scope
        const eventProcessors = [
            ...additionalEventProcessors,
            // eslint-disable-next-line deprecation/deprecation
            ...eventProcessors_getGlobalEventProcessors(),
            ...this._eventProcessors
        ];
        return eventProcessors_notifyEventProcessors(eventProcessors, event, hint);
    }
    /**
   * Add data which will be accessible during event processing but won't get sent to Sentry
   */ setSDKProcessingMetadata(newData) {
        this._sdkProcessingMetadata = {
            ...this._sdkProcessingMetadata,
            ...newData
        };
        return this;
    }
    /**
   * @inheritDoc
   */ setPropagationContext(context) {
        this._propagationContext = context;
        return this;
    }
    /**
   * @inheritDoc
   */ getPropagationContext() {
        return this._propagationContext;
    }
    /**
   * Capture an exception for this scope.
   *
   * @param exception The exception to capture.
   * @param hint Optinal additional data to attach to the Sentry event.
   * @returns the id of the captured Sentry event.
   */ captureException(exception, hint) {
        const eventId = hint && hint.event_id ? hint.event_id : misc_uuid4();
        if (!this._client) {
            logger_logger.warn("No client configured on scope - will not capture exception!");
            return eventId;
        }
        const syntheticException = new Error("Sentry syntheticException");
        this._client.captureException(exception, {
            originalException: exception,
            syntheticException,
            ...hint,
            event_id: eventId
        }, this);
        return eventId;
    }
    /**
   * Capture a message for this scope.
   *
   * @param message The message to capture.
   * @param level An optional severity level to report the message with.
   * @param hint Optional additional data to attach to the Sentry event.
   * @returns the id of the captured message.
   */ captureMessage(message, level, hint) {
        const eventId = hint && hint.event_id ? hint.event_id : misc_uuid4();
        if (!this._client) {
            logger_logger.warn("No client configured on scope - will not capture message!");
            return eventId;
        }
        const syntheticException = new Error(message);
        this._client.captureMessage(message, level, {
            originalException: message,
            syntheticException,
            ...hint,
            event_id: eventId
        }, this);
        return eventId;
    }
    /**
   * Captures a manually created event for this scope and sends it to Sentry.
   *
   * @param exception The event to capture.
   * @param hint Optional additional data to attach to the Sentry event.
   * @returns the id of the captured event.
   */ captureEvent(event, hint) {
        const eventId = hint && hint.event_id ? hint.event_id : misc_uuid4();
        if (!this._client) {
            logger_logger.warn("No client configured on scope - will not capture event!");
            return eventId;
        }
        this._client.captureEvent(event, {
            ...hint,
            event_id: eventId
        }, this);
        return eventId;
    }
    /**
   * This will be called on every set call.
   */ _notifyScopeListeners() {
        // We need this check for this._notifyingListeners to be able to work on scope during updates
        // If this check is not here we'll produce endless recursion when something is done with the scope
        // during the callback.
        if (!this._notifyingListeners) {
            this._notifyingListeners = true;
            this._scopeListeners.forEach((callback)=>{
                callback(this);
            });
            this._notifyingListeners = false;
        }
    }
}
/**
 * Get the global scope.
 * This scope is applied to _all_ events.
 */ function scope_getGlobalScope() {
    if (!globalScope) {
        globalScope = new scope_Scope();
    }
    return globalScope;
}
/**
 * This is mainly needed for tests.
 * DO NOT USE this, as this is an internal API and subject to change.
 * @hidden
 */ function setGlobalScope(scope) {
    globalScope = scope;
}
function generatePropagationContext() {
    return {
        traceId: misc_uuid4(),
        spanId: misc_uuid4().substring(16)
    };
}
 //# sourceMappingURL=scope.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/version.js
const SDK_VERSION = "7.120.4";
 //# sourceMappingURL=version.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/hub.js






/**
 * API compatibility version of this hub.
 *
 * WARNING: This number should only be increased when the global interface
 * changes and new methods are introduced.
 *
 * @hidden
 */ const API_VERSION = parseFloat(SDK_VERSION);
/**
 * Default maximum number of breadcrumbs added to an event. Can be overwritten
 * with {@link Options.maxBreadcrumbs}.
 */ const DEFAULT_BREADCRUMBS = 100;
/**
 * @deprecated The `Hub` class will be removed in version 8 of the SDK in favour of `Scope` and `Client` objects.
 *
 * If you previously used the `Hub` class directly, replace it with `Scope` and `Client` objects. More information:
 * - [Multiple Sentry Instances](https://docs.sentry.io/platforms/javascript/best-practices/multiple-sentry-instances/)
 * - [Browser Extensions](https://docs.sentry.io/platforms/javascript/best-practices/browser-extensions/)
 *
 * Some of our APIs are typed with the Hub class instead of the interface (e.g. `getCurrentHub`). Most of them are deprecated
 * themselves and will also be removed in version 8. More information:
 * - [Migration Guide](https://github.com/getsentry/sentry-javascript/blob/develop/MIGRATION.md#deprecate-hub)
 */ // eslint-disable-next-line deprecation/deprecation
class Hub {
    /** Is a {@link Layer}[] containing the client and scope */ /** Contains the last event id of a captured event.  */ /**
   * Creates a new instance of the hub, will push one {@link Layer} into the
   * internal stack on creation.
   *
   * @param client bound to the hub.
   * @param scope bound to the hub.
   * @param version number, higher number means higher priority.
   *
   * @deprecated Instantiation of Hub objects is deprecated and the constructor will be removed in version 8 of the SDK.
   *
   * If you are currently using the Hub for multi-client use like so:
   *
   * ```
   * // OLD
   * const hub = new Hub();
   * hub.bindClient(client);
   * makeMain(hub)
   * ```
   *
   * instead initialize the client as follows:
   *
   * ```
   * // NEW
   * Sentry.withIsolationScope(() => {
   *    Sentry.setCurrentClient(client);
   *    client.init();
   * });
   * ```
   *
   * If you are using the Hub to capture events like so:
   *
   * ```
   * // OLD
   * const client = new Client();
   * const hub = new Hub(client);
   * hub.captureException()
   * ```
   *
   * instead capture isolated events as follows:
   *
   * ```
   * // NEW
   * const client = new Client();
   * const scope = new Scope();
   * scope.setClient(client);
   * scope.captureException();
   * ```
   */ constructor(client, scope, isolationScope, _version = API_VERSION){
        this._version = _version;
        let assignedScope;
        if (!scope) {
            assignedScope = new scope_Scope();
            assignedScope.setClient(client);
        } else {
            assignedScope = scope;
        }
        let assignedIsolationScope;
        if (!isolationScope) {
            assignedIsolationScope = new scope_Scope();
            assignedIsolationScope.setClient(client);
        } else {
            assignedIsolationScope = isolationScope;
        }
        this._stack = [
            {
                scope: assignedScope
            }
        ];
        if (client) {
            // eslint-disable-next-line deprecation/deprecation
            this.bindClient(client);
        }
        this._isolationScope = assignedIsolationScope;
    }
    /**
   * Checks if this hub's version is older than the given version.
   *
   * @param version A version number to compare to.
   * @return True if the given version is newer; otherwise false.
   *
   * @deprecated This will be removed in v8.
   */ isOlderThan(version) {
        return this._version < version;
    }
    /**
   * This binds the given client to the current scope.
   * @param client An SDK client (client) instance.
   *
   * @deprecated Use `initAndBind()` directly, or `setCurrentClient()` and/or `client.init()` instead.
   */ bindClient(client) {
        // eslint-disable-next-line deprecation/deprecation
        const top = this.getStackTop();
        top.client = client;
        top.scope.setClient(client);
        // eslint-disable-next-line deprecation/deprecation
        if (client && client.setupIntegrations) {
            // eslint-disable-next-line deprecation/deprecation
            client.setupIntegrations();
        }
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `withScope` instead.
   */ pushScope() {
        // We want to clone the content of prev scope
        // eslint-disable-next-line deprecation/deprecation
        const scope = this.getScope().clone();
        // eslint-disable-next-line deprecation/deprecation
        this.getStack().push({
            // eslint-disable-next-line deprecation/deprecation
            client: this.getClient(),
            scope
        });
        return scope;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `withScope` instead.
   */ popScope() {
        // eslint-disable-next-line deprecation/deprecation
        if (this.getStack().length <= 1) return false;
        // eslint-disable-next-line deprecation/deprecation
        return !!this.getStack().pop();
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `Sentry.withScope()` instead.
   */ withScope(callback) {
        // eslint-disable-next-line deprecation/deprecation
        const scope = this.pushScope();
        let maybePromiseResult;
        try {
            maybePromiseResult = callback(scope);
        } catch (e) {
            // eslint-disable-next-line deprecation/deprecation
            this.popScope();
            throw e;
        }
        if (is_isThenable(maybePromiseResult)) {
            // @ts-expect-error - isThenable returns the wrong type
            return maybePromiseResult.then((res)=>{
                // eslint-disable-next-line deprecation/deprecation
                this.popScope();
                return res;
            }, (e)=>{
                // eslint-disable-next-line deprecation/deprecation
                this.popScope();
                throw e;
            });
        }
        // eslint-disable-next-line deprecation/deprecation
        this.popScope();
        return maybePromiseResult;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `Sentry.getClient()` instead.
   */ getClient() {
        // eslint-disable-next-line deprecation/deprecation
        return this.getStackTop().client;
    }
    /**
   * Returns the scope of the top stack.
   *
   * @deprecated Use `Sentry.getCurrentScope()` instead.
   */ getScope() {
        // eslint-disable-next-line deprecation/deprecation
        return this.getStackTop().scope;
    }
    /**
   * @deprecated Use `Sentry.getIsolationScope()` instead.
   */ getIsolationScope() {
        return this._isolationScope;
    }
    /**
   * Returns the scope stack for domains or the process.
   * @deprecated This will be removed in v8.
   */ getStack() {
        return this._stack;
    }
    /**
   * Returns the topmost scope layer in the order domain > local > process.
   * @deprecated This will be removed in v8.
   */ getStackTop() {
        return this._stack[this._stack.length - 1];
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `Sentry.captureException()` instead.
   */ captureException(exception, hint) {
        const eventId = this._lastEventId = hint && hint.event_id ? hint.event_id : misc_uuid4();
        const syntheticException = new Error("Sentry syntheticException");
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().captureException(exception, {
            originalException: exception,
            syntheticException,
            ...hint,
            event_id: eventId
        });
        return eventId;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use  `Sentry.captureMessage()` instead.
   */ captureMessage(message, // eslint-disable-next-line deprecation/deprecation
    level, hint) {
        const eventId = this._lastEventId = hint && hint.event_id ? hint.event_id : misc_uuid4();
        const syntheticException = new Error(message);
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().captureMessage(message, level, {
            originalException: message,
            syntheticException,
            ...hint,
            event_id: eventId
        });
        return eventId;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `Sentry.captureEvent()` instead.
   */ captureEvent(event, hint) {
        const eventId = hint && hint.event_id ? hint.event_id : misc_uuid4();
        if (!event.type) {
            this._lastEventId = eventId;
        }
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().captureEvent(event, {
            ...hint,
            event_id: eventId
        });
        return eventId;
    }
    /**
   * @inheritDoc
   *
   * @deprecated This will be removed in v8.
   */ lastEventId() {
        return this._lastEventId;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `Sentry.addBreadcrumb()` instead.
   */ addBreadcrumb(breadcrumb, hint) {
        // eslint-disable-next-line deprecation/deprecation
        const { scope, client } = this.getStackTop();
        if (!client) return;
        const { beforeBreadcrumb = null, maxBreadcrumbs = DEFAULT_BREADCRUMBS } = client.getOptions && client.getOptions() || {};
        if (maxBreadcrumbs <= 0) return;
        const timestamp = time_dateTimestampInSeconds();
        const mergedBreadcrumb = {
            timestamp,
            ...breadcrumb
        };
        const finalBreadcrumb = beforeBreadcrumb ? consoleSandbox(()=>beforeBreadcrumb(mergedBreadcrumb, hint)) : mergedBreadcrumb;
        if (finalBreadcrumb === null) return;
        if (client.emit) {
            client.emit("beforeAddBreadcrumb", finalBreadcrumb, hint);
        }
        // TODO(v8): I know this comment doesn't make much sense because the hub will be deprecated but I still wanted to
        // write it down. In theory, we would have to add the breadcrumbs to the isolation scope here, however, that would
        // duplicate all of the breadcrumbs. There was the possibility of adding breadcrumbs to both, the isolation scope
        // and the normal scope, and deduplicating it down the line in the event processing pipeline. However, that would
        // have been very fragile, because the breadcrumb objects would have needed to keep their identity all throughout
        // the event processing pipeline.
        // In the new implementation, the top level `Sentry.addBreadcrumb()` should ONLY write to the isolation scope.
        scope.addBreadcrumb(finalBreadcrumb, maxBreadcrumbs);
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.setUser()` instead.
   */ setUser(user) {
        // TODO(v8): The top level `Sentry.setUser()` function should write ONLY to the isolation scope.
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().setUser(user);
        // eslint-disable-next-line deprecation/deprecation
        this.getIsolationScope().setUser(user);
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.setTags()` instead.
   */ setTags(tags) {
        // TODO(v8): The top level `Sentry.setTags()` function should write ONLY to the isolation scope.
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().setTags(tags);
        // eslint-disable-next-line deprecation/deprecation
        this.getIsolationScope().setTags(tags);
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.setExtras()` instead.
   */ setExtras(extras) {
        // TODO(v8): The top level `Sentry.setExtras()` function should write ONLY to the isolation scope.
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().setExtras(extras);
        // eslint-disable-next-line deprecation/deprecation
        this.getIsolationScope().setExtras(extras);
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.setTag()` instead.
   */ setTag(key, value) {
        // TODO(v8): The top level `Sentry.setTag()` function should write ONLY to the isolation scope.
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().setTag(key, value);
        // eslint-disable-next-line deprecation/deprecation
        this.getIsolationScope().setTag(key, value);
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.setExtra()` instead.
   */ setExtra(key, extra) {
        // TODO(v8): The top level `Sentry.setExtra()` function should write ONLY to the isolation scope.
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().setExtra(key, extra);
        // eslint-disable-next-line deprecation/deprecation
        this.getIsolationScope().setExtra(key, extra);
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.setContext()` instead.
   */ // eslint-disable-next-line @typescript-eslint/no-explicit-any
    setContext(name, context) {
        // TODO(v8): The top level `Sentry.setContext()` function should write ONLY to the isolation scope.
        // eslint-disable-next-line deprecation/deprecation
        this.getScope().setContext(name, context);
        // eslint-disable-next-line deprecation/deprecation
        this.getIsolationScope().setContext(name, context);
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `getScope()` directly.
   */ configureScope(callback) {
        // eslint-disable-next-line deprecation/deprecation
        const { scope, client } = this.getStackTop();
        if (client) {
            callback(scope);
        }
    }
    /**
   * @inheritDoc
   */ // eslint-disable-next-line deprecation/deprecation
    run(callback) {
        // eslint-disable-next-line deprecation/deprecation
        const oldHub = makeMain(this);
        try {
            callback(this);
        } finally{
            // eslint-disable-next-line deprecation/deprecation
            makeMain(oldHub);
        }
    }
    /**
   * @inheritDoc
   * @deprecated Use `Sentry.getClient().getIntegrationByName()` instead.
   */ getIntegration(integration) {
        // eslint-disable-next-line deprecation/deprecation
        const client = this.getClient();
        if (!client) return null;
        try {
            // eslint-disable-next-line deprecation/deprecation
            return client.getIntegration(integration);
        } catch (_oO) {
            esm_debug_build_DEBUG_BUILD && logger_logger.warn(`Cannot retrieve integration ${integration.id} from the current Hub`);
            return null;
        }
    }
    /**
   * Starts a new `Transaction` and returns it. This is the entry point to manual tracing instrumentation.
   *
   * A tree structure can be built by adding child spans to the transaction, and child spans to other spans. To start a
   * new child span within the transaction or any span, call the respective `.startChild()` method.
   *
   * Every child span must be finished before the transaction is finished, otherwise the unfinished spans are discarded.
   *
   * The transaction must be finished with a call to its `.end()` method, at which point the transaction with all its
   * finished child spans will be sent to Sentry.
   *
   * @param context Properties of the new `Transaction`.
   * @param customSamplingContext Information given to the transaction sampling function (along with context-dependent
   * default values). See {@link Options.tracesSampler}.
   *
   * @returns The transaction which was just started
   *
   * @deprecated Use `startSpan()`, `startSpanManual()` or `startInactiveSpan()` instead.
   */ startTransaction(context, customSamplingContext) {
        const result = this._callExtensionMethod("startTransaction", context, customSamplingContext);
        if (esm_debug_build_DEBUG_BUILD && !result) {
            // eslint-disable-next-line deprecation/deprecation
            const client = this.getClient();
            if (!client) {
                logger_logger.warn("Tracing extension 'startTransaction' is missing. You should 'init' the SDK before calling 'startTransaction'");
            } else {
                logger_logger.warn(`Tracing extension 'startTransaction' has not been added. Call 'addTracingExtensions' before calling 'init':
Sentry.addTracingExtensions();
Sentry.init({...});
`);
            }
        }
        return result;
    }
    /**
   * @inheritDoc
   * @deprecated Use `spanToTraceHeader()` instead.
   */ traceHeaders() {
        return this._callExtensionMethod("traceHeaders");
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use top level `captureSession` instead.
   */ captureSession(endSession = false) {
        // both send the update and pull the session from the scope
        if (endSession) {
            // eslint-disable-next-line deprecation/deprecation
            return this.endSession();
        }
        // only send the update
        this._sendSessionUpdate();
    }
    /**
   * @inheritDoc
   * @deprecated Use top level `endSession` instead.
   */ endSession() {
        // eslint-disable-next-line deprecation/deprecation
        const layer = this.getStackTop();
        const scope = layer.scope;
        const session = scope.getSession();
        if (session) {
            session_closeSession(session);
        }
        this._sendSessionUpdate();
        // the session is over; take it off of the scope
        scope.setSession();
    }
    /**
   * @inheritDoc
   * @deprecated Use top level `startSession` instead.
   */ startSession(context) {
        // eslint-disable-next-line deprecation/deprecation
        const { scope, client } = this.getStackTop();
        const { release, environment = constants_DEFAULT_ENVIRONMENT } = client && client.getOptions() || {};
        // Will fetch userAgent if called from browser sdk
        const { userAgent } = worldwide_GLOBAL_OBJ.navigator || {};
        const session = session_makeSession({
            release,
            environment,
            user: scope.getUser(),
            ...userAgent && {
                userAgent
            },
            ...context
        });
        // End existing session if there's one
        const currentSession = scope.getSession && scope.getSession();
        if (currentSession && currentSession.status === "ok") {
            session_updateSession(currentSession, {
                status: "exited"
            });
        }
        // eslint-disable-next-line deprecation/deprecation
        this.endSession();
        // Afterwards we set the new session on the scope
        scope.setSession(session);
        return session;
    }
    /**
   * Returns if default PII should be sent to Sentry and propagated in ourgoing requests
   * when Tracing is used.
   *
   * @deprecated Use top-level `getClient().getOptions().sendDefaultPii` instead. This function
   * only unnecessarily increased API surface but only wrapped accessing the option.
   */ shouldSendDefaultPii() {
        // eslint-disable-next-line deprecation/deprecation
        const client = this.getClient();
        const options = client && client.getOptions();
        return Boolean(options && options.sendDefaultPii);
    }
    /**
   * Sends the current Session on the scope
   */ _sendSessionUpdate() {
        // eslint-disable-next-line deprecation/deprecation
        const { scope, client } = this.getStackTop();
        const session = scope.getSession();
        if (session && client && client.captureSession) {
            client.captureSession(session);
        }
    }
    /**
   * Calls global extension method and binding current instance to the function call
   */ // @ts-expect-error Function lacks ending return statement and return type does not include 'undefined'. ts(2366)
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    _callExtensionMethod(method, ...args) {
        const carrier = getMainCarrier();
        const sentry = carrier.__SENTRY__;
        if (sentry && sentry.extensions && typeof sentry.extensions[method] === "function") {
            return sentry.extensions[method].apply(this, args);
        }
        esm_debug_build_DEBUG_BUILD && logger_logger.warn(`Extension method ${method} couldn't be found, doing nothing.`);
    }
}
/**
 * Returns the global shim registry.
 *
 * FIXME: This function is problematic, because despite always returning a valid Carrier,
 * it has an optional `__SENTRY__` property, which then in turn requires us to always perform an unnecessary check
 * at the call-site. We always access the carrier through this function, so we can guarantee that `__SENTRY__` is there.
 **/ function getMainCarrier() {
    worldwide_GLOBAL_OBJ.__SENTRY__ = worldwide_GLOBAL_OBJ.__SENTRY__ || {
        extensions: {},
        hub: undefined
    };
    return worldwide_GLOBAL_OBJ;
}
/**
 * Replaces the current main hub with the passed one on the global object
 *
 * @returns The old replaced hub
 *
 * @deprecated Use `setCurrentClient()` instead.
 */ // eslint-disable-next-line deprecation/deprecation
function makeMain(hub) {
    const registry = getMainCarrier();
    const oldHub = getHubFromCarrier(registry);
    setHubOnCarrier(registry, hub);
    return oldHub;
}
/**
 * Returns the default hub instance.
 *
 * If a hub is already registered in the global carrier but this module
 * contains a more recent version, it replaces the registered version.
 * Otherwise, the currently registered hub will be returned.
 *
 * @deprecated Use the respective replacement method directly instead.
 */ // eslint-disable-next-line deprecation/deprecation
function hub_getCurrentHub() {
    // Get main carrier (global for every environment)
    const registry = getMainCarrier();
    if (registry.__SENTRY__ && registry.__SENTRY__.acs) {
        const hub = registry.__SENTRY__.acs.getCurrentHub();
        if (hub) {
            return hub;
        }
    }
    // Return hub that lives on a global object
    return getGlobalHub(registry);
}
/**
 * Get the currently active isolation scope.
 * The isolation scope is active for the current exection context,
 * meaning that it will remain stable for the same Hub.
 */ function hub_getIsolationScope() {
    // eslint-disable-next-line deprecation/deprecation
    return hub_getCurrentHub().getIsolationScope();
}
// eslint-disable-next-line deprecation/deprecation
function getGlobalHub(registry = getMainCarrier()) {
    // If there's no hub, or its an old API, assign a new one
    if (!hasHubOnCarrier(registry) || // eslint-disable-next-line deprecation/deprecation
    getHubFromCarrier(registry).isOlderThan(API_VERSION)) {
        // eslint-disable-next-line deprecation/deprecation
        setHubOnCarrier(registry, new Hub());
    }
    // Return hub that lives on a global object
    return getHubFromCarrier(registry);
}
/**
 * @private Private API with no semver guarantees!
 *
 * If the carrier does not contain a hub, a new hub is created with the global hub client and scope.
 */ // eslint-disable-next-line deprecation/deprecation
function ensureHubOnCarrier(carrier, parent = getGlobalHub()) {
    // If there's no hub on current domain, or it's an old API, assign a new one
    if (!hasHubOnCarrier(carrier) || // eslint-disable-next-line deprecation/deprecation
    getHubFromCarrier(carrier).isOlderThan(API_VERSION)) {
        // eslint-disable-next-line deprecation/deprecation
        const client = parent.getClient();
        // eslint-disable-next-line deprecation/deprecation
        const scope = parent.getScope();
        // eslint-disable-next-line deprecation/deprecation
        const isolationScope = parent.getIsolationScope();
        // eslint-disable-next-line deprecation/deprecation
        setHubOnCarrier(carrier, new Hub(client, scope.clone(), isolationScope.clone()));
    }
}
/**
 * @private Private API with no semver guarantees!
 *
 * Sets the global async context strategy
 */ function setAsyncContextStrategy(strategy) {
    // Get main carrier (global for every environment)
    const registry = getMainCarrier();
    registry.__SENTRY__ = registry.__SENTRY__ || {};
    registry.__SENTRY__.acs = strategy;
}
/**
 * Runs the supplied callback in its own async context. Async Context strategies are defined per SDK.
 *
 * @param callback The callback to run in its own async context
 * @param options Options to pass to the async context strategy
 * @returns The result of the callback
 */ function hub_runWithAsyncContext(callback, options = {}) {
    const registry = getMainCarrier();
    if (registry.__SENTRY__ && registry.__SENTRY__.acs) {
        return registry.__SENTRY__.acs.runWithAsyncContext(callback, options);
    }
    // if there was no strategy, fallback to just calling the callback
    return callback();
}
/**
 * This will tell whether a carrier has a hub on it or not
 * @param carrier object
 */ function hasHubOnCarrier(carrier) {
    return !!(carrier && carrier.__SENTRY__ && carrier.__SENTRY__.hub);
}
/**
 * This will create a new {@link Hub} and add to the passed object on
 * __SENTRY__.hub.
 * @param carrier object
 * @hidden
 */ // eslint-disable-next-line deprecation/deprecation
function getHubFromCarrier(carrier) {
    // eslint-disable-next-line deprecation/deprecation
    return getGlobalSingleton("hub", ()=>new Hub(), carrier);
}
/**
 * This will set passed {@link Hub} on the passed object's __SENTRY__.hub attribute
 * @param carrier object
 * @param hub Hub
 * @returns A boolean indicating success or failure
 */ // eslint-disable-next-line deprecation/deprecation
function setHubOnCarrier(carrier, hub) {
    if (!carrier) return false;
    const __SENTRY__ = carrier.__SENTRY__ = carrier.__SENTRY__ || {};
    __SENTRY__.hub = hub;
    return true;
}
 //# sourceMappingURL=hub.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/stacktrace.js


const STACKTRACE_FRAME_LIMIT = 50;
// Used to sanitize webpack (error: *) wrapped stack errors
const WEBPACK_ERROR_REGEXP = /\(error: (.*)\)/;
const STRIP_FRAME_REGEXP = /captureMessage|captureException/;
/**
 * Creates a stack parser with the supplied line parsers
 *
 * StackFrames are returned in the correct order for Sentry Exception
 * frames and with Sentry SDK internal frames removed from the top and bottom
 *
 */ function createStackParser(...parsers) {
    const sortedParsers = parsers.sort((a, b)=>a[0] - b[0]).map((p)=>p[1]);
    return (stack, skipFirst = 0)=>{
        const frames = [];
        const lines = stack.split("\n");
        for(let i = skipFirst; i < lines.length; i++){
            const line = lines[i];
            // Ignore lines over 1kb as they are unlikely to be stack frames.
            // Many of the regular expressions use backtracking which results in run time that increases exponentially with
            // input size. Huge strings can result in hangs/Denial of Service:
            // https://github.com/getsentry/sentry-javascript/issues/2286
            if (line.length > 1024) {
                continue;
            }
            // https://github.com/getsentry/sentry-javascript/issues/5459
            // Remove webpack (error: *) wrappers
            const cleanedLine = WEBPACK_ERROR_REGEXP.test(line) ? line.replace(WEBPACK_ERROR_REGEXP, "$1") : line;
            // https://github.com/getsentry/sentry-javascript/issues/7813
            // Skip Error: lines
            if (cleanedLine.match(/\S*Error: /)) {
                continue;
            }
            for (const parser of sortedParsers){
                const frame = parser(cleanedLine);
                if (frame) {
                    frames.push(frame);
                    break;
                }
            }
            if (frames.length >= STACKTRACE_FRAME_LIMIT) {
                break;
            }
        }
        return stripSentryFramesAndReverse(frames);
    };
}
/**
 * Gets a stack parser implementation from Options.stackParser
 * @see Options
 *
 * If options contains an array of line parsers, it is converted into a parser
 */ function stackParserFromStackParserOptions(stackParser) {
    if (Array.isArray(stackParser)) {
        return createStackParser(...stackParser);
    }
    return stackParser;
}
/**
 * Removes Sentry frames from the top and bottom of the stack if present and enforces a limit of max number of frames.
 * Assumes stack input is ordered from top to bottom and returns the reverse representation so call site of the
 * function that caused the crash is the last frame in the array.
 * @hidden
 */ function stripSentryFramesAndReverse(stack) {
    if (!stack.length) {
        return [];
    }
    const localStack = Array.from(stack);
    // If stack starts with one of our API calls, remove it (starts, meaning it's the top of the stack - aka last call)
    if (/sentryWrapped/.test(localStack[localStack.length - 1].function || "")) {
        localStack.pop();
    }
    // Reversing in the middle of the procedure allows us to just pop the values off the stack
    localStack.reverse();
    // If stack ends with one of our internal API calls, remove it (ends, meaning it's the bottom of the stack - aka top-most call)
    if (STRIP_FRAME_REGEXP.test(localStack[localStack.length - 1].function || "")) {
        localStack.pop();
        // When using synthetic events, we will have a 2 levels deep stack, as `new Error('Sentry syntheticException')`
        // is produced within the hub itself, making it:
        //
        //   Sentry.captureException()
        //   getCurrentHub().captureException()
        //
        // instead of just the top `Sentry` call itself.
        // This forces us to possibly strip an additional frame in the exact same was as above.
        if (STRIP_FRAME_REGEXP.test(localStack[localStack.length - 1].function || "")) {
            localStack.pop();
        }
    }
    return localStack.slice(0, STACKTRACE_FRAME_LIMIT).map((frame)=>({
            ...frame,
            filename: frame.filename || localStack[localStack.length - 1].filename,
            function: frame.function || "?"
        }));
}
const defaultFunctionName = "<anonymous>";
/**
 * Safely extract function name from itself
 */ function getFunctionName(fn) {
    try {
        if (!fn || typeof fn !== "function") {
            return defaultFunctionName;
        }
        return fn.name || defaultFunctionName;
    } catch (e) {
        // Just accessing custom props in some Selenium environments
        // can cause a "Permission denied" exception (see raven-js#495).
        return defaultFunctionName;
    }
}
/**
 * Node.js stack line parser
 *
 * This is in @sentry/utils so it can be used from the Electron SDK in the browser for when `nodeIntegration == true`.
 * This allows it to be used without referencing or importing any node specific code which causes bundlers to complain
 */ function nodeStackLineParser(getModule) {
    return [
        90,
        node(getModule)
    ];
}
 //# sourceMappingURL=stacktrace.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/instrument/_handlers.js



// We keep the handlers globally
const handlers = {};
const instrumented = {};
/** Add a handler function. */ function addHandler(type, handler) {
    handlers[type] = handlers[type] || [];
    handlers[type].push(handler);
}
/**
 * Reset all instrumentation handlers.
 * This can be used by tests to ensure we have a clean slate of instrumentation handlers.
 */ function resetInstrumentationHandlers() {
    Object.keys(handlers).forEach((key)=>{
        handlers[key] = undefined;
    });
}
/** Maybe run an instrumentation function, unless it was already called. */ function maybeInstrument(type, instrumentFn) {
    if (!instrumented[type]) {
        instrumentFn();
        instrumented[type] = true;
    }
}
/** Trigger handlers for a given instrumentation type. */ function triggerHandlers(type, data) {
    const typeHandlers = type && handlers[type];
    if (!typeHandlers) {
        return;
    }
    for (const handler of typeHandlers){
        try {
            handler(data);
        } catch (e) {
            debug_build_DEBUG_BUILD && logger_logger.error(`Error while triggering instrumentation handler.\nType: ${type}\nName: ${getFunctionName(handler)}\nError:`, e);
        }
    }
}
 //# sourceMappingURL=_handlers.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/instrument/globalError.js


let _oldOnErrorHandler = null;
/**
 * Add an instrumentation handler for when an error is captured by the global error handler.
 *
 * Use at your own risk, this might break without changelog notice, only used internally.
 * @hidden
 */ function addGlobalErrorInstrumentationHandler(handler) {
    const type = "error";
    addHandler(type, handler);
    maybeInstrument(type, instrumentError);
}
function instrumentError() {
    _oldOnErrorHandler = worldwide_GLOBAL_OBJ.onerror;
    worldwide_GLOBAL_OBJ.onerror = function(msg, url, line, column, error) {
        const handlerData = {
            column,
            error,
            line,
            msg,
            url
        };
        triggerHandlers("error", handlerData);
        if (_oldOnErrorHandler && !_oldOnErrorHandler.__SENTRY_LOADER__) {
            // eslint-disable-next-line prefer-rest-params
            return _oldOnErrorHandler.apply(this, arguments);
        }
        return false;
    };
    worldwide_GLOBAL_OBJ.onerror.__SENTRY_INSTRUMENTED__ = true;
}
 //# sourceMappingURL=globalError.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/instrument/globalUnhandledRejection.js


let _oldOnUnhandledRejectionHandler = null;
/**
 * Add an instrumentation handler for when an unhandled promise rejection is captured.
 *
 * Use at your own risk, this might break without changelog notice, only used internally.
 * @hidden
 */ function addGlobalUnhandledRejectionInstrumentationHandler(handler) {
    const type = "unhandledrejection";
    addHandler(type, handler);
    maybeInstrument(type, instrumentUnhandledRejection);
}
function instrumentUnhandledRejection() {
    _oldOnUnhandledRejectionHandler = worldwide_GLOBAL_OBJ.onunhandledrejection;
    worldwide_GLOBAL_OBJ.onunhandledrejection = function(e) {
        const handlerData = e;
        triggerHandlers("unhandledrejection", handlerData);
        if (_oldOnUnhandledRejectionHandler && !_oldOnUnhandledRejectionHandler.__SENTRY_LOADER__) {
            // eslint-disable-next-line prefer-rest-params
            return _oldOnUnhandledRejectionHandler.apply(this, arguments);
        }
        return true;
    };
    worldwide_GLOBAL_OBJ.onunhandledrejection.__SENTRY_INSTRUMENTED__ = true;
}
 //# sourceMappingURL=globalUnhandledRejection.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/utils.js



/**
 * Grabs active transaction off scope.
 *
 * @deprecated You should not rely on the transaction, but just use `startSpan()` APIs instead.
 */ // eslint-disable-next-line deprecation/deprecation
function getActiveTransaction(maybeHub) {
    // eslint-disable-next-line deprecation/deprecation
    const hub = maybeHub || hub_getCurrentHub();
    // eslint-disable-next-line deprecation/deprecation
    const scope = hub.getScope();
    // eslint-disable-next-line deprecation/deprecation
    return scope.getTransaction();
}
/**
 * The `extractTraceparentData` function and `TRACEPARENT_REGEXP` constant used
 * to be declared in this file. It was later moved into `@sentry/utils` as part of a
 * move to remove `@sentry/tracing` dependencies from `@sentry/node` (`extractTraceparentData`
 * is the only tracing function used by `@sentry/node`).
 *
 * These exports are kept here for backwards compatability's sake.
 *
 * See https://github.com/getsentry/sentry-javascript/issues/4642 for more details.
 *
 * @deprecated Import this function from `@sentry/utils` instead
 */ const utils_extractTraceparentData = (/* unused pure expression or super */ null && (extractTraceparentData$1));
 //# sourceMappingURL=utils.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/errors.js



let errorsInstrumented = false;
/**
 * Configures global error listeners
 */ function registerErrorInstrumentation() {
    if (errorsInstrumented) {
        return;
    }
    errorsInstrumented = true;
    addGlobalErrorInstrumentationHandler(errorCallback);
    addGlobalUnhandledRejectionInstrumentationHandler(errorCallback);
}
/**
 * If an error or unhandled promise occurs, we mark the active transaction as failed
 */ function errorCallback() {
    // eslint-disable-next-line deprecation/deprecation
    const activeTransaction = getActiveTransaction();
    if (activeTransaction) {
        const status = "internal_error";
        esm_debug_build_DEBUG_BUILD && logger_logger.log(`[Tracing] Transaction: ${status} -> Global error occured`);
        activeTransaction.setStatus(status);
    }
}
// The function name will be lost when bundling but we need to be able to identify this listener later to maintain the
// node.js default exit behaviour
errorCallback.tag = "sentry_tracingErrorCallback";
 //# sourceMappingURL=errors.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/semanticAttributes.js
/**
 * Use this attribute to represent the source of a span.
 * Should be one of: custom, url, route, view, component, task, unknown
 *
 */ const SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = "sentry.source";
/**
 * Use this attribute to represent the sample rate used for a span.
 */ const SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = "sentry.sample_rate";
/**
 * Use this attribute to represent the operation of a span.
 */ const SEMANTIC_ATTRIBUTE_SENTRY_OP = "sentry.op";
/**
 * Use this attribute to represent the origin of a span.
 */ const SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = "sentry.origin";
/**
 * The id of the profile that this span occured in.
 */ const SEMANTIC_ATTRIBUTE_PROFILE_ID = "profile_id";
 //# sourceMappingURL=semanticAttributes.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/utils/hasTracingEnabled.js

// Treeshakable guard to remove all code related to tracing
/**
 * Determines if tracing is currently enabled.
 *
 * Tracing is enabled when at least one of `tracesSampleRate` and `tracesSampler` is defined in the SDK config.
 */ function hasTracingEnabled_hasTracingEnabled(maybeOptions) {
    if (typeof __SENTRY_TRACING__ === "boolean" && !__SENTRY_TRACING__) {
        return false;
    }
    const client = getClient();
    const options = maybeOptions || client && client.getOptions();
    return !!options && (options.enableTracing || "tracesSampleRate" in options || "tracesSampler" in options);
}
 //# sourceMappingURL=hasTracingEnabled.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/sampling.js





/**
 * Makes a sampling decision for the given transaction and stores it on the transaction.
 *
 * Called every time a transaction is created. Only transactions which emerge with a `sampled` value of `true` will be
 * sent to Sentry.
 *
 * This method muttes the given `transaction` and will set the `sampled` value on it.
 * It returns the same transaction, for convenience.
 */ function sampling_sampleTransaction(transaction, options, samplingContext) {
    // nothing to do if tracing is not enabled
    if (!hasTracingEnabled_hasTracingEnabled(options)) {
        // eslint-disable-next-line deprecation/deprecation
        transaction.sampled = false;
        return transaction;
    }
    // if the user has forced a sampling decision by passing a `sampled` value in their transaction context, go with that
    // eslint-disable-next-line deprecation/deprecation
    if (transaction.sampled !== undefined) {
        // eslint-disable-next-line deprecation/deprecation
        transaction.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, Number(transaction.sampled));
        return transaction;
    }
    // we would have bailed already if neither `tracesSampler` nor `tracesSampleRate` nor `enableTracing` were defined, so one of these should
    // work; prefer the hook if so
    let sampleRate;
    if (typeof options.tracesSampler === "function") {
        sampleRate = options.tracesSampler(samplingContext);
        transaction.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, Number(sampleRate));
    } else if (samplingContext.parentSampled !== undefined) {
        sampleRate = samplingContext.parentSampled;
    } else if (typeof options.tracesSampleRate !== "undefined") {
        sampleRate = options.tracesSampleRate;
        transaction.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, Number(sampleRate));
    } else {
        // When `enableTracing === true`, we use a sample rate of 100%
        sampleRate = 1;
        transaction.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, sampleRate);
    }
    // Since this is coming from the user (or from a function provided by the user), who knows what we might get. (The
    // only valid values are booleans or numbers between 0 and 1.)
    if (!isValidSampleRate(sampleRate)) {
        esm_debug_build_DEBUG_BUILD && logger_logger.warn("[Tracing] Discarding transaction because of invalid sample rate.");
        // eslint-disable-next-line deprecation/deprecation
        transaction.sampled = false;
        return transaction;
    }
    // if the function returned 0 (or false), or if `tracesSampleRate` is 0, it's a sign the transaction should be dropped
    if (!sampleRate) {
        esm_debug_build_DEBUG_BUILD && logger_logger.log(`[Tracing] Discarding transaction because ${typeof options.tracesSampler === "function" ? "tracesSampler returned 0 or false" : "a negative sampling decision was inherited or tracesSampleRate is set to 0"}`);
        // eslint-disable-next-line deprecation/deprecation
        transaction.sampled = false;
        return transaction;
    }
    // Now we roll the dice. Math.random is inclusive of 0, but not of 1, so strict < is safe here. In case sampleRate is
    // a boolean, the < comparison will cause it to be automatically cast to 1 if it's true and 0 if it's false.
    // eslint-disable-next-line deprecation/deprecation
    transaction.sampled = Math.random() < sampleRate;
    // if we're not going to keep it, we're done
    // eslint-disable-next-line deprecation/deprecation
    if (!transaction.sampled) {
        esm_debug_build_DEBUG_BUILD && logger_logger.log(`[Tracing] Discarding transaction because it's not included in the random sample (sampling rate = ${Number(sampleRate)})`);
        return transaction;
    }
    esm_debug_build_DEBUG_BUILD && // eslint-disable-next-line deprecation/deprecation
    logger_logger.log(`[Tracing] starting ${transaction.op} transaction - ${spanUtils_spanToJSON(transaction).description}`);
    return transaction;
}
/**
 * Checks the given sample rate to make sure it is valid type and value (a boolean, or a number between 0 and 1).
 */ function isValidSampleRate(rate) {
    // we need to check NaN explicitly because it's of type 'number' and therefore wouldn't get caught by this typecheck
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    if (is_isNaN(rate) || !(typeof rate === "number" || typeof rate === "boolean")) {
        esm_debug_build_DEBUG_BUILD && logger_logger.warn(`[Tracing] Given sample rate is invalid. Sample rate must be a boolean or a number between 0 and 1. Got ${JSON.stringify(rate)} of type ${JSON.stringify(typeof rate)}.`);
        return false;
    }
    // in case sampleRate is a boolean, it will get automatically cast to 1 if it's true and 0 if it's false
    if (rate < 0 || rate > 1) {
        esm_debug_build_DEBUG_BUILD && logger_logger.warn(`[Tracing] Given sample rate is invalid. Sample rate must be between 0 and 1. Got ${rate}.`);
        return false;
    }
    return true;
}
 //# sourceMappingURL=sampling.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/metrics/metric-summary.js





/**
 * key: bucketKey
 * value: [exportKey, MetricSummary]
 */ let SPAN_METRIC_SUMMARY;
function getMetricStorageForSpan(span) {
    return SPAN_METRIC_SUMMARY ? SPAN_METRIC_SUMMARY.get(span) : undefined;
}
/**
 * Fetches the metric summary if it exists for the passed span
 */ function getMetricSummaryJsonForSpan(span) {
    const storage = getMetricStorageForSpan(span);
    if (!storage) {
        return undefined;
    }
    const output = {};
    for (const [, [exportKey, summary]] of storage){
        if (!output[exportKey]) {
            output[exportKey] = [];
        }
        output[exportKey].push(dropUndefinedKeys(summary));
    }
    return output;
}
/**
 * Updates the metric summary on the currently active span
 */ function updateMetricSummaryOnActiveSpan(metricType, sanitizedName, value, unit, tags, bucketKey) {
    const span = getActiveSpan();
    if (span) {
        const storage = getMetricStorageForSpan(span) || new Map();
        const exportKey = `${metricType}:${sanitizedName}@${unit}`;
        const bucketItem = storage.get(bucketKey);
        if (bucketItem) {
            const [, summary] = bucketItem;
            storage.set(bucketKey, [
                exportKey,
                {
                    min: Math.min(summary.min, value),
                    max: Math.max(summary.max, value),
                    count: summary.count += 1,
                    sum: summary.sum += value,
                    tags: summary.tags
                }
            ]);
        } else {
            storage.set(bucketKey, [
                exportKey,
                {
                    min: value,
                    max: value,
                    count: 1,
                    sum: value,
                    tags
                }
            ]);
        }
        if (!SPAN_METRIC_SUMMARY) {
            SPAN_METRIC_SUMMARY = new WeakMap();
        }
        SPAN_METRIC_SUMMARY.set(span, storage);
    }
}
 //# sourceMappingURL=metric-summary.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/spanstatus.js
/** The status of an Span.
 *
 * @deprecated Use string literals - if you require type casting, cast to SpanStatusType type
 */ var SpanStatus;
(function(SpanStatus) {
    /** The operation completed successfully. */ const Ok = "ok";
    SpanStatus["Ok"] = Ok;
    /** Deadline expired before operation could complete. */ const DeadlineExceeded = "deadline_exceeded";
    SpanStatus["DeadlineExceeded"] = DeadlineExceeded;
    /** 401 Unauthorized (actually does mean unauthenticated according to RFC 7235) */ const Unauthenticated = "unauthenticated";
    SpanStatus["Unauthenticated"] = Unauthenticated;
    /** 403 Forbidden */ const PermissionDenied = "permission_denied";
    SpanStatus["PermissionDenied"] = PermissionDenied;
    /** 404 Not Found. Some requested entity (file or directory) was not found. */ const NotFound = "not_found";
    SpanStatus["NotFound"] = NotFound;
    /** 429 Too Many Requests */ const ResourceExhausted = "resource_exhausted";
    SpanStatus["ResourceExhausted"] = ResourceExhausted;
    /** Client specified an invalid argument. 4xx. */ const InvalidArgument = "invalid_argument";
    SpanStatus["InvalidArgument"] = InvalidArgument;
    /** 501 Not Implemented */ const Unimplemented = "unimplemented";
    SpanStatus["Unimplemented"] = Unimplemented;
    /** 503 Service Unavailable */ const Unavailable = "unavailable";
    SpanStatus["Unavailable"] = Unavailable;
    /** Other/generic 5xx. */ const InternalError = "internal_error";
    SpanStatus["InternalError"] = InternalError;
    /** Unknown. Any non-standard HTTP status code. */ const UnknownError = "unknown_error";
    SpanStatus["UnknownError"] = UnknownError;
    /** The operation was cancelled (typically by the user). */ const Cancelled = "cancelled";
    SpanStatus["Cancelled"] = Cancelled;
    /** Already exists (409) */ const AlreadyExists = "already_exists";
    SpanStatus["AlreadyExists"] = AlreadyExists;
    /** Operation was rejected because the system is not in a state required for the operation's */ const FailedPrecondition = "failed_precondition";
    SpanStatus["FailedPrecondition"] = FailedPrecondition;
    /** The operation was aborted, typically due to a concurrency issue. */ const Aborted = "aborted";
    SpanStatus["Aborted"] = Aborted;
    /** Operation was attempted past the valid range. */ const OutOfRange = "out_of_range";
    SpanStatus["OutOfRange"] = OutOfRange;
    /** Unrecoverable data loss or corruption */ const DataLoss = "data_loss";
    SpanStatus["DataLoss"] = DataLoss;
})(SpanStatus || (SpanStatus = {}));
/**
 * Converts a HTTP status code into a {@link SpanStatusType}.
 *
 * @param httpStatus The HTTP response status code.
 * @returns The span status or unknown_error.
 */ function getSpanStatusFromHttpCode(httpStatus) {
    if (httpStatus < 400 && httpStatus >= 100) {
        return "ok";
    }
    if (httpStatus >= 400 && httpStatus < 500) {
        switch(httpStatus){
            case 401:
                return "unauthenticated";
            case 403:
                return "permission_denied";
            case 404:
                return "not_found";
            case 409:
                return "already_exists";
            case 413:
                return "failed_precondition";
            case 429:
                return "resource_exhausted";
            default:
                return "invalid_argument";
        }
    }
    if (httpStatus >= 500 && httpStatus < 600) {
        switch(httpStatus){
            case 501:
                return "unimplemented";
            case 503:
                return "unavailable";
            case 504:
                return "deadline_exceeded";
            default:
                return "internal_error";
        }
    }
    return "unknown_error";
}
/**
 * Converts a HTTP status code into a {@link SpanStatusType}.
 *
 * @deprecated Use {@link spanStatusFromHttpCode} instead.
 * This export will be removed in v8 as the signature contains a typo.
 *
 * @param httpStatus The HTTP response status code.
 * @returns The span status or unknown_error.
 */ const spanStatusfromHttpCode = (/* unused pure expression or super */ null && (getSpanStatusFromHttpCode));
/**
 * Sets the Http status attributes on the current span based on the http code.
 * Additionally, the span's status is updated, depending on the http code.
 */ function spanstatus_setHttpStatus(span, httpStatus) {
    // TODO (v8): Remove these calls
    // Relay does not require us to send the status code as a tag
    // For now, just because users might expect it to land as a tag we keep sending it.
    // Same with data.
    // In v8, we replace both, simply with
    // span.setAttribute('http.response.status_code', httpStatus);
    // eslint-disable-next-line deprecation/deprecation
    span.setTag("http.status_code", String(httpStatus));
    // eslint-disable-next-line deprecation/deprecation
    span.setData("http.response.status_code", httpStatus);
    const spanStatus = getSpanStatusFromHttpCode(httpStatus);
    if (spanStatus !== "unknown_error") {
        span.setStatus(spanStatus);
    }
}
 //# sourceMappingURL=spanstatus.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/span.js







/**
 * Keeps track of finished spans for a given transaction
 * @internal
 * @hideconstructor
 * @hidden
 */ class SpanRecorder {
    constructor(maxlen = 1000){
        this._maxlen = maxlen;
        this.spans = [];
    }
    /**
   * This is just so that we don't run out of memory while recording a lot
   * of spans. At some point we just stop and flush out the start of the
   * trace tree (i.e.the first n spans with the smallest
   * start_timestamp).
   */ add(span) {
        if (this.spans.length > this._maxlen) {
            // eslint-disable-next-line deprecation/deprecation
            span.spanRecorder = undefined;
        } else {
            this.spans.push(span);
        }
    }
}
/**
 * Span contains all data about a span
 */ class Span {
    /**
   * Tags for the span.
   * @deprecated Use `spanToJSON(span).atttributes` instead.
   */ /**
   * Data for the span.
   * @deprecated Use `spanToJSON(span).atttributes` instead.
   */ // eslint-disable-next-line @typescript-eslint/no-explicit-any
    /**
   * List of spans that were finalized
   *
   * @deprecated This property will no longer be public. Span recording will be handled internally.
   */ /**
   * @inheritDoc
   * @deprecated Use top level `Sentry.getRootSpan()` instead
   */ /**
   * The instrumenter that created this span.
   *
   * TODO (v8): This can probably be replaced by an `instanceOf` check of the span class.
   *            the instrumenter can only be sentry or otel so we can check the span instance
   *            to verify which one it is and remove this field entirely.
   *
   * @deprecated This field will be removed.
   */ /** Epoch timestamp in seconds when the span started. */ /** Epoch timestamp in seconds when the span ended. */ /** Internal keeper of the status */ /**
   * You should never call the constructor manually, always use `Sentry.startTransaction()`
   * or call `startChild()` on an existing span.
   * @internal
   * @hideconstructor
   * @hidden
   */ constructor(spanContext = {}){
        this._traceId = spanContext.traceId || misc_uuid4();
        this._spanId = spanContext.spanId || misc_uuid4().substring(16);
        this._startTime = spanContext.startTimestamp || time_timestampInSeconds();
        // eslint-disable-next-line deprecation/deprecation
        this.tags = spanContext.tags ? {
            ...spanContext.tags
        } : {};
        // eslint-disable-next-line deprecation/deprecation
        this.data = spanContext.data ? {
            ...spanContext.data
        } : {};
        // eslint-disable-next-line deprecation/deprecation
        this.instrumenter = spanContext.instrumenter || "sentry";
        this._attributes = {};
        this.setAttributes({
            [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: spanContext.origin || "manual",
            [SEMANTIC_ATTRIBUTE_SENTRY_OP]: spanContext.op,
            ...spanContext.attributes
        });
        // eslint-disable-next-line deprecation/deprecation
        this._name = spanContext.name || spanContext.description;
        if (spanContext.parentSpanId) {
            this._parentSpanId = spanContext.parentSpanId;
        }
        // We want to include booleans as well here
        if ("sampled" in spanContext) {
            this._sampled = spanContext.sampled;
        }
        if (spanContext.status) {
            this._status = spanContext.status;
        }
        if (spanContext.endTimestamp) {
            this._endTime = spanContext.endTimestamp;
        }
        if (spanContext.exclusiveTime !== undefined) {
            this._exclusiveTime = spanContext.exclusiveTime;
        }
        this._measurements = spanContext.measurements ? {
            ...spanContext.measurements
        } : {};
    }
    // This rule conflicts with another eslint rule :(
    /* eslint-disable @typescript-eslint/member-ordering */ /**
   * An alias for `description` of the Span.
   * @deprecated Use `spanToJSON(span).description` instead.
   */ get name() {
        return this._name || "";
    }
    /**
   * Update the name of the span.
   * @deprecated Use `spanToJSON(span).description` instead.
   */ set name(name) {
        this.updateName(name);
    }
    /**
   * Get the description of the Span.
   * @deprecated Use `spanToJSON(span).description` instead.
   */ get description() {
        return this._name;
    }
    /**
   * Get the description of the Span.
   * @deprecated Use `spanToJSON(span).description` instead.
   */ set description(description) {
        this._name = description;
    }
    /**
   * The ID of the trace.
   * @deprecated Use `spanContext().traceId` instead.
   */ get traceId() {
        return this._traceId;
    }
    /**
   * The ID of the trace.
   * @deprecated You cannot update the traceId of a span after span creation.
   */ set traceId(traceId) {
        this._traceId = traceId;
    }
    /**
   * The ID of the span.
   * @deprecated Use `spanContext().spanId` instead.
   */ get spanId() {
        return this._spanId;
    }
    /**
   * The ID of the span.
   * @deprecated You cannot update the spanId of a span after span creation.
   */ set spanId(spanId) {
        this._spanId = spanId;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `startSpan` functions instead.
   */ set parentSpanId(string) {
        this._parentSpanId = string;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `spanToJSON(span).parent_span_id` instead.
   */ get parentSpanId() {
        return this._parentSpanId;
    }
    /**
   * Was this span chosen to be sent as part of the sample?
   * @deprecated Use `isRecording()` instead.
   */ get sampled() {
        return this._sampled;
    }
    /**
   * Was this span chosen to be sent as part of the sample?
   * @deprecated You cannot update the sampling decision of a span after span creation.
   */ set sampled(sampled) {
        this._sampled = sampled;
    }
    /**
   * Attributes for the span.
   * @deprecated Use `spanToJSON(span).atttributes` instead.
   */ get attributes() {
        return this._attributes;
    }
    /**
   * Attributes for the span.
   * @deprecated Use `setAttributes()` instead.
   */ set attributes(attributes) {
        this._attributes = attributes;
    }
    /**
   * Timestamp in seconds (epoch time) indicating when the span started.
   * @deprecated Use `spanToJSON()` instead.
   */ get startTimestamp() {
        return this._startTime;
    }
    /**
   * Timestamp in seconds (epoch time) indicating when the span started.
   * @deprecated In v8, you will not be able to update the span start time after creation.
   */ set startTimestamp(startTime) {
        this._startTime = startTime;
    }
    /**
   * Timestamp in seconds when the span ended.
   * @deprecated Use `spanToJSON()` instead.
   */ get endTimestamp() {
        return this._endTime;
    }
    /**
   * Timestamp in seconds when the span ended.
   * @deprecated Set the end time via `span.end()` instead.
   */ set endTimestamp(endTime) {
        this._endTime = endTime;
    }
    /**
   * The status of the span.
   *
   * @deprecated Use `spanToJSON().status` instead to get the status.
   */ get status() {
        return this._status;
    }
    /**
   * The status of the span.
   *
   * @deprecated Use `.setStatus()` instead to set or update the status.
   */ set status(status) {
        this._status = status;
    }
    /**
   * Operation of the span
   *
   * @deprecated Use `spanToJSON().op` to read the op instead.
   */ get op() {
        return this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP];
    }
    /**
   * Operation of the span
   *
   * @deprecated Use `startSpan()` functions to set or `span.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_OP, 'op')
   *             to update the span instead.
   */ set op(op) {
        this.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_OP, op);
    }
    /**
   * The origin of the span, giving context about what created the span.
   *
   * @deprecated Use `spanToJSON().origin` to read the origin instead.
   */ get origin() {
        return this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN];
    }
    /**
   * The origin of the span, giving context about what created the span.
   *
   * @deprecated Use `startSpan()` functions to set the origin instead.
   */ set origin(origin) {
        this.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, origin);
    }
    /* eslint-enable @typescript-eslint/member-ordering */ /** @inheritdoc */ spanContext() {
        const { _spanId: spanId, _traceId: traceId, _sampled: sampled } = this;
        return {
            spanId,
            traceId,
            traceFlags: sampled ? TRACE_FLAG_SAMPLED : TRACE_FLAG_NONE
        };
    }
    /**
   * Creates a new `Span` while setting the current `Span.id` as `parentSpanId`.
   * Also the `sampled` decision will be inherited.
   *
   * @deprecated Use `startSpan()`, `startSpanManual()` or `startInactiveSpan()` instead.
   */ startChild(spanContext) {
        const childSpan = new Span({
            ...spanContext,
            parentSpanId: this._spanId,
            sampled: this._sampled,
            traceId: this._traceId
        });
        // eslint-disable-next-line deprecation/deprecation
        childSpan.spanRecorder = this.spanRecorder;
        // eslint-disable-next-line deprecation/deprecation
        if (childSpan.spanRecorder) {
            // eslint-disable-next-line deprecation/deprecation
            childSpan.spanRecorder.add(childSpan);
        }
        const rootSpan = getRootSpan(this);
        // TODO: still set span.transaction here until we have a more permanent solution
        // Probably similarly to the weakmap we hold in node-experimental
        // eslint-disable-next-line deprecation/deprecation
        childSpan.transaction = rootSpan;
        if (esm_debug_build_DEBUG_BUILD && rootSpan) {
            const opStr = spanContext && spanContext.op || "< unknown op >";
            const nameStr = spanUtils_spanToJSON(childSpan).description || "< unknown name >";
            const idStr = rootSpan.spanContext().spanId;
            const logMessage = `[Tracing] Starting '${opStr}' span on transaction '${nameStr}' (${idStr}).`;
            logger_logger.log(logMessage);
            this._logMessage = logMessage;
        }
        return childSpan;
    }
    /**
   * Sets the tag attribute on the current span.
   *
   * Can also be used to unset a tag, by passing `undefined`.
   *
   * @param key Tag key
   * @param value Tag value
   * @deprecated Use `setAttribute()` instead.
   */ setTag(key, value) {
        // eslint-disable-next-line deprecation/deprecation
        this.tags = {
            ...this.tags,
            [key]: value
        };
        return this;
    }
    /**
   * Sets the data attribute on the current span
   * @param key Data key
   * @param value Data value
   * @deprecated Use `setAttribute()` instead.
   */ // eslint-disable-next-line @typescript-eslint/no-explicit-any
    setData(key, value) {
        // eslint-disable-next-line deprecation/deprecation
        this.data = {
            ...this.data,
            [key]: value
        };
        return this;
    }
    /** @inheritdoc */ setAttribute(key, value) {
        if (value === undefined) {
            // eslint-disable-next-line @typescript-eslint/no-dynamic-delete
            delete this._attributes[key];
        } else {
            this._attributes[key] = value;
        }
    }
    /** @inheritdoc */ setAttributes(attributes) {
        Object.keys(attributes).forEach((key)=>this.setAttribute(key, attributes[key]));
    }
    /**
   * @inheritDoc
   */ setStatus(value) {
        this._status = value;
        return this;
    }
    /**
   * @inheritDoc
   * @deprecated Use top-level `setHttpStatus()` instead.
   */ setHttpStatus(httpStatus) {
        spanstatus_setHttpStatus(this, httpStatus);
        return this;
    }
    /**
   * @inheritdoc
   *
   * @deprecated Use `.updateName()` instead.
   */ setName(name) {
        this.updateName(name);
    }
    /**
   * @inheritDoc
   */ updateName(name) {
        this._name = name;
        return this;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `spanToJSON(span).status === 'ok'` instead.
   */ isSuccess() {
        return this._status === "ok";
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `.end()` instead.
   */ finish(endTimestamp) {
        return this.end(endTimestamp);
    }
    /** @inheritdoc */ end(endTimestamp) {
        // If already ended, skip
        if (this._endTime) {
            return;
        }
        const rootSpan = getRootSpan(this);
        if (esm_debug_build_DEBUG_BUILD && // Don't call this for transactions
        rootSpan && rootSpan.spanContext().spanId !== this._spanId) {
            const logMessage = this._logMessage;
            if (logMessage) {
                logger_logger.log(logMessage.replace("Starting", "Finishing"));
            }
        }
        this._endTime = spanTimeInputToSeconds(endTimestamp);
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `spanToTraceHeader()` instead.
   */ toTraceparent() {
        return spanToTraceHeader(this);
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `spanToJSON()` or access the fields directly instead.
   */ toContext() {
        return dropUndefinedKeys({
            data: this._getData(),
            description: this._name,
            endTimestamp: this._endTime,
            // eslint-disable-next-line deprecation/deprecation
            op: this.op,
            parentSpanId: this._parentSpanId,
            sampled: this._sampled,
            spanId: this._spanId,
            startTimestamp: this._startTime,
            status: this._status,
            // eslint-disable-next-line deprecation/deprecation
            tags: this.tags,
            traceId: this._traceId
        });
    }
    /**
   * @inheritDoc
   *
   * @deprecated Update the fields directly instead.
   */ updateWithContext(spanContext) {
        // eslint-disable-next-line deprecation/deprecation
        this.data = spanContext.data || {};
        // eslint-disable-next-line deprecation/deprecation
        this._name = spanContext.name || spanContext.description;
        this._endTime = spanContext.endTimestamp;
        // eslint-disable-next-line deprecation/deprecation
        this.op = spanContext.op;
        this._parentSpanId = spanContext.parentSpanId;
        this._sampled = spanContext.sampled;
        this._spanId = spanContext.spanId || this._spanId;
        this._startTime = spanContext.startTimestamp || this._startTime;
        this._status = spanContext.status;
        // eslint-disable-next-line deprecation/deprecation
        this.tags = spanContext.tags || {};
        this._traceId = spanContext.traceId || this._traceId;
        return this;
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use `spanToTraceContext()` util function instead.
   */ getTraceContext() {
        return spanToTraceContext(this);
    }
    /**
   * Get JSON representation of this span.
   *
   * @hidden
   * @internal This method is purely for internal purposes and should not be used outside
   * of SDK code. If you need to get a JSON representation of a span,
   * use `spanToJSON(span)` instead.
   */ getSpanJSON() {
        return dropUndefinedKeys({
            data: this._getData(),
            description: this._name,
            op: this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP],
            parent_span_id: this._parentSpanId,
            span_id: this._spanId,
            start_timestamp: this._startTime,
            status: this._status,
            // eslint-disable-next-line deprecation/deprecation
            tags: Object.keys(this.tags).length > 0 ? this.tags : undefined,
            timestamp: this._endTime,
            trace_id: this._traceId,
            origin: this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN],
            _metrics_summary: getMetricSummaryJsonForSpan(this),
            profile_id: this._attributes[SEMANTIC_ATTRIBUTE_PROFILE_ID],
            exclusive_time: this._exclusiveTime,
            measurements: Object.keys(this._measurements).length > 0 ? this._measurements : undefined
        });
    }
    /** @inheritdoc */ isRecording() {
        return !this._endTime && !!this._sampled;
    }
    /**
   * Convert the object to JSON.
   * @deprecated Use `spanToJSON(span)` instead.
   */ toJSON() {
        return this.getSpanJSON();
    }
    /**
   * Get the merged data for this span.
   * For now, this combines `data` and `attributes` together,
   * until eventually we can ingest `attributes` directly.
   */ _getData() {
        // eslint-disable-next-line deprecation/deprecation
        const { data, _attributes: attributes } = this;
        const hasData = Object.keys(data).length > 0;
        const hasAttributes = Object.keys(attributes).length > 0;
        if (!hasData && !hasAttributes) {
            return undefined;
        }
        if (hasData && hasAttributes) {
            return {
                ...data,
                ...attributes
            };
        }
        return hasData ? data : attributes;
    }
}
 //# sourceMappingURL=span.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/utils/handleCallbackErrors.js

/**
 * Wrap a callback function with error handling.
 * If an error is thrown, it will be passed to the `onError` callback and re-thrown.
 *
 * If the return value of the function is a promise, it will be handled with `maybeHandlePromiseRejection`.
 *
 * If an `onFinally` callback is provided, this will be called when the callback has finished
 * - so if it returns a promise, once the promise resolved/rejected,
 * else once the callback has finished executing.
 * The `onFinally` callback will _always_ be called, no matter if an error was thrown or not.
 */ function handleCallbackErrors_handleCallbackErrors(fn, onError, // eslint-disable-next-line @typescript-eslint/no-empty-function
onFinally = ()=>{}) {
    let maybePromiseResult;
    try {
        maybePromiseResult = fn();
    } catch (e) {
        onError(e);
        onFinally();
        throw e;
    }
    return maybeHandlePromiseRejection(maybePromiseResult, onError, onFinally);
}
/**
 * Maybe handle a promise rejection.
 * This expects to be given a value that _may_ be a promise, or any other value.
 * If it is a promise, and it rejects, it will call the `onError` callback.
 * Other than this, it will generally return the given value as-is.
 */ function maybeHandlePromiseRejection(value, onError, onFinally) {
    if (is_isThenable(value)) {
        // @ts-expect-error - the isThenable check returns the "wrong" type here
        return value.then((res)=>{
            onFinally();
            return res;
        }, (e)=>{
            onError(e);
            onFinally();
            throw e;
        });
    }
    onFinally();
    return value;
}
 //# sourceMappingURL=handleCallbackErrors.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/trace.js










/**
 * Wraps a function with a transaction/span and finishes the span after the function is done.
 *
 * Note that if you have not enabled tracing extensions via `addTracingExtensions`
 * or you didn't set `tracesSampleRate`, this function will not generate spans
 * and the `span` returned from the callback will be undefined.
 *
 * This function is meant to be used internally and may break at any time. Use at your own risk.
 *
 * @internal
 * @private
 *
 * @deprecated Use `startSpan` instead.
 */ function trace(context, callback, // eslint-disable-next-line @typescript-eslint/no-empty-function
onError = ()=>{}, // eslint-disable-next-line @typescript-eslint/no-empty-function
afterFinish = ()=>{}) {
    // eslint-disable-next-line deprecation/deprecation
    const hub = getCurrentHub();
    const scope = getCurrentScope();
    // eslint-disable-next-line deprecation/deprecation
    const parentSpan = scope.getSpan();
    const spanContext = normalizeContext(context);
    const activeSpan = createChildSpanOrTransaction(hub, {
        parentSpan,
        spanContext,
        forceTransaction: false,
        scope
    });
    // eslint-disable-next-line deprecation/deprecation
    scope.setSpan(activeSpan);
    return handleCallbackErrors(()=>callback(activeSpan), (error)=>{
        activeSpan && activeSpan.setStatus("internal_error");
        onError(error, activeSpan);
    }, ()=>{
        activeSpan && activeSpan.end();
        // eslint-disable-next-line deprecation/deprecation
        scope.setSpan(parentSpan);
        afterFinish();
    });
}
/**
 * Wraps a function with a transaction/span and finishes the span after the function is done.
 * The created span is the active span and will be used as parent by other spans created inside the function
 * and can be accessed via `Sentry.getSpan()`, as long as the function is executed while the scope is active.
 *
 * If you want to create a span that is not set as active, use {@link startInactiveSpan}.
 *
 * Note that if you have not enabled tracing extensions via `addTracingExtensions`
 * or you didn't set `tracesSampleRate`, this function will not generate spans
 * and the `span` returned from the callback will be undefined.
 */ function startSpan(context, callback) {
    const spanContext = normalizeContext(context);
    return hub_runWithAsyncContext(()=>{
        return exports_withScope(context.scope, (scope)=>{
            // eslint-disable-next-line deprecation/deprecation
            const hub = hub_getCurrentHub();
            // eslint-disable-next-line deprecation/deprecation
            const parentSpan = scope.getSpan();
            const shouldSkipSpan = context.onlyIfParent && !parentSpan;
            const activeSpan = shouldSkipSpan ? undefined : createChildSpanOrTransaction(hub, {
                parentSpan,
                spanContext,
                forceTransaction: context.forceTransaction,
                scope
            });
            return handleCallbackErrors_handleCallbackErrors(()=>callback(activeSpan), ()=>{
                // Only update the span status if it hasn't been changed yet
                if (activeSpan) {
                    const { status } = spanUtils_spanToJSON(activeSpan);
                    if (!status || status === "ok") {
                        activeSpan.setStatus("internal_error");
                    }
                }
            }, ()=>activeSpan && activeSpan.end());
        });
    });
}
/**
 * @deprecated Use {@link startSpan} instead.
 */ const startActiveSpan = (/* unused pure expression or super */ null && (startSpan));
/**
 * Similar to `Sentry.startSpan`. Wraps a function with a transaction/span, but does not finish the span
 * after the function is done automatically. You'll have to call `span.end()` manually.
 *
 * The created span is the active span and will be used as parent by other spans created inside the function
 * and can be accessed via `Sentry.getActiveSpan()`, as long as the function is executed while the scope is active.
 *
 * Note that if you have not enabled tracing extensions via `addTracingExtensions`
 * or you didn't set `tracesSampleRate`, this function will not generate spans
 * and the `span` returned from the callback will be undefined.
 */ function startSpanManual(context, callback) {
    const spanContext = normalizeContext(context);
    return runWithAsyncContext(()=>{
        return withScope(context.scope, (scope)=>{
            // eslint-disable-next-line deprecation/deprecation
            const hub = getCurrentHub();
            // eslint-disable-next-line deprecation/deprecation
            const parentSpan = scope.getSpan();
            const shouldSkipSpan = context.onlyIfParent && !parentSpan;
            const activeSpan = shouldSkipSpan ? undefined : createChildSpanOrTransaction(hub, {
                parentSpan,
                spanContext,
                forceTransaction: context.forceTransaction,
                scope
            });
            function finishAndSetSpan() {
                activeSpan && activeSpan.end();
            }
            return handleCallbackErrors(()=>callback(activeSpan, finishAndSetSpan), ()=>{
                // Only update the span status if it hasn't been changed yet, and the span is not yet finished
                if (activeSpan && activeSpan.isRecording()) {
                    const { status } = spanToJSON(activeSpan);
                    if (!status || status === "ok") {
                        activeSpan.setStatus("internal_error");
                    }
                }
            });
        });
    });
}
/**
 * Creates a span. This span is not set as active, so will not get automatic instrumentation spans
 * as children or be able to be accessed via `Sentry.getSpan()`.
 *
 * If you want to create a span that is set as active, use {@link startSpan}.
 *
 * Note that if you have not enabled tracing extensions via `addTracingExtensions`
 * or you didn't set `tracesSampleRate` or `tracesSampler`, this function will not generate spans
 * and the `span` returned from the callback will be undefined.
 */ function startInactiveSpan(context) {
    if (!hasTracingEnabled()) {
        return undefined;
    }
    const spanContext = normalizeContext(context);
    // eslint-disable-next-line deprecation/deprecation
    const hub = getCurrentHub();
    const parentSpan = context.scope ? context.scope.getSpan() : trace_getActiveSpan();
    const shouldSkipSpan = context.onlyIfParent && !parentSpan;
    if (shouldSkipSpan) {
        return undefined;
    }
    const scope = context.scope || getCurrentScope();
    // Even though we don't actually want to make this span active on the current scope,
    // we need to make it active on a temporary scope that we use for event processing
    // as otherwise, it won't pick the correct span for the event when processing it
    const temporaryScope = scope.clone();
    return createChildSpanOrTransaction(hub, {
        parentSpan,
        spanContext,
        forceTransaction: context.forceTransaction,
        scope: temporaryScope
    });
}
/**
 * Returns the currently active span.
 */ function trace_getActiveSpan() {
    // eslint-disable-next-line deprecation/deprecation
    return getCurrentScope().getSpan();
}
const continueTrace = ({ sentryTrace, baggage }, callback)=>{
    // TODO(v8): Change this function so it doesn't do anything besides setting the propagation context on the current scope:
    /*
    return withScope((scope) => {
      const propagationContext = propagationContextFromHeaders(sentryTrace, baggage);
      scope.setPropagationContext(propagationContext);
      return callback();
    })
  */ const currentScope = exports_getCurrentScope();
    // eslint-disable-next-line deprecation/deprecation
    const { traceparentData, dynamicSamplingContext, propagationContext } = tracingContextFromHeaders(sentryTrace, baggage);
    currentScope.setPropagationContext(propagationContext);
    if (esm_debug_build_DEBUG_BUILD && traceparentData) {
        logger_logger.log(`[Tracing] Continuing trace ${traceparentData.traceId}.`);
    }
    const transactionContext = {
        ...traceparentData,
        metadata: dropUndefinedKeys({
            dynamicSamplingContext
        })
    };
    if (!callback) {
        return transactionContext;
    }
    return hub_runWithAsyncContext(()=>{
        return callback(transactionContext);
    });
};
function createChildSpanOrTransaction(// eslint-disable-next-line deprecation/deprecation
hub, { parentSpan, spanContext, forceTransaction, scope }) {
    if (!hasTracingEnabled_hasTracingEnabled()) {
        return undefined;
    }
    const isolationScope = hub_getIsolationScope();
    let span;
    if (parentSpan && !forceTransaction) {
        // eslint-disable-next-line deprecation/deprecation
        span = parentSpan.startChild(spanContext);
    } else if (parentSpan) {
        // If we forced a transaction but have a parent span, make sure to continue from the parent span, not the scope
        const dsc = getDynamicSamplingContextFromSpan(parentSpan);
        const { traceId, spanId: parentSpanId } = parentSpan.spanContext();
        const sampled = spanIsSampled(parentSpan);
        // eslint-disable-next-line deprecation/deprecation
        span = hub.startTransaction({
            traceId,
            parentSpanId,
            parentSampled: sampled,
            ...spanContext,
            metadata: {
                dynamicSamplingContext: dsc,
                // eslint-disable-next-line deprecation/deprecation
                ...spanContext.metadata
            }
        });
    } else {
        const { traceId, dsc, parentSpanId, sampled } = {
            ...isolationScope.getPropagationContext(),
            ...scope.getPropagationContext()
        };
        // eslint-disable-next-line deprecation/deprecation
        span = hub.startTransaction({
            traceId,
            parentSpanId,
            parentSampled: sampled,
            ...spanContext,
            metadata: {
                dynamicSamplingContext: dsc,
                // eslint-disable-next-line deprecation/deprecation
                ...spanContext.metadata
            }
        });
    }
    // We always set this as active span on the scope
    // In the case of this being an inactive span, we ensure to pass a detached scope in here in the first place
    // But by having this here, we can ensure that the lookup through `getCapturedScopesOnSpan` results in the correct scope & span combo
    // eslint-disable-next-line deprecation/deprecation
    scope.setSpan(span);
    setCapturedScopesOnSpan(span, scope, isolationScope);
    return span;
}
/**
 * This converts StartSpanOptions to TransactionContext.
 * For the most part (for now) we accept the same options,
 * but some of them need to be transformed.
 *
 * Eventually the StartSpanOptions will be more aligned with OpenTelemetry.
 */ function normalizeContext(context) {
    if (context.startTime) {
        const ctx = {
            ...context
        };
        ctx.startTimestamp = spanTimeInputToSeconds(context.startTime);
        delete ctx.startTime;
        return ctx;
    }
    return context;
}
const SCOPE_ON_START_SPAN_FIELD = "_sentryScope";
const ISOLATION_SCOPE_ON_START_SPAN_FIELD = "_sentryIsolationScope";
function setCapturedScopesOnSpan(span, scope, isolationScope) {
    if (span) {
        object_addNonEnumerableProperty(span, ISOLATION_SCOPE_ON_START_SPAN_FIELD, isolationScope);
        object_addNonEnumerableProperty(span, SCOPE_ON_START_SPAN_FIELD, scope);
    }
}
/**
 * Grabs the scope and isolation scope off a span that were active when the span was started.
 */ function getCapturedScopesOnSpan(span) {
    return {
        scope: span[SCOPE_ON_START_SPAN_FIELD],
        isolationScope: span[ISOLATION_SCOPE_ON_START_SPAN_FIELD]
    };
}
 //# sourceMappingURL=trace.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/transaction.js









/** JSDoc */ class Transaction extends Span {
    /**
   * The reference to the current hub.
   */ // eslint-disable-next-line deprecation/deprecation
    // DO NOT yet remove this property, it is used in a hack for v7 backwards compatibility.
    /**
   * This constructor should never be called manually. Those instrumenting tracing should use
   * `Sentry.startTransaction()`, and internal methods should use `hub.startTransaction()`.
   * @internal
   * @hideconstructor
   * @hidden
   *
   * @deprecated Transactions will be removed in v8. Use spans instead.
   */ // eslint-disable-next-line deprecation/deprecation
    constructor(transactionContext, hub){
        super(transactionContext);
        this._contexts = {};
        // eslint-disable-next-line deprecation/deprecation
        this._hub = hub || hub_getCurrentHub();
        this._name = transactionContext.name || "";
        this._metadata = {
            // eslint-disable-next-line deprecation/deprecation
            ...transactionContext.metadata
        };
        this._trimEnd = transactionContext.trimEnd;
        // this is because transactions are also spans, and spans have a transaction pointer
        // TODO (v8): Replace this with another way to set the root span
        // eslint-disable-next-line deprecation/deprecation
        this.transaction = this;
        // If Dynamic Sampling Context is provided during the creation of the transaction, we freeze it as it usually means
        // there is incoming Dynamic Sampling Context. (Either through an incoming request, a baggage meta-tag, or other means)
        const incomingDynamicSamplingContext = this._metadata.dynamicSamplingContext;
        if (incomingDynamicSamplingContext) {
            // We shallow copy this in case anything writes to the original reference of the passed in `dynamicSamplingContext`
            this._frozenDynamicSamplingContext = {
                ...incomingDynamicSamplingContext
            };
        }
    }
    // This sadly conflicts with the getter/setter ordering :(
    /* eslint-disable @typescript-eslint/member-ordering */ /**
   * Getter for `name` property.
   * @deprecated Use `spanToJSON(span).description` instead.
   */ get name() {
        return this._name;
    }
    /**
   * Setter for `name` property, which also sets `source` as custom.
   * @deprecated Use `updateName()` and `setMetadata()` instead.
   */ set name(newName) {
        // eslint-disable-next-line deprecation/deprecation
        this.setName(newName);
    }
    /**
   * Get the metadata for this transaction.
   * @deprecated Use `spanGetMetadata(transaction)` instead.
   */ get metadata() {
        // We merge attributes in for backwards compatibility
        return {
            // Defaults
            // eslint-disable-next-line deprecation/deprecation
            source: "custom",
            spanMetadata: {},
            // Legacy metadata
            ...this._metadata,
            // From attributes
            ...this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_SOURCE] && {
                source: this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_SOURCE]
            },
            ...this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE] && {
                sampleRate: this._attributes[SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE]
            }
        };
    }
    /**
   * Update the metadata for this transaction.
   * @deprecated Use `spanGetMetadata(transaction)` instead.
   */ set metadata(metadata) {
        this._metadata = metadata;
    }
    /* eslint-enable @typescript-eslint/member-ordering */ /**
   * Setter for `name` property, which also sets `source` on the metadata.
   *
   * @deprecated Use `.updateName()` and `.setAttribute()` instead.
   */ setName(name, source = "custom") {
        this._name = name;
        this.setAttribute(SEMANTIC_ATTRIBUTE_SENTRY_SOURCE, source);
    }
    /** @inheritdoc */ updateName(name) {
        this._name = name;
        return this;
    }
    /**
   * Attaches SpanRecorder to the span itself
   * @param maxlen maximum number of spans that can be recorded
   */ initSpanRecorder(maxlen = 1000) {
        // eslint-disable-next-line deprecation/deprecation
        if (!this.spanRecorder) {
            // eslint-disable-next-line deprecation/deprecation
            this.spanRecorder = new SpanRecorder(maxlen);
        }
        // eslint-disable-next-line deprecation/deprecation
        this.spanRecorder.add(this);
    }
    /**
   * Set the context of a transaction event.
   * @deprecated Use either `.setAttribute()`, or set the context on the scope before creating the transaction.
   */ setContext(key, context) {
        if (context === null) {
            // eslint-disable-next-line @typescript-eslint/no-dynamic-delete
            delete this._contexts[key];
        } else {
            this._contexts[key] = context;
        }
    }
    /**
   * @inheritDoc
   *
   * @deprecated Use top-level `setMeasurement()` instead.
   */ setMeasurement(name, value, unit = "") {
        this._measurements[name] = {
            value,
            unit
        };
    }
    /**
   * Store metadata on this transaction.
   * @deprecated Use attributes or store data on the scope instead.
   */ setMetadata(newMetadata) {
        this._metadata = {
            ...this._metadata,
            ...newMetadata
        };
    }
    /**
   * @inheritDoc
   */ end(endTimestamp) {
        const timestampInS = spanTimeInputToSeconds(endTimestamp);
        const transaction = this._finishTransaction(timestampInS);
        if (!transaction) {
            return undefined;
        }
        // eslint-disable-next-line deprecation/deprecation
        return this._hub.captureEvent(transaction);
    }
    /**
   * @inheritDoc
   */ toContext() {
        // eslint-disable-next-line deprecation/deprecation
        const spanContext = super.toContext();
        return dropUndefinedKeys({
            ...spanContext,
            name: this._name,
            trimEnd: this._trimEnd
        });
    }
    /**
   * @inheritDoc
   */ updateWithContext(transactionContext) {
        // eslint-disable-next-line deprecation/deprecation
        super.updateWithContext(transactionContext);
        this._name = transactionContext.name || "";
        this._trimEnd = transactionContext.trimEnd;
        return this;
    }
    /**
   * @inheritdoc
   *
   * @experimental
   *
   * @deprecated Use top-level `getDynamicSamplingContextFromSpan` instead.
   */ getDynamicSamplingContext() {
        return getDynamicSamplingContextFromSpan(this);
    }
    /**
   * Override the current hub with a new one.
   * Used if you want another hub to finish the transaction.
   *
   * @internal
   */ // eslint-disable-next-line deprecation/deprecation
    setHub(hub) {
        this._hub = hub;
    }
    /**
   * Get the profile id of the transaction.
   */ getProfileId() {
        if (this._contexts !== undefined && this._contexts["profile"] !== undefined) {
            return this._contexts["profile"].profile_id;
        }
        return undefined;
    }
    /**
   * Finish the transaction & prepare the event to send to Sentry.
   */ _finishTransaction(endTimestamp) {
        // This transaction is already finished, so we should not flush it again.
        if (this._endTime !== undefined) {
            return undefined;
        }
        if (!this._name) {
            esm_debug_build_DEBUG_BUILD && logger_logger.warn("Transaction has no name, falling back to `<unlabeled transaction>`.");
            this._name = "<unlabeled transaction>";
        }
        // just sets the end timestamp
        super.end(endTimestamp);
        // eslint-disable-next-line deprecation/deprecation
        const client = this._hub.getClient();
        if (client && client.emit) {
            client.emit("finishTransaction", this);
        }
        if (this._sampled !== true) {
            // At this point if `sampled !== true` we want to discard the transaction.
            esm_debug_build_DEBUG_BUILD && logger_logger.log("[Tracing] Discarding transaction because its trace was not chosen to be sampled.");
            if (client) {
                client.recordDroppedEvent("sample_rate", "transaction");
            }
            return undefined;
        }
        // eslint-disable-next-line deprecation/deprecation
        const finishedSpans = this.spanRecorder ? this.spanRecorder.spans.filter((span)=>span !== this && spanUtils_spanToJSON(span).timestamp) : [];
        if (this._trimEnd && finishedSpans.length > 0) {
            const endTimes = finishedSpans.map((span)=>spanUtils_spanToJSON(span).timestamp).filter(Boolean);
            this._endTime = endTimes.reduce((prev, current)=>{
                return prev > current ? prev : current;
            });
        }
        const { scope: capturedSpanScope, isolationScope: capturedSpanIsolationScope } = getCapturedScopesOnSpan(this);
        // eslint-disable-next-line deprecation/deprecation
        const { metadata } = this;
        // eslint-disable-next-line deprecation/deprecation
        const { source } = metadata;
        const transaction = {
            contexts: {
                ...this._contexts,
                // We don't want to override trace context
                trace: spanToTraceContext(this)
            },
            // TODO: Pass spans serialized via `spanToJSON()` here instead in v8.
            spans: finishedSpans,
            start_timestamp: this._startTime,
            // eslint-disable-next-line deprecation/deprecation
            tags: this.tags,
            timestamp: this._endTime,
            transaction: this._name,
            type: "transaction",
            sdkProcessingMetadata: {
                ...metadata,
                capturedSpanScope,
                capturedSpanIsolationScope,
                ...dropUndefinedKeys({
                    dynamicSamplingContext: getDynamicSamplingContextFromSpan(this)
                })
            },
            _metrics_summary: getMetricSummaryJsonForSpan(this),
            ...source && {
                transaction_info: {
                    source
                }
            }
        };
        const hasMeasurements = Object.keys(this._measurements).length > 0;
        if (hasMeasurements) {
            esm_debug_build_DEBUG_BUILD && logger_logger.log("[Measurements] Adding measurements to transaction", JSON.stringify(this._measurements, undefined, 2));
            transaction.measurements = this._measurements;
        }
        // eslint-disable-next-line deprecation/deprecation
        esm_debug_build_DEBUG_BUILD && logger_logger.log(`[Tracing] Finishing ${this.op} transaction: ${this._name}.`);
        return transaction;
    }
}
 //# sourceMappingURL=transaction.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/core/esm/tracing/hubextensions.js








/** Returns all trace headers that are currently on the top scope. */ // eslint-disable-next-line deprecation/deprecation
function traceHeaders() {
    // eslint-disable-next-line deprecation/deprecation
    const scope = this.getScope();
    // eslint-disable-next-line deprecation/deprecation
    const span = scope.getSpan();
    return span ? {
        "sentry-trace": spanToTraceHeader(span)
    } : {};
}
/**
 * Creates a new transaction and adds a sampling decision if it doesn't yet have one.
 *
 * The Hub.startTransaction method delegates to this method to do its work, passing the Hub instance in as `this`, as if
 * it had been called on the hub directly. Exists as a separate function so that it can be injected into the class as an
 * "extension method."
 *
 * @param this: The Hub starting the transaction
 * @param transactionContext: Data used to configure the transaction
 * @param CustomSamplingContext: Optional data to be provided to the `tracesSampler` function (if any)
 *
 * @returns The new transaction
 *
 * @see {@link Hub.startTransaction}
 */ function _startTransaction(// eslint-disable-next-line deprecation/deprecation
transactionContext, customSamplingContext) {
    // eslint-disable-next-line deprecation/deprecation
    const client = this.getClient();
    const options = client && client.getOptions() || {};
    const configInstrumenter = options.instrumenter || "sentry";
    const transactionInstrumenter = transactionContext.instrumenter || "sentry";
    if (configInstrumenter !== transactionInstrumenter) {
        esm_debug_build_DEBUG_BUILD && logger_logger.error(`A transaction was started with instrumenter=\`${transactionInstrumenter}\`, but the SDK is configured with the \`${configInstrumenter}\` instrumenter.
The transaction will not be sampled. Please use the ${configInstrumenter} instrumentation to start transactions.`);
        // eslint-disable-next-line deprecation/deprecation
        transactionContext.sampled = false;
    }
    // eslint-disable-next-line deprecation/deprecation
    let transaction = new Transaction(transactionContext, this);
    transaction = sampling_sampleTransaction(transaction, options, {
        name: transactionContext.name,
        parentSampled: transactionContext.parentSampled,
        transactionContext,
        attributes: {
            // eslint-disable-next-line deprecation/deprecation
            ...transactionContext.data,
            ...transactionContext.attributes
        },
        ...customSamplingContext
    });
    if (transaction.isRecording()) {
        transaction.initSpanRecorder(options._experiments && options._experiments.maxSpans);
    }
    if (client && client.emit) {
        client.emit("startTransaction", transaction);
    }
    return transaction;
}
/**
 * Create new idle transaction.
 */ function startIdleTransaction(// eslint-disable-next-line deprecation/deprecation
hub, transactionContext, idleTimeout, finalTimeout, onScope, customSamplingContext, heartbeatInterval, delayAutoFinishUntilSignal = false) {
    // eslint-disable-next-line deprecation/deprecation
    const client = hub.getClient();
    const options = client && client.getOptions() || {};
    // eslint-disable-next-line deprecation/deprecation
    let transaction = new IdleTransaction(transactionContext, hub, idleTimeout, finalTimeout, heartbeatInterval, onScope, delayAutoFinishUntilSignal);
    transaction = sampleTransaction(transaction, options, {
        name: transactionContext.name,
        parentSampled: transactionContext.parentSampled,
        transactionContext,
        attributes: {
            // eslint-disable-next-line deprecation/deprecation
            ...transactionContext.data,
            ...transactionContext.attributes
        },
        ...customSamplingContext
    });
    if (transaction.isRecording()) {
        transaction.initSpanRecorder(options._experiments && options._experiments.maxSpans);
    }
    if (client && client.emit) {
        client.emit("startTransaction", transaction);
    }
    return transaction;
}
/**
 * Adds tracing extensions to the global hub.
 */ function addTracingExtensions() {
    const carrier = getMainCarrier();
    if (!carrier.__SENTRY__) {
        return;
    }
    carrier.__SENTRY__.extensions = carrier.__SENTRY__.extensions || {};
    if (!carrier.__SENTRY__.extensions.startTransaction) {
        carrier.__SENTRY__.extensions.startTransaction = _startTransaction;
    }
    if (!carrier.__SENTRY__.extensions.traceHeaders) {
        carrier.__SENTRY__.extensions.traceHeaders = traceHeaders;
    }
    registerErrorInstrumentation();
}
 //# sourceMappingURL=hubextensions.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/utils/esm/requestdata.js






const DEFAULT_INCLUDES = {
    ip: false,
    request: true,
    transaction: true,
    user: true
};
const DEFAULT_REQUEST_INCLUDES = (/* unused pure expression or super */ null && ([
    "cookies",
    "data",
    "headers",
    "method",
    "query_string",
    "url"
]));
const DEFAULT_USER_INCLUDES = (/* unused pure expression or super */ null && ([
    "id",
    "username",
    "email"
]));
/**
 * Sets parameterized route as transaction name e.g.: `GET /users/:id`
 * Also adds more context data on the transaction from the request.
 *
 * @deprecated This utility will be removed in v8.
 */ function addRequestDataToTransaction(transaction, req, deps) {
    if (!transaction) return;
    // eslint-disable-next-line deprecation/deprecation
    if (!transaction.metadata.source || transaction.metadata.source === "url") {
        // Attempt to grab a parameterized route off of the request
        const [name, source] = extractPathForTransaction(req, {
            path: true,
            method: true
        });
        transaction.updateName(name);
        // TODO: SEMANTIC_ATTRIBUTE_SENTRY_SOURCE is in core, align this once we merge utils & core
        // eslint-disable-next-line deprecation/deprecation
        transaction.setMetadata({
            source
        });
    }
    transaction.setAttribute("url", req.originalUrl || req.url);
    if (req.baseUrl) {
        transaction.setAttribute("baseUrl", req.baseUrl);
    }
    // TODO: We need to rewrite this to a flat format?
    // eslint-disable-next-line deprecation/deprecation
    transaction.setData("query", extractQueryParams(req, deps));
}
/**
 * Extracts a complete and parameterized path from the request object and uses it to construct transaction name.
 * If the parameterized transaction name cannot be extracted, we fall back to the raw URL.
 *
 * Additionally, this function determines and returns the transaction name source
 *
 * eg. GET /mountpoint/user/:id
 *
 * @param req A request object
 * @param options What to include in the transaction name (method, path, or a custom route name to be
 *                used instead of the request's route)
 *
 * @returns A tuple of the fully constructed transaction name [0] and its source [1] (can be either 'route' or 'url')
 */ function extractPathForTransaction(req, options = {}) {
    const method = req.method && req.method.toUpperCase();
    let path = "";
    let source = "url";
    // Check to see if there's a parameterized route we can use (as there is in Express)
    if (options.customRoute || req.route) {
        path = options.customRoute || `${req.baseUrl || ""}${req.route && req.route.path}`;
        source = "route";
    } else if (req.originalUrl || req.url) {
        path = stripUrlQueryAndFragment(req.originalUrl || req.url || "");
    }
    let name = "";
    if (options.method && method) {
        name += method;
    }
    if (options.method && options.path) {
        name += " ";
    }
    if (options.path && path) {
        name += path;
    }
    return [
        name,
        source
    ];
}
/** JSDoc */ function extractTransaction(req, type) {
    switch(type){
        case "path":
            {
                return extractPathForTransaction(req, {
                    path: true
                })[0];
            }
        case "handler":
            {
                return req.route && req.route.stack && req.route.stack[0] && req.route.stack[0].name || "<anonymous>";
            }
        case "methodPath":
        default:
            {
                // if exist _reconstructedRoute return that path instead of route.path
                const customRoute = req._reconstructedRoute ? req._reconstructedRoute : undefined;
                return extractPathForTransaction(req, {
                    path: true,
                    method: true,
                    customRoute
                })[0];
            }
    }
}
/** JSDoc */ function extractUserData(user, keys) {
    const extractedUser = {};
    const attributes = Array.isArray(keys) ? keys : DEFAULT_USER_INCLUDES;
    attributes.forEach((key)=>{
        if (user && key in user) {
            extractedUser[key] = user[key];
        }
    });
    return extractedUser;
}
/**
 * Normalize data from the request object, accounting for framework differences.
 *
 * @param req The request object from which to extract data
 * @param options.include An optional array of keys to include in the normalized data. Defaults to
 * DEFAULT_REQUEST_INCLUDES if not provided.
 * @param options.deps Injected, platform-specific dependencies
 * @returns An object containing normalized request data
 */ function extractRequestData(req, options) {
    const { include = DEFAULT_REQUEST_INCLUDES, deps } = options || {};
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    const requestData = {};
    // headers:
    //   node, express, koa, nextjs: req.headers
    const headers = req.headers || {};
    // method:
    //   node, express, koa, nextjs: req.method
    const method = req.method;
    // host:
    //   express: req.hostname in > 4 and req.host in < 4
    //   koa: req.host
    //   node, nextjs: req.headers.host
    // Express 4 mistakenly strips off port number from req.host / req.hostname so we can't rely on them
    // See: https://github.com/expressjs/express/issues/3047#issuecomment-236653223
    // Also: https://github.com/getsentry/sentry-javascript/issues/1917
    const host = headers.host || req.hostname || req.host || "<no host>";
    // protocol:
    //   node, nextjs: <n/a>
    //   express, koa: req.protocol
    const protocol = req.protocol === "https" || req.socket && req.socket.encrypted ? "https" : "http";
    // url (including path and query string):
    //   node, express: req.originalUrl
    //   koa, nextjs: req.url
    const originalUrl = req.originalUrl || req.url || "";
    // absolute url
    const absoluteUrl = originalUrl.startsWith(protocol) ? originalUrl : `${protocol}://${host}${originalUrl}`;
    include.forEach((key)=>{
        switch(key){
            case "headers":
                {
                    requestData.headers = headers;
                    // Remove the Cookie header in case cookie data should not be included in the event
                    if (!include.includes("cookies")) {
                        delete requestData.headers.cookie;
                    }
                    break;
                }
            case "method":
                {
                    requestData.method = method;
                    break;
                }
            case "url":
                {
                    requestData.url = absoluteUrl;
                    break;
                }
            case "cookies":
                {
                    // cookies:
                    //   node, express, koa: req.headers.cookie
                    //   vercel, sails.js, express (w/ cookie middleware), nextjs: req.cookies
                    requestData.cookies = // TODO (v8 / #5257): We're only sending the empty object for backwards compatibility, so the last bit can
                    // come off in v8
                    req.cookies || headers.cookie && parseCookie(headers.cookie) || {};
                    break;
                }
            case "query_string":
                {
                    // query string:
                    //   node: req.url (raw)
                    //   express, koa, nextjs: req.query
                    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
                    requestData.query_string = extractQueryParams(req, deps);
                    break;
                }
            case "data":
                {
                    if (method === "GET" || method === "HEAD") {
                        break;
                    }
                    // body data:
                    //   express, koa, nextjs: req.body
                    //
                    //   when using node by itself, you have to read the incoming stream(see
                    //   https://nodejs.dev/learn/get-http-request-body-data-using-nodejs); if a user is doing that, we can't know
                    //   where they're going to store the final result, so they'll have to capture this data themselves
                    if (req.body !== undefined) {
                        requestData.data = isString(req.body) ? req.body : JSON.stringify(normalize(req.body));
                    }
                    break;
                }
            default:
                {
                    if (({}).hasOwnProperty.call(req, key)) {
                        requestData[key] = req[key];
                    }
                }
        }
    });
    return requestData;
}
/**
 * Add data from the given request to the given event
 *
 * @param event The event to which the request data will be added
 * @param req Request object
 * @param options.include Flags to control what data is included
 * @param options.deps Injected platform-specific dependencies
 * @returns The mutated `Event` object
 */ function addRequestDataToEvent(event, req, options) {
    const include = {
        ...DEFAULT_INCLUDES,
        ...options && options.include
    };
    if (include.request) {
        const extractedRequestData = Array.isArray(include.request) ? extractRequestData(req, {
            include: include.request,
            deps: options && options.deps
        }) : extractRequestData(req, {
            deps: options && options.deps
        });
        event.request = {
            ...event.request,
            ...extractedRequestData
        };
    }
    if (include.user) {
        const extractedUser = req.user && isPlainObject(req.user) ? extractUserData(req.user, include.user) : {};
        if (Object.keys(extractedUser).length) {
            event.user = {
                ...event.user,
                ...extractedUser
            };
        }
    }
    // client ip:
    //   node, nextjs: req.socket.remoteAddress
    //   express, koa: req.ip
    if (include.ip) {
        const ip = req.ip || req.socket && req.socket.remoteAddress;
        if (ip) {
            event.user = {
                ...event.user,
                ip_address: ip
            };
        }
    }
    if (include.transaction && !event.transaction) {
        // TODO do we even need this anymore?
        // TODO make this work for nextjs
        event.transaction = extractTransaction(req, include.transaction);
    }
    return event;
}
function extractQueryParams(req, deps) {
    // url (including path and query string):
    //   node, express: req.originalUrl
    //   koa, nextjs: req.url
    let originalUrl = req.originalUrl || req.url || "";
    if (!originalUrl) {
        return;
    }
    // The `URL` constructor can't handle internal URLs of the form `/some/path/here`, so stick a dummy protocol and
    // hostname on the beginning. Since the point here is just to grab the query string, it doesn't matter what we use.
    if (originalUrl.startsWith("/")) {
        originalUrl = `http://dogs.are.great${originalUrl}`;
    }
    try {
        return req.query || typeof URL !== "undefined" && new URL(originalUrl).search.slice(1) || // In Node 8, `URL` isn't in the global scope, so we have to use the built-in module from Node
        deps && deps.url && deps.url.parse(originalUrl).query || undefined;
    } catch (e2) {
        return undefined;
    }
}
/**
 * Transforms a `Headers` object that implements the `Web Fetch API` (https://developer.mozilla.org/en-US/docs/Web/API/Headers) into a simple key-value dict.
 * The header keys will be lower case: e.g. A "Content-Type" header will be stored as "content-type".
 */ // TODO(v8): Make this function return undefined when the extraction fails.
function winterCGHeadersToDict(winterCGHeaders) {
    const headers = {};
    try {
        winterCGHeaders.forEach((value, key)=>{
            if (typeof value === "string") {
                // We check that value is a string even though it might be redundant to make sure prototype pollution is not possible.
                headers[key] = value;
            }
        });
    } catch (e) {
        debug_build_DEBUG_BUILD && logger_logger.warn("Sentry failed extracting headers from a request object. If you see this, please file an issue.");
    }
    return headers;
}
/**
 * Converts a `Request` object that implements the `Web Fetch API` (https://developer.mozilla.org/en-US/docs/Web/API/Headers) into the format that the `RequestData` integration understands.
 */ function winterCGRequestToRequestData(req) {
    const headers = winterCGHeadersToDict(req.headers);
    return {
        method: req.method,
        url: req.url,
        headers
    };
}
 //# sourceMappingURL=requestdata.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/nextjs/esm/common/debug-build.js
/**
 * This serves as a build time flag that will be true by default, but false in non-debug builds or if users replace `__SENTRY_DEBUG__` in their generated code.
 *
 * ATTENTION: This constant must never cross package boundaries (i.e. be exported) to guarantee that it can be used for tree shaking.
 */ const common_debug_build_DEBUG_BUILD = typeof __SENTRY_DEBUG__ === "undefined" || __SENTRY_DEBUG__;
 //# sourceMappingURL=debug-build.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/nextjs/esm/common/utils/responseEnd.js



/**
 * Wrap `res.end()` so that it ends the span and flushes events before letting the request finish.
 *
 * Note: This wraps a sync method with an async method. While in general that's not a great idea in terms of keeping
 * things in the right order, in this case it's safe, because the native `.end()` actually *is* (effectively) async, and
 * its run actually *is* (literally) awaited, just manually so (which reflects the fact that the core of the
 * request/response code in Node by far predates the introduction of `async`/`await`). When `.end()` is done, it emits
 * the `prefinish` event, and only once that fires does request processing continue. See
 * https://github.com/nodejs/node/commit/7c9b607048f13741173d397795bac37707405ba7.
 *
 * Also note: `res.end()` isn't called until *after* all response data and headers have been sent, so blocking inside of
 * `end` doesn't delay data getting to the end user. See
 * https://nodejs.org/api/http.html#responseenddata-encoding-callback.
 *
 * @param span The span tracking the request
 * @param res: The request's corresponding response
 */ function autoEndSpanOnResponseEnd(span, res) {
    const wrapEndMethod = (origEnd)=>{
        return function sentryWrappedEnd(...args) {
            finishSpan(span, this);
            return origEnd.call(this, ...args);
        };
    };
    // Prevent double-wrapping
    // res.end may be undefined during build when using `next export` to statically export a Next.js app
    if (res.end && !res.end.__sentry_original__) {
        fill(res, "end", wrapEndMethod);
    }
}
/** Finish the given response's span and set HTTP status data */ function finishSpan(span, res) {
    if (span) {
        setHttpStatus(span, res.statusCode);
        span.end();
    }
}
/** Flush the event queue to ensure that events get sent to Sentry before the response is finished and the lambda ends */ async function flushQueue() {
    try {
        common_debug_build_DEBUG_BUILD && logger_logger.log("Flushing events...");
        await flush(2000);
        common_debug_build_DEBUG_BUILD && logger_logger.log("Done flushing events");
    } catch (e) {
        common_debug_build_DEBUG_BUILD && logger_logger.log("Error while flushing events:\n", e);
    }
}
 //# sourceMappingURL=responseEnd.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/nextjs/esm/common/utils/edgeWrapperUtils.js



/**
 * Wraps a function on the edge runtime with error and performance monitoring.
 */ function withEdgeWrapping(handler, options) {
    return async function(...args) {
        addTracingExtensions();
        const req = args[0];
        let sentryTrace;
        let baggage;
        if (req instanceof Request) {
            sentryTrace = req.headers.get("sentry-trace") || "";
            baggage = req.headers.get("baggage");
        }
        return continueTrace({
            sentryTrace,
            baggage
        }, ()=>{
            return startSpan({
                name: options.spanDescription,
                op: options.spanOp,
                attributes: {
                    [SEMANTIC_ATTRIBUTE_SENTRY_SOURCE]: "route",
                    [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: "auto.function.nextjs.withEdgeWrapping"
                },
                metadata: {
                    request: req instanceof Request ? winterCGRequestToRequestData(req) : undefined
                }
            }, async (span)=>{
                const handlerResult = await handleCallbackErrors_handleCallbackErrors(()=>handler.apply(this, args), (error)=>{
                    captureException(error, {
                        mechanism: {
                            type: "instrument",
                            handled: false,
                            data: {
                                function: options.mechanismFunctionName
                            }
                        }
                    });
                });
                if (span) {
                    if (handlerResult instanceof Response) {
                        spanstatus_setHttpStatus(span, handlerResult.status);
                    } else {
                        span.setStatus("ok");
                    }
                }
                return handlerResult;
            }).finally(()=>flushQueue());
        });
    };
}
 //# sourceMappingURL=edgeWrapperUtils.js.map

;// CONCATENATED MODULE: ./node_modules/@sentry/nextjs/esm/common/wrapMiddlewareWithSentry.js

/**
 * Wraps Next.js middleware with Sentry error and performance instrumentation.
 *
 * @param middleware The middleware handler.
 * @returns a wrapped middleware handler.
 */ function wrapMiddlewareWithSentry(middleware) {
    return new Proxy(middleware, {
        apply: (wrappingTarget, thisArg, args)=>{
            return withEdgeWrapping(wrappingTarget, {
                spanDescription: "middleware",
                spanOp: "middleware.nextjs",
                mechanismFunctionName: "withSentryMiddleware"
            }).apply(thisArg, args);
        }
    });
}
 //# sourceMappingURL=wrapMiddlewareWithSentry.js.map

;// CONCATENATED MODULE: ./node_modules/next/dist/esm/server/web/exports/next-response.js
// This file is for modularized imports for next/server to get fully-treeshaking.
 //# sourceMappingURL=next-response.js.map

;// CONCATENATED MODULE: ./src/middleware.ts



// Sanctioned Countries: Belarus, Cuba, Democratic Republic of Congo, Iran, Iraq, North Korea, Sudan, Syria, Zimbabwe.
const BLOCK_COUNTRIES = {
    BY: "BY",
    CU: "CU",
    CD: "CD",
    IR: "IR",
    IQ: "IQ",
    KP: "KP",
    SD: "SD",
    SY: "SY",
    ZW: "ZW"
};
// Sanctioned Regions: Crimea
const BLOCK_REGIONS = {
    "UA-43": "UA-43"
};
async function middleware$1(req) {
    const res = NextResponse.next();
    const { geo } = req;
    const { country, region } = geo;
    const shouldBlock = BLOCK_COUNTRIES[country] || BLOCK_REGIONS[`${country}-${region}`];
    if (shouldBlock) {
        return NextResponse.redirect(new URL("/451", req.url));
    }
    return res;
}
const config = {
    matcher: [
        "/",
        "/swap",
        "/pool",
        "/pools",
        "/farms",
        "/add",
        "/ifo",
        "/remove",
        "/prediction",
        "/find",
        "/limit-orders",
        "/lottery",
        "/nfts"
    ]
};

var serverComponentModule = /*#__PURE__*/Object.freeze({
    __proto__: null,
    middleware: middleware$1,
    config: config
});

/*
 * This file is a template for the code which will be substituted when our webpack loader handles middleware files.
 *
 * We use `__SENTRY_WRAPPING_TARGET_FILE__.cjs` as a placeholder for the path to the file being wrapped. Because it's not a real package,
 * this causes both TS and ESLint to complain, hence the pragma comments below.
 */

const userApiModule = serverComponentModule ;

// Default to undefined. It's possible for Next.js users to not define any exports/handlers in an API route. If that is
// the case Next.js wil crash during runtime but the Sentry SDK should definitely not crash so we need tohandle it.
let userProvidedNamedHandler = undefined;
let userProvidedDefaultHandler = undefined;

if ('middleware' in userApiModule && typeof userApiModule.middleware === 'function') {
  // Handle when user defines via named ESM export: `export { middleware };`
  userProvidedNamedHandler = userApiModule.middleware;
} else if ('default' in userApiModule && typeof userApiModule.default === 'function') {
  // Handle when user defines via ESM export: `export default myFunction;`
  userProvidedDefaultHandler = userApiModule.default;
} else if (typeof userApiModule === 'function') {
  // Handle when user defines via CJS export: "module.exports = myFunction;"
  userProvidedDefaultHandler = userApiModule;
}

const middleware = userProvidedNamedHandler
  ? wrapMiddlewareWithSentry(userProvidedNamedHandler)
  : undefined;
const middlewareWrapperTemplate = userProvidedDefaultHandler ? wrapMiddlewareWithSentry(userProvidedDefaultHandler) : undefined;



;// CONCATENATED MODULE: ./node_modules/next/dist/build/webpack/loaders/next-middleware-loader.js?absolutePagePath=private-next-root-dir%2Fsrc%2Fmiddleware.ts&page=%2Fsrc%2Fmiddleware&rootDir=%2FUsers%2Frocket%2FDocuments%2Fwork%2FArchive&matchers=W3sicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpPyg%2FOlxcLyhcXC8%2FaW5kZXh8XFwvP2luZGV4XFwuanNvbikpP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvc3dhcCguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9zd2FwIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvcG9vbCguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9wb29sIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvcG9vbHMoLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvcG9vbHMifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9mYXJtcyguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9mYXJtcyJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL2FkZCguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9hZGQifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9pZm8oLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvaWZvIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvcmVtb3ZlKC5qc29uKT9bXFwvI1xcP10%2FJCIsIm9yaWdpbmFsU291cmNlIjoiL3JlbW92ZSJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL3ByZWRpY3Rpb24oLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvcHJlZGljdGlvbiJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL2ZpbmQoLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvZmluZCJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL2xpbWl0LW9yZGVycyguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9saW1pdC1vcmRlcnMifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9sb3R0ZXJ5KC5qc29uKT9bXFwvI1xcP10%2FJCIsIm9yaWdpbmFsU291cmNlIjoiL2xvdHRlcnkifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9uZnRzKC5qc29uKT9bXFwvI1xcP10%2FJCIsIm9yaWdpbmFsU291cmNlIjoiL25mdHMifV0%3D&preferredRegion=&middlewareConfig=eyJtYXRjaGVycyI6W3sicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpPyg%2FOlxcLyhcXC8%2FaW5kZXh8XFwvP2luZGV4XFwuanNvbikpP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvc3dhcCguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9zd2FwIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvcG9vbCguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9wb29sIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvcG9vbHMoLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvcG9vbHMifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9mYXJtcyguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9mYXJtcyJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL2FkZCguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9hZGQifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9pZm8oLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvaWZvIn0seyJyZWdleHAiOiJeKD86XFwvKF9uZXh0XFwvZGF0YVxcL1teL117MSx9KSk%2FXFwvcmVtb3ZlKC5qc29uKT9bXFwvI1xcP10%2FJCIsIm9yaWdpbmFsU291cmNlIjoiL3JlbW92ZSJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL3ByZWRpY3Rpb24oLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvcHJlZGljdGlvbiJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL2ZpbmQoLmpzb24pP1tcXC8jXFw%2FXT8kIiwib3JpZ2luYWxTb3VyY2UiOiIvZmluZCJ9LHsicmVnZXhwIjoiXig%2FOlxcLyhfbmV4dFxcL2RhdGFcXC9bXi9dezEsfSkpP1xcL2xpbWl0LW9yZGVycyguanNvbik%2FW1xcLyNcXD9dPyQiLCJvcmlnaW5hbFNvdXJjZSI6Ii9saW1pdC1vcmRlcnMifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9sb3R0ZXJ5KC5qc29uKT9bXFwvI1xcP10%2FJCIsIm9yaWdpbmFsU291cmNlIjoiL2xvdHRlcnkifSx7InJlZ2V4cCI6Il4oPzpcXC8oX25leHRcXC9kYXRhXFwvW14vXXsxLH0pKT9cXC9uZnRzKC5qc29uKT9bXFwvI1xcP10%2FJCIsIm9yaWdpbmFsU291cmNlIjoiL25mdHMifV19!


// Import the userland code.

const mod = {
    ...middleware_namespaceObject
};
const handler = mod.middleware || mod.default;
const page = "/src/middleware";
if (typeof handler !== "function") {
    throw new Error(`The Middleware "${page}" must export a \`middleware\` or a \`default\` function`);
}
function nHandler(opts) {
    return adapter({
        ...opts,
        page,
        handler
    });
}

//# sourceMappingURL=middleware.js.map

/***/ }),

/***/ 7:
/***/ ((module) => {

"use strict";

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
// src/index.ts
var src_exports = {};
__export(src_exports, {
    RequestCookies: ()=>RequestCookies,
    ResponseCookies: ()=>ResponseCookies,
    parseCookie: ()=>parseCookie,
    parseSetCookie: ()=>parseSetCookie,
    stringifyCookie: ()=>stringifyCookie
});
module.exports = __toCommonJS(src_exports);
// src/serialize.ts
function stringifyCookie(c) {
    var _a;
    const attrs = [
        "path" in c && c.path && `Path=${c.path}`,
        "expires" in c && (c.expires || c.expires === 0) && `Expires=${(typeof c.expires === "number" ? new Date(c.expires) : c.expires).toUTCString()}`,
        "maxAge" in c && typeof c.maxAge === "number" && `Max-Age=${c.maxAge}`,
        "domain" in c && c.domain && `Domain=${c.domain}`,
        "secure" in c && c.secure && "Secure",
        "httpOnly" in c && c.httpOnly && "HttpOnly",
        "sameSite" in c && c.sameSite && `SameSite=${c.sameSite}`,
        "priority" in c && c.priority && `Priority=${c.priority}`
    ].filter(Boolean);
    return `${c.name}=${encodeURIComponent((_a = c.value) != null ? _a : "")}; ${attrs.join("; ")}`;
}
function parseCookie(cookie) {
    const map = /* @__PURE__ */ new Map();
    for (const pair of cookie.split(/; */)){
        if (!pair) continue;
        const splitAt = pair.indexOf("=");
        if (splitAt === -1) {
            map.set(pair, "true");
            continue;
        }
        const [key, value] = [
            pair.slice(0, splitAt),
            pair.slice(splitAt + 1)
        ];
        try {
            map.set(key, decodeURIComponent(value != null ? value : "true"));
        } catch  {}
    }
    return map;
}
function parseSetCookie(setCookie) {
    if (!setCookie) {
        return void 0;
    }
    const [[name, value], ...attributes] = parseCookie(setCookie);
    const { domain, expires, httponly, maxage, path, samesite, secure, priority } = Object.fromEntries(attributes.map(([key, value2])=>[
            key.toLowerCase(),
            value2
        ]));
    const cookie = {
        name,
        value: decodeURIComponent(value),
        domain,
        ...expires && {
            expires: new Date(expires)
        },
        ...httponly && {
            httpOnly: true
        },
        ...typeof maxage === "string" && {
            maxAge: Number(maxage)
        },
        path,
        ...samesite && {
            sameSite: parseSameSite(samesite)
        },
        ...secure && {
            secure: true
        },
        ...priority && {
            priority: parsePriority(priority)
        }
    };
    return compact(cookie);
}
function compact(t) {
    const newT = {};
    for(const key in t){
        if (t[key]) {
            newT[key] = t[key];
        }
    }
    return newT;
}
var SAME_SITE = [
    "strict",
    "lax",
    "none"
];
function parseSameSite(string) {
    string = string.toLowerCase();
    return SAME_SITE.includes(string) ? string : void 0;
}
var PRIORITY = [
    "low",
    "medium",
    "high"
];
function parsePriority(string) {
    string = string.toLowerCase();
    return PRIORITY.includes(string) ? string : void 0;
}
function splitCookiesString(cookiesString) {
    if (!cookiesString) return [];
    var cookiesStrings = [];
    var pos = 0;
    var start;
    var ch;
    var lastComma;
    var nextStart;
    var cookiesSeparatorFound;
    function skipWhitespace() {
        while(pos < cookiesString.length && /\s/.test(cookiesString.charAt(pos))){
            pos += 1;
        }
        return pos < cookiesString.length;
    }
    function notSpecialChar() {
        ch = cookiesString.charAt(pos);
        return ch !== "=" && ch !== ";" && ch !== ",";
    }
    while(pos < cookiesString.length){
        start = pos;
        cookiesSeparatorFound = false;
        while(skipWhitespace()){
            ch = cookiesString.charAt(pos);
            if (ch === ",") {
                lastComma = pos;
                pos += 1;
                skipWhitespace();
                nextStart = pos;
                while(pos < cookiesString.length && notSpecialChar()){
                    pos += 1;
                }
                if (pos < cookiesString.length && cookiesString.charAt(pos) === "=") {
                    cookiesSeparatorFound = true;
                    pos = nextStart;
                    cookiesStrings.push(cookiesString.substring(start, lastComma));
                    start = pos;
                } else {
                    pos = lastComma + 1;
                }
            } else {
                pos += 1;
            }
        }
        if (!cookiesSeparatorFound || pos >= cookiesString.length) {
            cookiesStrings.push(cookiesString.substring(start, cookiesString.length));
        }
    }
    return cookiesStrings;
}
// src/request-cookies.ts
var RequestCookies = class {
    constructor(requestHeaders){
        /** @internal */ this._parsed = /* @__PURE__ */ new Map();
        this._headers = requestHeaders;
        const header = requestHeaders.get("cookie");
        if (header) {
            const parsed = parseCookie(header);
            for (const [name, value] of parsed){
                this._parsed.set(name, {
                    name,
                    value
                });
            }
        }
    }
    [Symbol.iterator]() {
        return this._parsed[Symbol.iterator]();
    }
    /**
   * The amount of cookies received from the client
   */ get size() {
        return this._parsed.size;
    }
    get(...args) {
        const name = typeof args[0] === "string" ? args[0] : args[0].name;
        return this._parsed.get(name);
    }
    getAll(...args) {
        var _a;
        const all = Array.from(this._parsed);
        if (!args.length) {
            return all.map(([_, value])=>value);
        }
        const name = typeof args[0] === "string" ? args[0] : (_a = args[0]) == null ? void 0 : _a.name;
        return all.filter(([n])=>n === name).map(([_, value])=>value);
    }
    has(name) {
        return this._parsed.has(name);
    }
    set(...args) {
        const [name, value] = args.length === 1 ? [
            args[0].name,
            args[0].value
        ] : args;
        const map = this._parsed;
        map.set(name, {
            name,
            value
        });
        this._headers.set("cookie", Array.from(map).map(([_, value2])=>stringifyCookie(value2)).join("; "));
        return this;
    }
    /**
   * Delete the cookies matching the passed name or names in the request.
   */ delete(names) {
        const map = this._parsed;
        const result = !Array.isArray(names) ? map.delete(names) : names.map((name)=>map.delete(name));
        this._headers.set("cookie", Array.from(map).map(([_, value])=>stringifyCookie(value)).join("; "));
        return result;
    }
    /**
   * Delete all the cookies in the cookies in the request.
   */ clear() {
        this.delete(Array.from(this._parsed.keys()));
        return this;
    }
    /**
   * Format the cookies in the request as a string for logging
   */ [Symbol.for("edge-runtime.inspect.custom")]() {
        return `RequestCookies ${JSON.stringify(Object.fromEntries(this._parsed))}`;
    }
    toString() {
        return [
            ...this._parsed.values()
        ].map((v)=>`${v.name}=${encodeURIComponent(v.value)}`).join("; ");
    }
};
// src/response-cookies.ts
var ResponseCookies = class {
    constructor(responseHeaders){
        /** @internal */ this._parsed = /* @__PURE__ */ new Map();
        var _a, _b, _c;
        this._headers = responseHeaders;
        const setCookie = (_c = (_b = (_a = responseHeaders.getSetCookie) == null ? void 0 : _a.call(responseHeaders)) != null ? _b : responseHeaders.get("set-cookie")) != null ? _c : [];
        const cookieStrings = Array.isArray(setCookie) ? setCookie : splitCookiesString(setCookie);
        for (const cookieString of cookieStrings){
            const parsed = parseSetCookie(cookieString);
            if (parsed) this._parsed.set(parsed.name, parsed);
        }
    }
    /**
   * {@link https://wicg.github.io/cookie-store/#CookieStore-get CookieStore#get} without the Promise.
   */ get(...args) {
        const key = typeof args[0] === "string" ? args[0] : args[0].name;
        return this._parsed.get(key);
    }
    /**
   * {@link https://wicg.github.io/cookie-store/#CookieStore-getAll CookieStore#getAll} without the Promise.
   */ getAll(...args) {
        var _a;
        const all = Array.from(this._parsed.values());
        if (!args.length) {
            return all;
        }
        const key = typeof args[0] === "string" ? args[0] : (_a = args[0]) == null ? void 0 : _a.name;
        return all.filter((c)=>c.name === key);
    }
    has(name) {
        return this._parsed.has(name);
    }
    /**
   * {@link https://wicg.github.io/cookie-store/#CookieStore-set CookieStore#set} without the Promise.
   */ set(...args) {
        const [name, value, cookie] = args.length === 1 ? [
            args[0].name,
            args[0].value,
            args[0]
        ] : args;
        const map = this._parsed;
        map.set(name, normalizeCookie({
            name,
            value,
            ...cookie
        }));
        replace(map, this._headers);
        return this;
    }
    /**
   * {@link https://wicg.github.io/cookie-store/#CookieStore-delete CookieStore#delete} without the Promise.
   */ delete(...args) {
        const [name, path, domain] = typeof args[0] === "string" ? [
            args[0]
        ] : [
            args[0].name,
            args[0].path,
            args[0].domain
        ];
        return this.set({
            name,
            path,
            domain,
            value: "",
            expires: /* @__PURE__ */ new Date(0)
        });
    }
    [Symbol.for("edge-runtime.inspect.custom")]() {
        return `ResponseCookies ${JSON.stringify(Object.fromEntries(this._parsed))}`;
    }
    toString() {
        return [
            ...this._parsed.values()
        ].map(stringifyCookie).join("; ");
    }
};
function replace(bag, headers) {
    headers.delete("set-cookie");
    for (const [, value] of bag){
        const serialized = stringifyCookie(value);
        headers.append("set-cookie", serialized);
    }
}
function normalizeCookie(cookie = {
    name: "",
    value: ""
}) {
    if (typeof cookie.expires === "number") {
        cookie.expires = new Date(cookie.expires);
    }
    if (cookie.maxAge) {
        cookie.expires = new Date(Date.now() + cookie.maxAge * 1e3);
    }
    if (cookie.path === null || cookie.path === void 0) {
        cookie.path = "/";
    }
    return cookie;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (0);


/***/ }),

/***/ 666:
/***/ ((module) => {

"use strict";
var __dirname = "/";

(()=>{
    "use strict";
    if (typeof __nccwpck_require__ !== "undefined") __nccwpck_require__.ab = __dirname + "/";
    var e = {};
    (()=>{
        var r = e;
        /*!
 * cookie
 * Copyright(c) 2012-2014 Roman Shtylman
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */ r.parse = parse;
        r.serialize = serialize;
        var i = decodeURIComponent;
        var t = encodeURIComponent;
        var a = /; */;
        var n = /^[\u0009\u0020-\u007e\u0080-\u00ff]+$/;
        function parse(e, r) {
            if (typeof e !== "string") {
                throw new TypeError("argument str must be a string");
            }
            var t = {};
            var n = r || {};
            var o = e.split(a);
            var s = n.decode || i;
            for(var p = 0; p < o.length; p++){
                var f = o[p];
                var u = f.indexOf("=");
                if (u < 0) {
                    continue;
                }
                var v = f.substr(0, u).trim();
                var c = f.substr(++u, f.length).trim();
                if ('"' == c[0]) {
                    c = c.slice(1, -1);
                }
                if (undefined == t[v]) {
                    t[v] = tryDecode(c, s);
                }
            }
            return t;
        }
        function serialize(e, r, i) {
            var a = i || {};
            var o = a.encode || t;
            if (typeof o !== "function") {
                throw new TypeError("option encode is invalid");
            }
            if (!n.test(e)) {
                throw new TypeError("argument name is invalid");
            }
            var s = o(r);
            if (s && !n.test(s)) {
                throw new TypeError("argument val is invalid");
            }
            var p = e + "=" + s;
            if (null != a.maxAge) {
                var f = a.maxAge - 0;
                if (isNaN(f) || !isFinite(f)) {
                    throw new TypeError("option maxAge is invalid");
                }
                p += "; Max-Age=" + Math.floor(f);
            }
            if (a.domain) {
                if (!n.test(a.domain)) {
                    throw new TypeError("option domain is invalid");
                }
                p += "; Domain=" + a.domain;
            }
            if (a.path) {
                if (!n.test(a.path)) {
                    throw new TypeError("option path is invalid");
                }
                p += "; Path=" + a.path;
            }
            if (a.expires) {
                if (typeof a.expires.toUTCString !== "function") {
                    throw new TypeError("option expires is invalid");
                }
                p += "; Expires=" + a.expires.toUTCString();
            }
            if (a.httpOnly) {
                p += "; HttpOnly";
            }
            if (a.secure) {
                p += "; Secure";
            }
            if (a.sameSite) {
                var u = typeof a.sameSite === "string" ? a.sameSite.toLowerCase() : a.sameSite;
                switch(u){
                    case true:
                        p += "; SameSite=Strict";
                        break;
                    case "lax":
                        p += "; SameSite=Lax";
                        break;
                    case "strict":
                        p += "; SameSite=Strict";
                        break;
                    case "none":
                        p += "; SameSite=None";
                        break;
                    default:
                        throw new TypeError("option sameSite is invalid");
                }
            }
            return p;
        }
        function tryDecode(e, r) {
            try {
                return r(e);
            } catch (r) {
                return e;
            }
        }
    })();
    module.exports = e;
})();


/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ var __webpack_exports__ = (__webpack_exec__(488));
/******/ (_ENTRIES = typeof _ENTRIES === "undefined" ? {} : _ENTRIES)["middleware_src/middleware"] = __webpack_exports__;
/******/ }
]);
//# sourceMappingURL=middleware.js.map